/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.ReferenceCountUtil;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.remoting.impl.netty.HttpKeepAliveRunnable;

public class HttpAcceptorHandler
extends ChannelDuplexHandler {
    private final BlockingQueue<ResponseHolder> responses = new LinkedBlockingQueue<ResponseHolder>();
    private final BlockingQueue<Runnable> delayedResponses = new LinkedBlockingQueue<Runnable>();
    private final ExecutorService executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, this.delayedResponses);
    private final HttpKeepAliveRunnable httpKeepAliveTask;
    private final long responseTime;
    private Channel channel;

    public HttpAcceptorHandler(HttpKeepAliveRunnable httpKeepAliveTask, long responseTime, Channel channel) {
        this.responseTime = responseTime;
        this.httpKeepAliveTask = httpKeepAliveTask;
        this.channel = channel;
        httpKeepAliveTask.registerKeepAliveHandler(this);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        this.httpKeepAliveTask.unregisterKeepAliveHandler(this);
        this.channel = null;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        FullHttpRequest request = (FullHttpRequest)msg;
        HttpMethod method = request.method();
        if (method.equals((Object)HttpMethod.POST)) {
            ctx.fireChannelRead(ReferenceCountUtil.retain((Object)((FullHttpRequest)msg).content()));
            this.responses.put(new ResponseHolder(System.currentTimeMillis() + this.responseTime, (FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK)));
            ReferenceCountUtil.release((Object)msg);
            return;
        }
        super.channelRead(ctx, msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof ByteBuf) {
            this.executor.execute(new ResponseRunner((ByteBuf)msg, promise));
        } else {
            ctx.write(msg, promise);
        }
    }

    public void keepAlive(long time) {
        int lateResponses = 0;
        for (ResponseHolder response : this.responses) {
            if (response.timeReceived >= time) break;
            ++lateResponses;
        }
        for (int i = 0; i < lateResponses; ++i) {
            this.executor.execute(new ResponseRunner());
        }
    }

    public void shutdown() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.executor.shutdownNow();
        }
        this.responses.clear();
    }

    private static final class ResponseHolder {
        final FullHttpResponse response;
        final long timeReceived;

        private ResponseHolder(long timeReceived, FullHttpResponse response) {
            this.timeReceived = timeReceived;
            this.response = response;
        }
    }

    final class ResponseRunner
    implements Runnable {
        private final ByteBuf buffer;
        private final boolean bogusResponse;
        private final ChannelPromise promise;

        ResponseRunner(ByteBuf buffer, ChannelPromise promise) {
            this.buffer = buffer;
            this.bogusResponse = false;
            this.promise = promise;
        }

        ResponseRunner() {
            this.bogusResponse = true;
            this.buffer = Unpooled.buffer((int)0);
            this.promise = HttpAcceptorHandler.this.channel.newPromise();
        }

        @Override
        public void run() {
            ResponseHolder responseHolder = null;
            do {
                try {
                    responseHolder = (ResponseHolder)HttpAcceptorHandler.this.responses.take();
                }
                catch (InterruptedException e) {
                    if (!HttpAcceptorHandler.this.executor.isShutdown()) continue;
                    return;
                }
            } while (responseHolder == null);
            if (!this.bogusResponse) {
                this.piggyBackResponses(responseHolder.response.content());
                responseHolder.response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)String.valueOf(responseHolder.response.content().readableBytes()));
                HttpAcceptorHandler.this.channel.writeAndFlush((Object)responseHolder.response, this.promise);
            } else {
                responseHolder.response.content().writeBytes(this.buffer);
                responseHolder.response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)String.valueOf(responseHolder.response.content().readableBytes()));
                HttpAcceptorHandler.this.channel.writeAndFlush((Object)responseHolder.response, this.promise);
            }
            this.buffer.release();
        }

        private void piggyBackResponses(ByteBuf buf) {
            if (HttpAcceptorHandler.this.responses.isEmpty()) {
                buf.writeBytes(this.buffer);
                do {
                    try {
                        ResponseRunner responseRunner = (ResponseRunner)HttpAcceptorHandler.this.delayedResponses.poll(0L, TimeUnit.MILLISECONDS);
                        if (responseRunner == null) break;
                        buf.writeBytes(responseRunner.buffer);
                        responseRunner.buffer.release();
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                } while (HttpAcceptorHandler.this.responses.isEmpty());
                return;
            }
            buf.writeBytes(this.buffer);
        }
    }
}

