/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import liquibase.Scope;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.resource.AbstractResourceAccessor;
import liquibase.resource.InputStreamList;
import liquibase.util.StreamUtil;

public class ClassLoaderForLiquibase
extends AbstractResourceAccessor {
    private ClassLoader classLoader;
    protected List<FileSystem> rootPaths;
    protected SortedSet<String> description;

    public ClassLoaderForLiquibase() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ClassLoaderForLiquibase(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected void init() {
        if (this.rootPaths == null) {
            this.rootPaths = new ArrayList<FileSystem>();
            this.description = new TreeSet<String>();
            this.loadRootPaths(this.classLoader);
        }
    }

    protected void loadRootPaths(ClassLoader classLoader) {
        ClassLoader parent;
        URL[] urls;
        if (classLoader instanceof URLClassLoader && (urls = ((URLClassLoader)classLoader).getURLs()) != null) {
            for (URL url : urls) {
                try {
                    this.addDescription(url);
                    this.rootPaths.add(FileSystems.newFileSystem(Paths.get(url.toURI()), ((Object)((Object)this)).getClass().getClassLoader()));
                }
                catch (ProviderNotFoundException e) {
                    if (url.toExternalForm().startsWith("file:/")) continue;
                    Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("No filesystem provider for URL " + url.toExternalForm() + ". Will rely on classloader logic for listing files.");
                }
                catch (FileSystemNotFoundException fsnfe) {
                    Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Configured classpath location " + url.toString() + " does not exist");
                }
                catch (Throwable e) {
                    if (url.toExternalForm().endsWith("lib/*")) continue;
                    Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Cannot create filesystem for url " + url.toExternalForm() + ": " + e.getMessage(), e);
                }
            }
        }
        if ((parent = classLoader.getParent()) != null) {
            this.loadRootPaths(parent);
        }
    }

    private void addDescription(URL url) {
        try {
            this.description.add(Paths.get(url.toURI()).toString());
        }
        catch (Throwable e) {
            this.description.add(url.toExternalForm());
        }
    }

    public InputStreamList openStreams(String relativeTo, String streamPath) throws IOException {
        this.init();
        InputStreamList returnList = new InputStreamList();
        streamPath = this.getFinalPath(relativeTo, streamPath);
        HashSet<String> seenUrls = new HashSet<String>();
        Enumeration<URL> resources = this.classLoader.getResources(streamPath);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            if (!seenUrls.add(url.toExternalForm())) continue;
            try {
                returnList.add(url.toURI(), url.openStream());
            }
            catch (URISyntaxException e) {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).severe(e.getMessage(), (Throwable)e);
            }
        }
        return returnList;
    }

    protected String getFinalPath(String relativeTo, String streamPath) {
        streamPath = ((String)streamPath).replace("\\", "/");
        streamPath = ((String)streamPath).replaceFirst("^classpath:", "");
        if (relativeTo != null) {
            String lastPortion;
            relativeTo = relativeTo.replace("\\", "/");
            relativeTo = relativeTo.replaceFirst("^classpath:", "");
            if (!(relativeTo = relativeTo.replaceAll("//+", "/")).endsWith("/") && (lastPortion = relativeTo.replaceFirst(".+/", "")).contains(".")) {
                relativeTo = relativeTo.replaceFirst("/[^/]+?$", "");
            }
            if (!relativeTo.contains("/") && relativeTo.contains(".")) {
                relativeTo = "/";
            }
            streamPath = relativeTo + "/" + (String)streamPath;
        }
        streamPath = ((String)streamPath).replaceAll("//+", "/");
        streamPath = ((String)streamPath).replaceFirst("^/", "");
        return DatabaseChangeLog.normalizePath((String)streamPath);
    }

    public SortedSet<String> list(String relativeTo, String path, boolean recursive, boolean includeFiles, boolean includeDirectories) throws IOException {
        this.init();
        String finalPath = this.getFinalPath(relativeTo, path);
        SortedSet<String> returnList = this.listFromClassLoader(finalPath, recursive, includeFiles, includeDirectories);
        returnList.addAll(this.listFromRootPaths(finalPath, recursive, includeFiles, includeDirectories));
        return returnList;
    }

    protected SortedSet<String> listFromRootPaths(final String path, boolean recursive, final boolean includeFiles, final boolean includeDirectories) {
        final TreeSet<String> returnSet = new TreeSet<String>();
        SimpleFileVisitor<Path> fileVisitor = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (includeFiles && attrs.isRegularFile()) {
                    this.addToReturnList(file);
                }
                if (includeDirectories && attrs.isDirectory()) {
                    this.addToReturnList(file);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (includeDirectories) {
                    this.addToReturnList(dir);
                }
                return FileVisitResult.CONTINUE;
            }

            protected void addToReturnList(Path file) {
                if (!file.toString().equals(path)) {
                    returnSet.add(file.toString().replaceFirst("^/", "").replaceFirst("/$", "").replaceAll("//+", "/"));
                }
            }
        };
        for (FileSystem fileSystem : this.rootPaths) {
            int maxDepth = recursive ? Integer.MAX_VALUE : 1;
            try {
                Files.walkFileTree(fileSystem.getPath(path, new String[0]), Collections.singleton(FileVisitOption.FOLLOW_LINKS), maxDepth, (FileVisitor<? super Path>)fileVisitor);
            }
            catch (NoSuchFileException noSuchFileException) {
            }
            catch (IOException e) {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Cannot walk filesystem: " + e.getMessage(), (Throwable)e);
            }
        }
        return returnSet;
    }

    protected SortedSet<String> listFromClassLoader(String path, boolean recursive, boolean includeFiles, boolean includeDirectories) {
        Enumeration<URL> resources;
        TreeSet<String> returnSet = new TreeSet<String>();
        try {
            resources = this.classLoader.getResources(path);
        }
        catch (IOException e) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).severe("Cannot list resources in path " + path + ": " + e.getMessage(), (Throwable)e);
            return returnSet;
        }
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            try {
                InputStream inputStream = url.openStream();
                String fileList = StreamUtil.readStreamAsString((InputStream)inputStream);
                if (fileList.isEmpty()) continue;
                for (String childName : fileList.split("\n")) {
                    String childPath = (path + "/" + childName).replaceAll("//+", "/");
                    if (this.isDirectory(childPath)) {
                        if (includeDirectories) {
                            returnSet.add(childPath);
                        }
                        if (!recursive) continue;
                        returnSet.addAll(this.listFromClassLoader(childPath, recursive, includeFiles, includeDirectories));
                        continue;
                    }
                    if (!includeFiles) continue;
                    returnSet.add(childPath);
                }
            }
            catch (IOException e) {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).severe("Cannot list resources in " + url.toExternalForm() + ": " + e.getMessage(), (Throwable)e);
            }
        }
        return returnSet;
    }

    protected boolean isDirectory(String path) {
        try {
            Enumeration<URL> resources = this.classLoader.getResources(path);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                File file = new File(url.toURI());
                if (!file.exists() || !file.isDirectory()) continue;
                return true;
            }
        }
        catch (Exception resources) {
            // empty catch block
        }
        String lastPortion = path.replaceFirst(".*/", "");
        return !lastPortion.contains(".");
    }

    public SortedSet<String> describeLocations() {
        this.init();
        return this.description;
    }
}

