/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.springframework.cloud.client.loadbalancer.RequestData;
import org.springframework.core.style.ToStringCreator;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseCookie;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.ClientResponse;

public class ResponseData {
    private final HttpStatus httpStatus;
    private final HttpHeaders headers;
    private final MultiValueMap<String, ResponseCookie> cookies;
    private final RequestData requestData;

    public ResponseData(HttpStatus httpStatus, HttpHeaders headers, MultiValueMap<String, ResponseCookie> cookies, RequestData requestData) {
        this.httpStatus = httpStatus;
        this.headers = headers;
        this.cookies = cookies;
        this.requestData = requestData;
    }

    public ResponseData(ClientResponse response, RequestData requestData) {
        this(response.statusCode(), response.headers().asHttpHeaders(), (MultiValueMap<String, ResponseCookie>)response.cookies(), requestData);
    }

    public ResponseData(ServerHttpResponse response, RequestData requestData) {
        this(response.getStatusCode(), response.getHeaders(), (MultiValueMap<String, ResponseCookie>)response.getCookies(), requestData);
    }

    public ResponseData(ClientHttpResponse clientHttpResponse, RequestData requestData) throws IOException {
        this(clientHttpResponse.getStatusCode(), clientHttpResponse.getHeaders(), ResponseData.buildCookiesFromHeaders(clientHttpResponse.getHeaders()), requestData);
    }

    public HttpStatus getHttpStatus() {
        return this.httpStatus;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public MultiValueMap<String, ResponseCookie> getCookies() {
        return this.cookies;
    }

    public RequestData getRequestData() {
        return this.requestData;
    }

    public String toString() {
        ToStringCreator to = new ToStringCreator((Object)this);
        to.append("httpStatus", (Object)this.httpStatus);
        return to.toString();
    }

    static MultiValueMap<String, ResponseCookie> buildCookiesFromHeaders(HttpHeaders headers) {
        LinkedMultiValueMap newCookies = new LinkedMultiValueMap();
        if (headers == null) {
            return newCookies;
        }
        List cookiesFromHeaders = headers.get((Object)"Cookie");
        if (cookiesFromHeaders != null) {
            cookiesFromHeaders.forEach(cookie -> {
                String[] splitCookie = cookie.split("=");
                if (splitCookie.length < 2) {
                    return;
                }
                newCookies.put((Object)splitCookie[0], Collections.singletonList(ResponseCookie.from((String)splitCookie[0], (String)splitCookie[1]).build()));
            });
        }
        return newCookies;
    }

    public int hashCode() {
        return Objects.hash(this.httpStatus, this.headers, this.cookies, this.requestData);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResponseData)) {
            return false;
        }
        ResponseData that = (ResponseData)o;
        return this.httpStatus == that.httpStatus && Objects.equals(this.headers, that.headers) && Objects.equals(this.cookies, that.cookies) && Objects.equals(this.requestData, that.requestData);
    }
}

