/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class CreateSessionResponseMessage
extends PacketImpl {
    private int serverVersion;

    public CreateSessionResponseMessage(int serverVersion) {
        super((byte)31);
        this.serverVersion = serverVersion;
    }

    public CreateSessionResponseMessage() {
        super((byte)31);
    }

    @Override
    public boolean isResponse() {
        return true;
    }

    public int getServerVersion() {
        return this.serverVersion;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeInt(this.serverVersion);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.serverVersion = buffer.readInt();
    }

    @Override
    public final boolean isRequiresConfirmations() {
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.serverVersion;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof CreateSessionResponseMessage)) {
            return false;
        }
        CreateSessionResponseMessage other = (CreateSessionResponseMessage)obj;
        return this.serverVersion == other.serverVersion;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer(this.getParentString());
        buff.append(", serverVersion=" + this.serverVersion);
        buff.append("]");
        return buff.toString();
    }
}

