/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Vector;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.asn1.BEROutputStream;
import org.snmp4j.event.CounterEvent;
import org.snmp4j.event.UsmUserEvent;
import org.snmp4j.event.UsmUserListener;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.CounterSupport;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.mp.StatusInformation;
import org.snmp4j.security.AuthenticationProtocol;
import org.snmp4j.security.ByteArrayWindow;
import org.snmp4j.security.DecryptParams;
import org.snmp4j.security.PrivacyProtocol;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityParameters;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.SecurityStateReference;
import org.snmp4j.security.UsmSecurityParameters;
import org.snmp4j.security.UsmSecurityStateReference;
import org.snmp4j.security.UsmTimeEntry;
import org.snmp4j.security.UsmTimeTable;
import org.snmp4j.security.UsmUser;
import org.snmp4j.security.UsmUserEntry;
import org.snmp4j.security.UsmUserTable;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;

public class USM
implements SecurityModel {
    private static final int MAXLEN_USMUSERNAME = 32;
    private static final LogAdapter logger = LogFactory.getLogger(USM.class);
    private UsmUserTable userTable;
    private UsmTimeTable timeTable;
    private OctetString localEngineID;
    private boolean engineDiscoveryEnabled = true;
    private SecurityProtocols securityProtocols;
    private transient Vector usmUserListeners;
    private CounterSupport counterSupport;

    public USM(SecurityProtocols securityProtocols, OctetString octetString, int n) {
        this.localEngineID = octetString;
        this.timeTable = new UsmTimeTable(octetString, n);
        this.userTable = new UsmUserTable();
        this.securityProtocols = securityProtocols;
        this.counterSupport = CounterSupport.getInstance();
    }

    public int getID() {
        return 3;
    }

    public void setLocalEngine(OctetString octetString, int n, int n2) {
        this.timeTable.removeEntry(this.localEngineID);
        this.localEngineID = octetString;
        this.timeTable.addEntry(new UsmTimeEntry(octetString, n, n2));
    }

    public OctetString getLocalEngineID() {
        return this.localEngineID;
    }

    public void setEngineBoots(int n) {
        this.timeTable.setEngineBoots(n);
    }

    public int getEngineBoots() {
        return this.timeTable.getEngineBoots();
    }

    public int getEngineTime() {
        return this.timeTable.getEngineTime();
    }

    public SecurityParameters newSecurityParametersInstance() {
        return new UsmSecurityParameters();
    }

    public SecurityStateReference newSecurityStateReference() {
        return new UsmSecurityStateReference();
    }

    private static byte[] buildMessageBuffer(BERInputStream bERInputStream) throws IOException {
        int n;
        bERInputStream.mark(16);
        int n2 = (int)bERInputStream.getPosition();
        BER.MutableByte mutableByte = new BER.MutableByte();
        int n3 = BER.decodeHeader(bERInputStream, mutableByte);
        n2 = (int)bERInputStream.getPosition() - n2;
        byte[] byArray = new byte[n3 + n2];
        bERInputStream.reset();
        int n4 = bERInputStream.available();
        for (int i = 0; i < byArray.length && n4 > 0 && (n = bERInputStream.read(byArray, i, byArray.length - i)) >= 0; i += n) {
        }
        return byArray;
    }

    private static byte[] buildWholeMessage(Integer32 integer32, byte[] byArray, byte[] byArray2, UsmSecurityParameters usmSecurityParameters) throws IOException {
        int n = integer32.getBERLength() + byArray2.length + usmSecurityParameters.getBERLength() + byArray.length;
        int n2 = BER.getBERLengthOfLength(n) + n + 1;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
        BER.encodeHeader(byteArrayOutputStream, 48, n);
        integer32.encodeBER(byteArrayOutputStream);
        byteArrayOutputStream.write(byArray2);
        usmSecurityParameters.encodeBER(byteArrayOutputStream);
        byteArrayOutputStream.write(byArray);
        int n3 = 1 + integer32.getBERLength() + BER.getBERLengthOfLength(n) + byArray2.length;
        usmSecurityParameters.setSecurityParametersPosition(n3);
        return byteArrayOutputStream.toByteArray();
    }

    public int generateRequestMessage(int n, byte[] byArray, int n2, int n3, byte[] byArray2, byte[] byArray3, int n4, BERInputStream bERInputStream, SecurityParameters securityParameters, BEROutputStream bEROutputStream) throws IOException {
        return this.generateResponseMessage(n, byArray, n2, n3, byArray2, byArray3, n4, bERInputStream, null, securityParameters, bEROutputStream);
    }

    public UsmUserEntry getUser(OctetString octetString, OctetString octetString2) {
        UsmUserEntry usmUserEntry;
        if (logger.isDebugEnabled()) {
            logger.debug("getUser(engineID=" + octetString.toHexString() + ", securityName=" + octetString2.toString() + ")");
        }
        if ((usmUserEntry = this.userTable.getUser(octetString, octetString2)) == null) {
            usmUserEntry = this.userTable.getUser(octetString2);
            if (usmUserEntry == null && octetString2.length() > 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("USM.getUser - User '" + octetString2 + "' unknown");
                }
                return null;
            }
            if (usmUserEntry == null || octetString.length() == 0) {
                usmUserEntry = new UsmUserEntry();
                usmUserEntry.setUserName(octetString2);
                usmUserEntry.setUsmUser(new UsmUser(octetString2, null, null, null, null));
                return usmUserEntry;
            }
            OID oID = usmUserEntry.getUsmUser().getAuthenticationProtocol();
            OID oID2 = usmUserEntry.getUsmUser().getPrivacyProtocol();
            if (oID != null) {
                byte[] byArray = usmUserEntry.getUsmUser().isLocalized() ? usmUserEntry.getUsmUser().getAuthenticationPassphrase().getValue() : this.securityProtocols.passwordToKey(oID, usmUserEntry.getUsmUser().getAuthenticationPassphrase(), octetString.getValue());
                byte[] byArray2 = null;
                if (oID2 != null) {
                    byArray2 = usmUserEntry.getUsmUser().isLocalized() ? usmUserEntry.getUsmUser().getPrivacyPassphrase().getValue() : this.securityProtocols.passwordToKey(oID2, oID, usmUserEntry.getUsmUser().getPrivacyPassphrase(), octetString.getValue());
                }
                usmUserEntry = this.addLocalizedUser(octetString.getValue(), octetString2, oID, byArray, oID2, byArray2);
            }
        }
        return usmUserEntry;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int generateResponseMessage(int n, byte[] byArray, int n2, int n3, byte[] byArray2, byte[] byArray3, int n4, BERInputStream bERInputStream, SecurityStateReference securityStateReference, SecurityParameters securityParameters, BEROutputStream bEROutputStream) throws IOException {
        Object object;
        Serializable serializable;
        Object object2;
        Object object3;
        Object object4;
        UsmSecurityParameters usmSecurityParameters = (UsmSecurityParameters)securityParameters;
        if (securityStateReference != null) {
            object4 = (UsmSecurityStateReference)securityStateReference;
            if (((UsmSecurityStateReference)object4).getSecurityEngineID() == null) {
                usmSecurityParameters.setAuthoritativeEngineID(byArray2);
                ((UsmSecurityStateReference)object4).setSecurityEngineID(byArray2);
            }
            if (((UsmSecurityStateReference)object4).getSecurityName() == null) {
                object3 = new OctetString(byArray3);
                ((UsmSecurityStateReference)object4).setSecurityName(((OctetString)object3).getValue());
                usmSecurityParameters.setUserName((OctetString)object3);
                object2 = this.getSecurityName(new OctetString(byArray2), (OctetString)object3);
                if (object2 != null && ((OctetString)object2).length() <= 32) {
                    usmSecurityParameters.setUserName((OctetString)object2);
                }
            } else {
                usmSecurityParameters.setUserName(new OctetString(((UsmSecurityStateReference)object4).getSecurityName()));
            }
            usmSecurityParameters.setAuthenticationProtocol(((UsmSecurityStateReference)object4).getAuthenticationProtocol());
            usmSecurityParameters.setPrivacyProtocol(((UsmSecurityStateReference)object4).getPrivacyProtocol());
            usmSecurityParameters.setAuthenticationKey(((UsmSecurityStateReference)object4).getAuthenticationKey());
            usmSecurityParameters.setPrivacyKey(((UsmSecurityStateReference)object4).getPrivacyKey());
        } else {
            block31: {
                object4 = new OctetString();
                if (byArray2 != null) {
                    ((OctetString)object4).setValue(byArray2);
                }
                object3 = new OctetString(byArray3);
                if (((OctetString)object4).length() == 0) {
                    if (this.isEngineDiscoveryEnabled()) {
                        object2 = new UsmUserEntry();
                        break block31;
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Engine ID unknown and discovery disabled");
                        }
                        return 1410;
                    }
                }
                object2 = this.getUser((OctetString)object4, (OctetString)object3);
            }
            if (object2 == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Security name not found for engineID=" + ((OctetString)object4).toHexString() + ", securityName=" + ((OctetString)object3).toHexString());
                }
                return 1404;
            }
            serializable = this.securityProtocols.getAuthenticationProtocol(((UsmUserEntry)object2).getUsmUser().getAuthenticationProtocol());
            object = this.securityProtocols.getPrivacyProtocol(((UsmUserEntry)object2).getUsmUser().getPrivacyProtocol());
            usmSecurityParameters.setAuthenticationProtocol((AuthenticationProtocol)serializable);
            usmSecurityParameters.setPrivacyProtocol((PrivacyProtocol)object);
            usmSecurityParameters.setAuthenticationKey(((UsmUserEntry)object2).getAuthenticationKey());
            usmSecurityParameters.setPrivacyKey(((UsmUserEntry)object2).getPrivacyKey());
            usmSecurityParameters.setUserName(((UsmUserEntry)object2).getUsmUser().getSecurityName());
            usmSecurityParameters.setAuthoritativeEngineID(((OctetString)object4).getValue());
        }
        if (usmSecurityParameters.getAuthoritativeEngineID().length > 32) {
            logger.error("Engine ID too long: " + usmSecurityParameters.getAuthoritativeEngineID().length + ">" + 32 + " for " + new OctetString(usmSecurityParameters.getAuthoritativeEngineID()).toHexString());
            return 1401;
        }
        if (byArray3.length > 32) {
            logger.error("Security name too long: " + usmSecurityParameters.getAuthoritativeEngineID().length + ">" + 32 + " for " + new OctetString(byArray3).toHexString());
            return 1401;
        }
        if (n4 >= 2) {
            if (securityStateReference != null) {
                usmSecurityParameters.setAuthoritativeEngineBoots(this.getEngineBoots());
                usmSecurityParameters.setAuthoritativeEngineTime(this.getEngineTime());
            } else {
                object4 = new OctetString(byArray2);
                object3 = this.timeTable.getTime((OctetString)object4);
                if (object3 == null) {
                    object3 = new UsmTimeEntry((OctetString)object4, usmSecurityParameters.getAuthoritativeEngineBoots(), usmSecurityParameters.getAuthoritativeEngineTime());
                    this.timeTable.addEntry((UsmTimeEntry)object3);
                } else {
                    usmSecurityParameters.setAuthoritativeEngineBoots(((UsmTimeEntry)object3).getEngineBoots());
                    usmSecurityParameters.setAuthoritativeEngineTime(((UsmTimeEntry)object3).getLatestReceivedTime());
                }
            }
        }
        if (n4 >= 2 && usmSecurityParameters.getAuthenticationProtocol() == null) {
            return 1403;
        }
        object4 = USM.buildMessageBuffer(bERInputStream);
        if (n4 == 3) {
            if (usmSecurityParameters.getPrivacyProtocol() == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Unsupported security level (missing or unsupported privacy protocol)");
                }
                return 1403;
            }
            logger.debug("RFC3414 \u00a73.1.4.a Outgoing message needs to be encrypted");
            object3 = new DecryptParams();
            object2 = usmSecurityParameters.getPrivacyProtocol().encrypt((byte[])object4, 0, ((Object)object4).length, usmSecurityParameters.getPrivacyKey(), usmSecurityParameters.getAuthoritativeEngineBoots(), usmSecurityParameters.getAuthoritativeEngineTime(), (DecryptParams)object3);
            if (object2 == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Encryption error");
                }
                return 1405;
            }
            usmSecurityParameters.setPrivacyParameters(new OctetString(((DecryptParams)object3).array));
            serializable = new OctetString((byte[])object2);
            object = new BEROutputStream(ByteBuffer.allocate(((OctetString)serializable).getBERLength()));
            ((OctetString)serializable).encodeBER((OutputStream)object);
            object4 = ((BEROutputStream)object).getBuffer().array();
        } else {
            logger.debug("RFC3414 \u00a73.1.4.b Outgoing message is not encrypted");
            usmSecurityParameters.setPrivacyParameters(new OctetString());
        }
        if (n4 >= 2) {
            object2 = new byte[12];
            usmSecurityParameters.setAuthenticationParameters(new OctetString((byte[])object2));
            object3 = USM.buildWholeMessage(new Integer32(n), (byte[])object4, byArray, usmSecurityParameters);
            int n5 = usmSecurityParameters.getAuthParametersPosition() + usmSecurityParameters.getSecurityParametersPosition();
            boolean bl = usmSecurityParameters.getAuthenticationProtocol().authenticate(usmSecurityParameters.getAuthenticationKey(), (byte[])object3, 0, ((Object)object3).length, new ByteArrayWindow((byte[])object3, n5, 12));
            if (!bl) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Outgoing message could not be authenticated");
                }
                return 1407;
            }
        } else {
            usmSecurityParameters.setAuthoritativeEngineBoots(0);
            usmSecurityParameters.setAuthenticationParameters(new OctetString());
            usmSecurityParameters.setAuthoritativeEngineTime(0);
            object3 = USM.buildWholeMessage(new Integer32(n), (byte[])object4, byArray, usmSecurityParameters);
        }
        object2 = (ByteBuffer)ByteBuffer.wrap((byte[])object3).position(((Object)object3).length);
        bEROutputStream.setBuffer((ByteBuffer)object2);
        return 0;
    }

    private OctetString getSecurityName(OctetString octetString, OctetString octetString2) {
        if (octetString2.length() == 0) {
            return octetString2;
        }
        UsmUserEntry usmUserEntry = this.userTable.getUser(octetString, octetString2);
        if (usmUserEntry != null) {
            return usmUserEntry.getUsmUser().getSecurityName();
        }
        if (this.isEngineDiscoveryEnabled() && (usmUserEntry = this.userTable.getUser(octetString2)) != null) {
            return usmUserEntry.getUsmUser().getSecurityName();
        }
        return null;
    }

    public int processIncomingMsg(int n, int n2, SecurityParameters securityParameters, SecurityModel securityModel, int n3, BERInputStream bERInputStream, OctetString octetString, OctetString octetString2, BEROutputStream bEROutputStream, Integer32 integer32, SecurityStateReference securityStateReference, StatusInformation statusInformation) throws IOException {
        Comparable comparable;
        UsmSecurityParameters usmSecurityParameters = (UsmSecurityParameters)securityParameters;
        UsmSecurityStateReference usmSecurityStateReference = (UsmSecurityStateReference)securityStateReference;
        octetString.setValue(usmSecurityParameters.getAuthoritativeEngineID());
        byte[] byArray = USM.buildMessageBuffer(bERInputStream);
        if (octetString.length() == 0 || this.timeTable.checkEngineID(octetString, this.isEngineDiscoveryEnabled()) != 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("RFC3414 \u00a73.2.3 Unknown engine ID: " + octetString.toHexString());
            }
            octetString.setValue(usmSecurityParameters.getAuthoritativeEngineID());
            octetString2.setValue(usmSecurityParameters.getUserName().getValue());
            if (statusInformation != null) {
                CounterEvent counterEvent = new CounterEvent(this, SnmpConstants.usmStatsUnknownEngineIDs);
                this.fireIncrementCounter(counterEvent);
                statusInformation.setSecurityLevel(new Integer32(n3));
                statusInformation.setErrorIndication(new VariableBinding(counterEvent.getOid(), counterEvent.getCurrentValue()));
            }
            return 1410;
        }
        octetString2.setValue(usmSecurityParameters.getUserName().getValue());
        int n4 = usmSecurityParameters.getScopedPduPosition();
        if (usmSecurityParameters.getUserName().length() > 0 || n3 > 1) {
            comparable = this.getSecurityName(octetString, usmSecurityParameters.getUserName());
            if (comparable == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("RFC3414 \u00a73.2.4 Unknown security name: " + octetString2.toHexString());
                }
                if (statusInformation != null) {
                    CounterEvent counterEvent = new CounterEvent(this, SnmpConstants.usmStatsUnknownUserNames);
                    this.fireIncrementCounter(counterEvent);
                    statusInformation.setSecurityLevel(new Integer32(1));
                    statusInformation.setErrorIndication(new VariableBinding(counterEvent.getOid(), counterEvent.getCurrentValue()));
                }
                return 1404;
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Accepting zero length security name");
            }
            octetString2.setValue(new byte[0]);
        }
        if (usmSecurityParameters.getUserName().length() > 0 || n3 > 1) {
            comparable = this.getUser(octetString, octetString2);
            if (comparable == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("RFC3414 \u00a73.2.4 Unknown security name: " + octetString2.toHexString() + " for engine ID " + octetString.toHexString());
                }
                CounterEvent counterEvent = new CounterEvent(this, SnmpConstants.usmStatsUnknownUserNames);
                this.fireIncrementCounter(counterEvent);
                if (statusInformation != null) {
                    statusInformation.setSecurityLevel(new Integer32(1));
                    statusInformation.setErrorIndication(new VariableBinding(counterEvent.getOid(), counterEvent.getCurrentValue()));
                }
                return 1404;
            }
            usmSecurityStateReference.setUserName(((UsmUserEntry)comparable).getUserName().getValue());
            AuthenticationProtocol authenticationProtocol = this.securityProtocols.getAuthenticationProtocol(((UsmUserEntry)comparable).getUsmUser().getAuthenticationProtocol());
            PrivacyProtocol privacyProtocol = this.securityProtocols.getPrivacyProtocol(((UsmUserEntry)comparable).getUsmUser().getPrivacyProtocol());
            if (n3 >= 2 && authenticationProtocol == null || n3 >= 3 && privacyProtocol == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("RFC3414 \u00a73.2.5 - Unsupported security level: " + n3);
                }
                CounterEvent counterEvent = new CounterEvent(this, SnmpConstants.usmStatsUnsupportedSecLevels);
                this.fireIncrementCounter(counterEvent);
                statusInformation.setSecurityLevel(new Integer32(1));
                statusInformation.setErrorIndication(new VariableBinding(counterEvent.getOid(), counterEvent.getCurrentValue()));
                return 1403;
            }
            if (n3 >= 2) {
                int n5;
                int n6;
                if (statusInformation != null) {
                    n6 = usmSecurityParameters.getAuthParametersPosition() + usmSecurityParameters.getSecurityParametersPosition();
                    boolean bl = authenticationProtocol.isAuthentic(((UsmUserEntry)comparable).getAuthenticationKey(), byArray, 0, byArray.length, new ByteArrayWindow(byArray, n6, 12));
                    if (!bl) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("RFC3414 \u00a73.2.6 Wrong digest -> authentication failure: " + usmSecurityParameters.getAuthenticationParameters().toHexString());
                        }
                        CounterEvent counterEvent = new CounterEvent(this, SnmpConstants.usmStatsWrongDigests);
                        this.fireIncrementCounter(counterEvent);
                        statusInformation.setSecurityLevel(new Integer32(1));
                        statusInformation.setErrorIndication(new VariableBinding(counterEvent.getOid(), counterEvent.getCurrentValue()));
                        return 1408;
                    }
                    usmSecurityStateReference.setAuthenticationKey(((UsmUserEntry)comparable).getAuthenticationKey());
                    usmSecurityStateReference.setPrivacyKey(((UsmUserEntry)comparable).getPrivacyKey());
                    usmSecurityStateReference.setAuthenticationProtocol(authenticationProtocol);
                    usmSecurityStateReference.setPrivacyProtocol(privacyProtocol);
                    n5 = this.timeTable.checkTime(new UsmTimeEntry(octetString, usmSecurityParameters.getAuthoritativeEngineBoots(), usmSecurityParameters.getAuthoritativeEngineTime()));
                    switch (n5) {
                        case 1411: {
                            logger.debug("RFC3414 \u00a73.2.7.a Not in time window; engineID='" + octetString + "', engineBoots=" + usmSecurityParameters.getAuthoritativeEngineBoots() + ", engineTime=" + usmSecurityParameters.getAuthoritativeEngineTime());
                            CounterEvent counterEvent = new CounterEvent(this, SnmpConstants.usmStatsNotInTimeWindows);
                            this.fireIncrementCounter(counterEvent);
                            statusInformation.setSecurityLevel(new Integer32(2));
                            statusInformation.setErrorIndication(new VariableBinding(counterEvent.getOid(), counterEvent.getCurrentValue()));
                            return n5;
                        }
                        case 1410: {
                            if (logger.isDebugEnabled()) {
                                logger.debug("RFC3414 \u00a73.2.7.b - Unkown engine ID: " + octetString);
                            }
                            CounterEvent counterEvent = new CounterEvent(this, SnmpConstants.usmStatsNotInTimeWindows);
                            this.fireIncrementCounter(counterEvent);
                            statusInformation.setSecurityLevel(new Integer32(2));
                            statusInformation.setErrorIndication(new VariableBinding(counterEvent.getOid(), counterEvent.getCurrentValue()));
                            return n5;
                        }
                    }
                }
                if (n3 >= 3) {
                    OctetString octetString3 = usmSecurityParameters.getPrivacyParameters();
                    DecryptParams decryptParams = new DecryptParams(octetString3.getValue(), 0, octetString3.length());
                    try {
                        n5 = byArray.length - n4;
                        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n4, n5);
                        BERInputStream bERInputStream2 = new BERInputStream(byteBuffer);
                        long l = bERInputStream2.getPosition();
                        int n7 = BER.decodeHeader(bERInputStream2, new BER.MutableByte());
                        int n8 = n4 + (int)(bERInputStream2.getPosition() - l);
                        bERInputStream2.close();
                        bERInputStream2 = null;
                        byte[] byArray2 = privacyProtocol.decrypt(byArray, n8, n7, ((UsmUserEntry)comparable).getPrivacyKey(), usmSecurityParameters.getAuthoritativeEngineBoots(), usmSecurityParameters.getAuthoritativeEngineTime(), decryptParams);
                        ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray2);
                        bEROutputStream.setFilledBuffer(byteBuffer2);
                    }
                    catch (Exception exception) {
                        logger.debug("RFC 3414 \u00a73.2.8 Decryption error: " + exception.getMessage());
                        return 1406;
                    }
                } else {
                    n6 = byArray.length - n4;
                    ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n4, n6);
                    bEROutputStream.setFilledBuffer(byteBuffer);
                }
            } else {
                int n9 = byArray.length - n4;
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n4, n9);
                bEROutputStream.setFilledBuffer(byteBuffer);
            }
        } else {
            int n10 = byArray.length - n4;
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n4, n10);
            bEROutputStream.setFilledBuffer(byteBuffer);
        }
        int n11 = usmSecurityParameters.getBERMaxLength(n3);
        integer32.setValue(n2 - n11);
        usmSecurityStateReference.setSecurityName(octetString2.getValue());
        return 0;
    }

    protected void fireIncrementCounter(CounterEvent counterEvent) {
        this.counterSupport.fireIncrementCounter(counterEvent);
    }

    public void addUser(OctetString octetString, UsmUser usmUser) {
        this.addUser(octetString, new OctetString(), usmUser);
    }

    public void addUser(OctetString octetString, OctetString octetString2, UsmUser usmUser) {
        byte[] byArray = null;
        byte[] byArray2 = null;
        if (octetString2 != null && octetString2.length() > 0 && usmUser.getAuthenticationProtocol() != null) {
            byArray = usmUser.isLocalized() ? usmUser.getAuthenticationPassphrase().getValue() : this.securityProtocols.passwordToKey(usmUser.getAuthenticationProtocol(), usmUser.getAuthenticationPassphrase(), octetString2.getValue());
            if (usmUser.getPrivacyProtocol() != null) {
                byArray2 = usmUser.isLocalized() ? usmUser.getPrivacyPassphrase().getValue() : this.securityProtocols.passwordToKey(usmUser.getPrivacyProtocol(), usmUser.getAuthenticationProtocol(), usmUser.getPrivacyPassphrase(), octetString2.getValue());
            }
        }
        OctetString octetString3 = usmUser.isLocalized() ? usmUser.getLocalizationEngineID() : (octetString2 == null ? new OctetString() : octetString2);
        UsmUserEntry usmUserEntry = new UsmUserEntry(octetString, octetString3, usmUser);
        usmUserEntry.setAuthenticationKey(byArray);
        usmUserEntry.setPrivacyKey(byArray2);
        this.userTable.addUser(usmUserEntry);
        this.fireUsmUserChange(new UsmUserEvent(this, usmUserEntry, 1));
    }

    public void updateUser(UsmUserEntry usmUserEntry) {
        UsmUserEntry usmUserEntry2 = this.userTable.addUser(usmUserEntry);
        this.fireUsmUserChange(new UsmUserEvent(this, usmUserEntry, usmUserEntry2 == null ? 1 : 3));
    }

    public void setUsers(UsmUser[] usmUserArray) {
        if (usmUserArray == null || usmUserArray.length == 0) {
            this.userTable.clear();
        } else {
            Vector<UsmUserEntry> vector = new Vector<UsmUserEntry>(usmUserArray.length);
            for (int i = 0; i < usmUserArray.length; ++i) {
                UsmUserEntry usmUserEntry = new UsmUserEntry(usmUserArray[i].getSecurityName(), (UsmUser)usmUserArray[i].clone());
                vector.add(usmUserEntry);
            }
            this.userTable.setUsers(vector);
        }
    }

    public UsmUserTable getUserTable() {
        return this.userTable;
    }

    public UsmTimeTable getTimeTable() {
        return this.timeTable;
    }

    public UsmUser removeUser(OctetString octetString, OctetString octetString2) {
        UsmUserEntry usmUserEntry = this.userTable.removeUser(octetString, octetString2);
        if (usmUserEntry != null) {
            this.fireUsmUserChange(new UsmUserEvent(this, usmUserEntry, 2));
            return usmUserEntry.getUsmUser();
        }
        return null;
    }

    public void removeAllUsers() {
        this.userTable.clear();
        this.fireUsmUserChange(new UsmUserEvent(this, null, 2));
    }

    public UsmUserEntry addLocalizedUser(byte[] byArray, OctetString octetString, OID oID, byte[] byArray2, OID oID2, byte[] byArray3) {
        UsmUserEntry usmUserEntry = new UsmUserEntry(byArray, octetString, oID, byArray2, oID2, byArray3);
        this.userTable.addUser(usmUserEntry);
        this.fireUsmUserChange(new UsmUserEvent(this, usmUserEntry, 1));
        return usmUserEntry;
    }

    public boolean isEngineDiscoveryEnabled() {
        return this.engineDiscoveryEnabled;
    }

    public void setEngineDiscoveryEnabled(boolean bl) {
        this.engineDiscoveryEnabled = bl;
    }

    public synchronized void removeUsmUserListener(UsmUserListener usmUserListener) {
        if (this.usmUserListeners != null && this.usmUserListeners.contains(usmUserListener)) {
            Vector vector = (Vector)this.usmUserListeners.clone();
            vector.removeElement(usmUserListener);
            this.usmUserListeners = vector;
        }
    }

    public synchronized void addUsmUserListener(UsmUserListener usmUserListener) {
        Vector vector;
        Vector vector2 = vector = this.usmUserListeners == null ? new Vector(2) : (Vector)this.usmUserListeners.clone();
        if (!vector.contains(usmUserListener)) {
            vector.addElement(usmUserListener);
            this.usmUserListeners = vector;
        }
    }

    public void removeEngineTime(OctetString octetString) {
        this.timeTable.removeEntry(octetString);
    }

    protected void fireUsmUserChange(UsmUserEvent usmUserEvent) {
        if (this.usmUserListeners != null) {
            Vector vector = this.usmUserListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((UsmUserListener)vector.elementAt(i)).usmUserChange(usmUserEvent);
            }
        }
    }

    public CounterSupport getCounterSupport() {
        return this.counterSupport;
    }

    public SecurityProtocols getSecurityProtocols() {
        return this.securityProtocols;
    }

    public void setCounterSupport(CounterSupport counterSupport) {
        if (counterSupport == null) {
            throw new NullPointerException();
        }
        this.counterSupport = counterSupport;
    }
}

