/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.elastic4s.json;

import com.sksamuel.elastic4s.ArrayFieldValue;
import com.sksamuel.elastic4s.FieldValue;
import com.sksamuel.elastic4s.NestedFieldValue;
import com.sksamuel.elastic4s.NullFieldValue;
import com.sksamuel.elastic4s.SimpleFieldValue;
import com.sksamuel.elastic4s.json.XContentBuilder;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;

public final class XContentFieldValueWriter$ {
    public static final XContentFieldValueWriter$ MODULE$ = new XContentFieldValueWriter$();

    public void apply(XContentBuilder source, FieldValue value) {
        FieldValue fieldValue = value;
        if (fieldValue instanceof NullFieldValue) {
            NullFieldValue nullFieldValue = (NullFieldValue)fieldValue;
            String name = nullFieldValue.name();
            source.nullField(name);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (fieldValue instanceof SimpleFieldValue) {
            SimpleFieldValue simpleFieldValue = (SimpleFieldValue)fieldValue;
            Option<String> name = simpleFieldValue.name();
            Object v = simpleFieldValue.value();
            Option<String> option = name;
            if (option instanceof Some) {
                Some some = (Some)option;
                String n = (String)some.value();
                source.autofield(n, v);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                source.autovalue(v);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (fieldValue instanceof ArrayFieldValue) {
            ArrayFieldValue arrayFieldValue = (ArrayFieldValue)fieldValue;
            String name = arrayFieldValue.name();
            Seq<FieldValue> values = arrayFieldValue.values();
            source.startArray(name);
            values.foreach((Function1 & Serializable)x$1 -> {
                XContentFieldValueWriter$.MODULE$.apply(source, x$1);
                return BoxedUnit.UNIT;
            });
            source.endArray();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (fieldValue instanceof NestedFieldValue) {
            XContentBuilder xContentBuilder;
            NestedFieldValue nestedFieldValue = (NestedFieldValue)fieldValue;
            Option<String> name = nestedFieldValue.name();
            Seq<FieldValue> values = nestedFieldValue.values();
            Option<String> option = name;
            if (option instanceof Some) {
                Some some = (Some)option;
                String n = (String)some.value();
                xContentBuilder = source.startObject(n);
            } else if (None$.MODULE$.equals(option)) {
                xContentBuilder = source.startObject();
            } else {
                throw new MatchError(option);
            }
            values.foreach((Function1 & Serializable)x$2 -> {
                XContentFieldValueWriter$.MODULE$.apply(source, x$2);
                return BoxedUnit.UNIT;
            });
            source.endObject();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)fieldValue);
        }
    }

    private XContentFieldValueWriter$() {
    }
}

