/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.tasker;

import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.engine.spi.execution.StepExecutionStateEvent;
import com.xebialabs.deployit.engine.spi.execution.TaskExecutionStateEvent;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContextListener;
import java.util.EnumSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OldExecutionContextListenerCleanupTrigger
implements ExecutionStateListener {
    private static final Set<TaskExecutionState> killStates = EnumSet.of(TaskExecutionState.EXECUTED, TaskExecutionState.STOPPED, TaskExecutionState.FAILED, TaskExecutionState.ABORTED);
    private String key;
    private ExecutionContextListener wrappedListener;
    private static final Logger logger = LoggerFactory.getLogger(OldExecutionContextListenerCleanupTrigger.class);

    public OldExecutionContextListenerCleanupTrigger(String key, ExecutionContextListener wrappedListener) {
        this.key = key;
        this.wrappedListener = wrappedListener;
    }

    public ExecutionContextListener getWrappedListener() {
        return this.wrappedListener;
    }

    public void stepStateChanged(StepExecutionStateEvent event) {
    }

    public void taskStateChanged(TaskExecutionStateEvent event) {
        if (killStates.contains(event.currentState())) {
            logger.info("Cleaning up [{}] which is an [{}]", (Object)this.key, (Object)this.wrappedListener);
            this.cleanupListener();
        }
    }

    private void cleanupListener() {
        try {
            this.wrappedListener.contextDestroyed();
        }
        catch (RuntimeException re) {
            logger.error("Exception while cleaning up object {} in execution context", (Object)this.wrappedListener);
            logger.error("Exception is: ", (Throwable)re);
        }
    }
}

