/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.artery;

import akka.remote.artery.CacheStatistics;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015cAB\f\u0019\u0003\u0003ab\u0004\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003)\u0011!Y\u0003A!A!\u0002\u0013A\u0003\u0002\u0003\u0017\u0001\u0005\u0007\u0005\u000b1B\u0017\t\u0011y\u0002!1!Q\u0001\f}BQ\u0001\u0012\u0001\u0005\u0002\u0015Ca!\u0014\u0001!\u0002\u0013A\u0003B\u0002(\u0001A\u0003&\u0001\u0006\u0003\u0004P\u0001\u0001\u0006I\u0001\u0015\u0005\u0007'\u0002\u0001\u000b\u0011\u0002+\t\rU\u0003\u0001\u0015!\u0003W\u0011\u00199\u0006\u0001)A\u0005-\")\u0001\f\u0001C\u00033\")q\f\u0001C\u0003A\")A\r\u0001C\u0003K\")q\r\u0001C\u0005Q\")Q\u000f\u0001C\u0005m\")Q\u000f\u0001C\ts\")a\u0010\u0001C\u0005\u007f\"9\u0011q\u0003\u0001\u0007\u0012\u0005e\u0001bBA\u000f\u0001\u0019E\u0011q\u0004\u0005\b\u0003G\u0001a\u0011CA\u0013\u0011\u001d\t\t\u0004\u0001C!\u0003g\u0011q\u0002\u0014:v\u0005>,h\u000eZ3e\u0007\u0006\u001c\u0007.\u001a\u0006\u00033i\ta!\u0019:uKJL(BA\u000e\u001d\u0003\u0019\u0011X-\\8uK*\tQ$\u0001\u0003bW.\fWcA\u00106\u0003N\u0011\u0001\u0001\t\t\u0003C\u0011j\u0011A\t\u0006\u0002G\u0005)1oY1mC&\u0011QE\t\u0002\u0007\u0003:L(+\u001a4\u0002\u0011\r\f\u0007/Y2jif\u001c\u0001\u0001\u0005\u0002\"S%\u0011!F\t\u0002\u0004\u0013:$\u0018!E3wS\u000e$\u0018iZ3UQJ,7\u000f[8mI\u0006QQM^5eK:\u001cW\rJ\u0019\u0011\u00079\n4'D\u00010\u0015\t\u0001$%A\u0004sK\u001adWm\u0019;\n\u0005Iz#\u0001C\"mCN\u001cH+Y4\u0011\u0005Q*D\u0002\u0001\u0003\u0006m\u0001\u0011\ra\u000e\u0002\u0002\u0017F\u0011\u0001h\u000f\t\u0003CeJ!A\u000f\u0012\u0003\u000f9{G\u000f[5oOB\u0011\u0011\u0005P\u0005\u0003{\t\u00121!\u00118z\u0003))g/\u001b3f]\u000e,GE\r\t\u0004]E\u0002\u0005C\u0001\u001bB\t\u0015\u0011\u0005A1\u0001D\u0005\u00051\u0016C\u0001\u001d!\u0003\u0019a\u0014N\\5u}Q\u0019ai\u0013'\u0015\u0007\u001dK%\n\u0005\u0003I\u0001M\u0002U\"\u0001\r\t\u000b1*\u00019A\u0017\t\u000by*\u00019A \t\u000b\u0019*\u0001\u0019\u0001\u0015\t\u000b-*\u0001\u0019\u0001\u0015\u0002\t5\u000b7o[\u0001\u0006KB|7\r[\u0001\u0005W\u0016L8\u000fE\u0002\"#NJ!A\u0015\u0012\u0003\u000b\u0005\u0013(/Y=\u0002\rY\fG.^3t!\r\t\u0013\u000bQ\u0001\u0007Q\u0006\u001c\b.Z:\u0011\u0007\u0005\n\u0006&\u0001\u0004fa>\u001c\u0007n]\u0001\u0004O\u0016$HC\u0001.^!\r\t3\fQ\u0005\u00039\n\u0012aa\u00149uS>t\u0007\"\u00020\r\u0001\u0004\u0019\u0014!A6\u0002\u000bM$\u0018\r^:\u0016\u0003\u0005\u0004\"\u0001\u00132\n\u0005\rD\"aD\"bG\",7\u000b^1uSN$\u0018nY:\u0002\u0019\u001d,Go\u0014:D_6\u0004X\u000f^3\u0015\u0005\u00013\u0007\"\u00020\u000f\u0001\u0004\u0019\u0014\u0001\u0003:f[>4X-\u0011;\u0015\u0005%d\u0007CA\u0011k\u0013\tY'E\u0001\u0003V]&$\b\"B7\u0010\u0001\u0004A\u0013\u0001\u00039pg&$\u0018n\u001c8)\u0005=y\u0007C\u00019t\u001b\u0005\t(B\u0001:#\u0003)\tgN\\8uCRLwN\\\u0005\u0003iF\u0014q\u0001^1jYJ,7-A\bqe>\u0014W\rR5ti\u0006t7-Z(g)\tAs\u000fC\u0003y!\u0001\u0007\u0001&\u0001\u0003tY>$Hc\u0001\u0015{y\")10\u0005a\u0001Q\u0005I\u0011\u000eZ3bYNcw\u000e\u001e\u0005\u0006{F\u0001\r\u0001K\u0001\u000bC\u000e$X/\u00197TY>$\u0018\u0001B7pm\u0016$R\"[A\u0001\u0003\u0007\t)!!\u0003\u0002\u000e\u0005E\u0001\"B7\u0013\u0001\u0004A\u0003\"\u00020\u0013\u0001\u0004\u0019\u0004BBA\u0004%\u0001\u0007\u0001&A\u0001i\u0011\u0019\tYA\u0005a\u0001\u0001\u0006)a/\u00197vK\"1\u0011q\u0002\nA\u0002!\n\u0011\"\u001a7f[\u0016\u0003xn\u00195\t\r\u0005M!\u00031\u0001)\u00035\u0001(o\u001c2f\t&\u001cH/\u00198dK\"\u0012!c\\\u0001\bG>l\u0007/\u001e;f)\r\u0001\u00151\u0004\u0005\u0006=N\u0001\raM\u0001\u0005Q\u0006\u001c\b\u000eF\u0002)\u0003CAQA\u0018\u000bA\u0002M\n1\"[:DC\u000eDW-\u00192mKR!\u0011qEA\u0017!\r\t\u0013\u0011F\u0005\u0004\u0003W\u0011#a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003_)\u0002\u0019\u0001!\u0002\u0003Y\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003k\u0001B!a\u000e\u0002B5\u0011\u0011\u0011\b\u0006\u0005\u0003w\ti$\u0001\u0003mC:<'BAA \u0003\u0011Q\u0017M^1\n\t\u0005\r\u0013\u0011\b\u0002\u0007'R\u0014\u0018N\\4")
public abstract class LruBoundedCache<K, V> {
    private final int capacity;
    private final int evictAgeThreshold;
    private final int Mask;
    private int epoch;
    private final Object keys;
    private final V[] values;
    private final int[] hashes;
    private final int[] epochs;

    public final Option<V> get(K k) {
        int h = this.hash(k);
        return this.find$1(h & this.Mask, 0, h, k);
    }

    public final CacheStatistics stats() {
        int sum = 0;
        int count = 0;
        int max = 0;
        for (int i = 0; i < this.hashes.length; ++i) {
            if (this.values[i] == null) continue;
            int dist = this.probeDistanceOf(i);
            sum += dist;
            ++count;
            max = package$.MODULE$.max(dist, max);
        }
        return new CacheStatistics(count, max, (double)sum / (double)count);
    }

    public final V getOrCompute(K k) {
        int h = this.hash(k);
        ++this.epoch;
        return (V)this.findOrCalculate$1(h & this.Mask, 0, k, h);
    }

    private void removeAt(int position) {
        while (true) {
            int next;
            if (this.values[next = position + 1 & this.Mask] == null || this.probeDistanceOf(next) == 0) break;
            ScalaRunTime$.MODULE$.array_update(this.keys, position, ScalaRunTime$.MODULE$.array_apply(this.keys, next));
            this.values[position] = this.values[next];
            this.hashes[position] = this.hashes[next];
            this.epochs[position] = this.epochs[next];
            position = next;
        }
        this.values[position] = null;
    }

    private int probeDistanceOf(int slot) {
        return this.probeDistanceOf(this.hashes[slot] & this.Mask, slot);
    }

    public int probeDistanceOf(int idealSlot, int actualSlot) {
        return actualSlot - idealSlot + this.capacity & this.Mask;
    }

    private void move(int position, K k, int h, V value, int elemEpoch, int probeDistance) {
        while (true) {
            if (this.values[position] == null) break;
            int otherEpoch = this.epochs[position];
            if (this.epoch - otherEpoch >= this.evictAgeThreshold) {
                this.removeAt(position);
                int n = h & this.Mask;
                probeDistance = 0;
                position = n;
                continue;
            }
            int otherProbeDistance = this.probeDistanceOf(position);
            int otherEpoch2 = this.epochs[position];
            if (probeDistance > otherProbeDistance) {
                Object otherKey = ScalaRunTime$.MODULE$.array_apply(this.keys, position);
                V otherValue = this.values[position];
                int otherHash = this.hashes[position];
                ScalaRunTime$.MODULE$.array_update(this.keys, position, k);
                this.values[position] = value;
                this.hashes[position] = h;
                this.epochs[position] = elemEpoch;
                probeDistance = otherProbeDistance + 1;
                elemEpoch = otherEpoch2;
                value = otherValue;
                h = otherHash;
                k = otherKey;
                position = position + 1 & this.Mask;
                continue;
            }
            ++probeDistance;
            position = position + 1 & this.Mask;
        }
        ScalaRunTime$.MODULE$.array_update(this.keys, position, k);
        this.values[position] = value;
        this.hashes[position] = h;
        this.epochs[position] = elemEpoch;
    }

    public abstract V compute(K var1);

    public abstract int hash(K var1);

    public abstract boolean isCacheable(V var1);

    public String toString() {
        return new StringBuilder(0).append("LruBoundedCache(").append(new StringBuilder(11).append(" values = ").append(Predef$.MODULE$.wrapRefArray((Object[])this.values).mkString("[", ",", "]")).append(",").toString()).append(new StringBuilder(11).append(" hashes = ").append(Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(this.hashes), (Function1)(JFunction1.mcII.sp & Serializable)x$1 -> x$1 & $this.Mask, (ClassTag)ClassTag$.MODULE$.Int())).mkString("[", ",", "]")).append(",").toString()).append(new StringBuilder(11).append(" epochs = ").append(Predef$.MODULE$.wrapIntArray(this.epochs).mkString("[", ",", "]")).append(",").toString()).append(new StringBuilder(14).append(" distances = ").append(ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.intArrayOps(this.hashes)).map((Function1)(JFunction1.mcII.sp & Serializable)slot -> this.probeDistanceOf(slot)).mkString("[", ",", "]")).append(",").toString()).append(new StringBuilder(2).append(" ").append(this.epoch).append(")").toString()).toString();
    }

    private final Option find$1(int position, int probeDistance, int h$1, Object k$1) {
        None$ none$;
        while (true) {
            int otherProbeDistance = this.probeDistanceOf(position);
            if (this.values[position] == null) {
                none$ = None$.MODULE$;
                break;
            }
            if (probeDistance > otherProbeDistance) {
                none$ = None$.MODULE$;
                break;
            }
            if (this.hashes[position] == h$1 && BoxesRunTime.equals((Object)k$1, (Object)ScalaRunTime$.MODULE$.array_apply(this.keys, position))) {
                none$ = new Some(this.values[position]);
                break;
            }
            ++probeDistance;
            position = position + 1 & this.Mask;
        }
        return none$;
    }

    private final Object findOrCalculate$1(int position, int probeDistance, Object k$2, int h$2) {
        V v;
        while (true) {
            if (this.values[position] == null) {
                V value = this.compute(k$2);
                if (this.isCacheable(value)) {
                    ScalaRunTime$.MODULE$.array_update(this.keys, position, k$2);
                    this.values[position] = value;
                    this.hashes[position] = h$2;
                    this.epochs[position] = this.epoch;
                }
                v = value;
                break;
            }
            int otherProbeDistance = this.probeDistanceOf(position);
            if (probeDistance > otherProbeDistance) {
                V value = this.compute(k$2);
                if (this.isCacheable(value)) {
                    this.move(position, k$2, h$2, value, this.epoch, probeDistance);
                }
                v = value;
                break;
            }
            if (this.hashes[position] == h$2 && BoxesRunTime.equals((Object)k$2, (Object)ScalaRunTime$.MODULE$.array_apply(this.keys, position))) {
                this.epochs[position] = this.epoch;
                v = this.values[position];
                break;
            }
            ++probeDistance;
            position = position + 1 & this.Mask;
        }
        return v;
    }

    public LruBoundedCache(int capacity, int evictAgeThreshold, ClassTag<K> evidence$1, ClassTag<V> evidence$2) {
        this.capacity = capacity;
        this.evictAgeThreshold = evictAgeThreshold;
        Predef$.MODULE$.require(capacity > 0, (Function0 & Serializable)() -> "Capacity must be larger than zero");
        Predef$.MODULE$.require((capacity & capacity - 1) == 0, (Function0 & Serializable)() -> "Capacity must be power of two");
        Predef$.MODULE$.require(evictAgeThreshold <= capacity, (Function0 & Serializable)() -> "Age threshold must be less than capacity.");
        this.Mask = capacity - 1;
        this.epoch = 0x7FFFFFFE;
        this.keys = Array$.MODULE$.ofDim(capacity, evidence$1);
        this.values = (Object[])Array$.MODULE$.ofDim(capacity, evidence$2);
        this.hashes = new int[capacity];
        this.epochs = (int[])Array$.MODULE$.fill(capacity, (Function0)(JFunction0.mcI.sp & Serializable)() -> $this.epoch - $this.evictAgeThreshold, (ClassTag)ClassTag$.MODULE$.Int());
    }
}

