/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.client.impl;

import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.client.impl.AbstractProducerCreditsImpl;
import org.apache.activemq.artemis.core.client.impl.ClientProducerFlowCallback;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;

public class AsynchronousProducerCreditsImpl
extends AbstractProducerCreditsImpl {
    int balance;
    final ClientProducerFlowCallback callback;

    public AsynchronousProducerCreditsImpl(ClientSessionInternal session, SimpleString address, int windowSize, ClientProducerFlowCallback callback) {
        super(session, address, windowSize);
        this.balance = windowSize;
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void actualAcquire(int credits) {
        AsynchronousProducerCreditsImpl asynchronousProducerCreditsImpl = this;
        synchronized (asynchronousProducerCreditsImpl) {
            this.balance -= credits;
            if (this.balance <= 0) {
                this.callback.onCreditsFlow(true, this);
            }
        }
    }

    @Override
    public int getBalance() {
        return this.balance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveCredits(int credits) {
        AsynchronousProducerCreditsImpl asynchronousProducerCreditsImpl = this;
        synchronized (asynchronousProducerCreditsImpl) {
            super.receiveCredits(credits);
            this.balance += credits;
            this.callback.onCreditsFlow(this.balance <= 0, this);
        }
    }

    @Override
    public void receiveFailCredits(int credits) {
        super.receiveFailCredits(credits);
        this.callback.onCreditsFail(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseOutstanding() {
        AsynchronousProducerCreditsImpl asynchronousProducerCreditsImpl = this;
        synchronized (asynchronousProducerCreditsImpl) {
            this.balance = 0;
            this.callback.onCreditsFlow(true, this);
        }
    }
}

