/*
 * Decompiled with CFR 0.152.
 */
package com.tqdev.metrics.influxdb;

import com.tqdev.metrics.core.MetricRegistry;
import com.tqdev.metrics.influxdb.InfluxDbReporter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;

public class InfluxDbHttpReporter
extends InfluxDbReporter {
    protected final String reportUrl;

    public InfluxDbHttpReporter(MetricRegistry registry, String instanceName, String reportUrl) {
        super(registry, instanceName);
        this.reportUrl = reportUrl;
    }

    public InfluxDbHttpReporter(MetricRegistry registry, String instanceName, String reportUrl, int intervalInSeconds) {
        super(registry, instanceName);
        this.reportUrl = reportUrl;
        this.run(intervalInSeconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean report() {
        if (!this.registry.isEnabled()) {
            return true;
        }
        URLConnection con = null;
        try {
            con = (HttpURLConnection)new URL(this.reportUrl).openConnection();
            ((HttpURLConnection)con).setRequestMethod("POST");
            con.setConnectTimeout(Long.valueOf(TimeUnit.SECONDS.toMillis(2L)).intValue());
            con.setReadTimeout(Long.valueOf(TimeUnit.SECONDS.toMillis(2L)).intValue());
            con.setDoOutput(true);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gzos = new GZIPOutputStream(baos);
            this.write(gzos);
            byte[] bytes = baos.toByteArray();
            con.setRequestProperty("Content-Encoding", "gzip");
            con.setRequestProperty("Content-Length", Long.toString(bytes.length));
            con.getOutputStream().write(bytes);
            if (((HttpURLConnection)con).getResponseCode() == 200) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (con != null) {
                try {
                    con.getInputStream().close();
                    con.getOutputStream().close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }
}

