/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.util.Map;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.environment.PropertyValueDescriptor;

public class EnvironmentCleaner {
    public Environment clean(Environment value, String workingDir, String uri) {
        Environment result = new Environment(value);
        for (PropertySource source : value.getPropertySources()) {
            String name = source.getName().replace(workingDir, "");
            name = name.replace("applicationConfig: [", "");
            name = uri + "/" + name.replace("]", "");
            result.add(new PropertySource(name, this.clean(source.getSource(), uri)));
        }
        return result;
    }

    protected Map<?, ?> clean(Map<?, ?> source, String uri) {
        for (Map.Entry<?, ?> entry : source.entrySet()) {
            if (!(entry.getValue() instanceof PropertyValueDescriptor)) continue;
            PropertyValueDescriptor descriptor = (PropertyValueDescriptor)entry.getValue();
            if (!uri.endsWith("/")) {
                uri = uri + "/";
            }
            String updated = descriptor.getOrigin().replace("[", "[" + uri);
            descriptor.setOrigin(updated);
        }
        return source;
    }
}

