/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.gcp.credentials;

import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.xebialabs.overthere.gcp.credentials.GcpCredentialFactory;
import com.xebialabs.overthere.gcp.credentials.ProjectCredentials;
import java.io.IOException;
import java.security.GeneralSecurityException;

class ServiceAccountTokenGcpCredentialFactory
extends GcpCredentialFactory {
    private final String projectId;
    private final String apiToken;
    private static final JsonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();
    private HttpTransport httpTransport;

    ServiceAccountTokenGcpCredentialFactory(String projectId, String apiToken) {
        this.projectId = projectId;
        this.apiToken = apiToken;
    }

    @Override
    protected ProjectCredentials doCreate() {
        try {
            this.httpTransport = GoogleNetHttpTransport.newTrustedTransport();
            TokenResponse tokenResponse = new TokenResponse();
            tokenResponse.setAccessToken(this.apiToken);
            return new ProjectCredentials(new Credential.Builder(BearerToken.authorizationHeaderAccessMethod()).setTransport(this.httpTransport).setJsonFactory(JSON_FACTORY).setTokenServerUrl(new GenericUrl("https://www.googleapis.com/auth/cloud-platform")).build().setFromTokenResponse(tokenResponse), this.projectId, "");
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalArgumentException(String.format("Cannot use credentials from Token : %s", this.apiToken), e);
        }
    }

    @Override
    public String info() {
        return String.format("credentials Api Token : %s", this.apiToken);
    }
}

