/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.testng.TestNGException;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Objects;
import org.testng.internal.ClassHelper;
import org.testng.reporters.XMLStringBuffer;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;
import org.testng.xml.XmlUtils;

public class XmlClass
implements Cloneable {
    private List<XmlInclude> m_includedMethods = Lists.newArrayList();
    private List<String> m_excludedMethods = Lists.newArrayList();
    private String m_name = null;
    private Class m_class = null;
    private int m_index;
    private boolean m_loadClasses = true;
    private Map<String, String> m_parameters = Maps.newHashMap();
    private XmlTest m_xmlTest;

    public XmlClass() {
        this.init("", null, 0, false);
    }

    public XmlClass(String string) {
        this.init(string, null, 0);
    }

    public XmlClass(String string, boolean bl) {
        this.init(string, null, 0, bl);
    }

    public XmlClass(Class clazz) {
        this.init(clazz.getName(), clazz, 0, true);
    }

    public XmlClass(Class clazz, boolean bl) {
        this.init(clazz.getName(), clazz, 0, bl);
    }

    public XmlClass(String string, int n) {
        this.init(string, null, n, true);
    }

    public XmlClass(String string, int n, boolean bl) {
        this.init(string, null, n, bl);
    }

    private void init(String string, Class clazz, int n) {
        this.init(string, clazz, n, true);
    }

    private void init(String string, Class clazz, int n, boolean bl) {
        this.m_name = string;
        this.m_class = clazz;
        this.m_index = n;
        if (null == this.m_class && bl) {
            this.loadClass();
        }
    }

    private void loadClass() {
        this.m_class = ClassHelper.forName(this.m_name);
        if (null == this.m_class) {
            throw new TestNGException("Cannot find class in classpath: " + this.m_name);
        }
    }

    public Class<?> getSupportClass() {
        if (this.m_class == null) {
            this.loadClass();
        }
        return this.m_class;
    }

    public void setClass(Class clazz) {
        this.m_class = clazz;
    }

    public List<String> getExcludedMethods() {
        return this.m_excludedMethods;
    }

    public void setExcludedMethods(List<String> list) {
        this.m_excludedMethods = list;
    }

    public List<XmlInclude> getIncludedMethods() {
        return this.m_includedMethods;
    }

    public void setIncludedMethods(List<XmlInclude> list) {
        this.m_includedMethods = list;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public boolean loadClasses() {
        return this.m_loadClasses;
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("class", this.m_name).toString();
    }

    public String toXml(String string) {
        boolean bl;
        XMLStringBuffer xMLStringBuffer = new XMLStringBuffer(string);
        Properties properties = new Properties();
        properties.setProperty("name", this.getName());
        boolean bl2 = !this.m_includedMethods.isEmpty() || !this.m_excludedMethods.isEmpty();
        boolean bl3 = bl = !this.m_parameters.isEmpty();
        if (bl || bl2) {
            xMLStringBuffer.push("class", properties);
            XmlUtils.dumpParameters(xMLStringBuffer, this.m_parameters);
            if (bl2) {
                xMLStringBuffer.push("methods");
                for (XmlInclude object : this.getIncludedMethods()) {
                    xMLStringBuffer.getStringBuffer().append(object.toXml(string + "    "));
                }
                for (String string2 : this.getExcludedMethods()) {
                    Properties properties2 = new Properties();
                    properties2.setProperty("name", string2);
                    xMLStringBuffer.addEmptyElement("exclude", properties2);
                }
                xMLStringBuffer.pop("methods");
            }
            xMLStringBuffer.pop("class");
        } else {
            xMLStringBuffer.addEmptyElement("class", properties);
        }
        return xMLStringBuffer.toXML();
    }

    public static String listToString(List<Integer> list) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (Integer n2 : list) {
            if (n++ > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(n2);
        }
        return stringBuilder.toString();
    }

    public Object clone() {
        XmlClass xmlClass = new XmlClass(this.getName(), this.getIndex(), this.loadClasses());
        xmlClass.setExcludedMethods(this.getExcludedMethods());
        xmlClass.setIncludedMethods(this.getIncludedMethods());
        return xmlClass;
    }

    public int getIndex() {
        return this.m_index;
    }

    public void setIndex(int n) {
        this.m_index = n;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.m_class == null ? 0 : this.m_class.hashCode());
        n = 31 * n + (this.m_loadClasses ? 1 : 0);
        n = 31 * n + (this.m_excludedMethods == null ? 0 : this.m_excludedMethods.hashCode());
        n = 31 * n + (this.m_includedMethods == null ? 0 : this.m_includedMethods.hashCode());
        n = 31 * n + this.m_index;
        n = 31 * n + (this.m_name == null ? 0 : this.m_name.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return XmlSuite.f();
        }
        if (this.getClass() != object.getClass()) {
            return XmlSuite.f();
        }
        XmlClass xmlClass = (XmlClass)object;
        if (xmlClass.m_loadClasses != this.m_loadClasses || !this.m_excludedMethods.equals(xmlClass.m_excludedMethods)) {
            return XmlSuite.f();
        }
        if (this.m_includedMethods == null ? xmlClass.m_includedMethods != null : !this.m_includedMethods.equals(xmlClass.m_includedMethods)) {
            return XmlSuite.f();
        }
        if (this.m_name == null ? xmlClass.m_name != null : !this.m_name.equals(xmlClass.m_name)) {
            return XmlSuite.f();
        }
        return true;
    }

    public void setParameters(Map<String, String> map) {
        this.m_parameters.clear();
        this.m_parameters.putAll(map);
    }

    public Map<String, String> getAllParameters() {
        Map<String, String> map = Maps.newHashMap();
        if (this.m_xmlTest != null) {
            map.putAll(this.m_xmlTest.getLocalParameters());
        }
        map.putAll(this.m_parameters);
        return map;
    }

    public Map<String, String> getLocalParameters() {
        return this.m_parameters;
    }

    @Deprecated
    public Map<String, String> getParameters() {
        return this.getAllParameters();
    }

    public void setXmlTest(XmlTest xmlTest) {
        this.m_xmlTest = xmlTest;
    }
}

