/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.rest.api.support.PaginationSupport;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.spi.event.UserCreatedEvent;
import com.xebialabs.deployit.engine.spi.event.UserDeletedEvent;
import com.xebialabs.deployit.engine.spi.event.UserPasswordChangedEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.User;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.security.validator.UserValidator;
import com.xebialabs.xlplatform.security.dto.PasswordValidationResult;
import java.util.List;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.spi.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.session.SessionInformation;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.web.authentication.rememberme.PersistentTokenRepository;
import org.springframework.session.SessionRepository;
import org.springframework.stereotype.Controller;

@Controller
public class UserResource
extends AbstractSecuredResource
implements com.xebialabs.deployit.engine.api.UserService {
    @Context
    private HttpResponse response;
    @Autowired
    UserService userService;
    @Autowired
    UserValidator userValidator;
    @Autowired
    SessionRegistry sessionRegistry;
    @Autowired
    SessionRepository sessionRepository;
    @Autowired
    PersistentTokenRepository persistentTokenRepository;
    private static final Logger logger = LoggerFactory.getLogger(UserResource.class);

    public com.xebialabs.deployit.engine.api.security.User create(String username, com.xebialabs.deployit.engine.api.security.User user) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        UserResource.sanityCheckUser(username, user);
        this.userValidator.check(user);
        logger.debug("Creating user {}", (Object)username);
        this.userService.create(username, user.getPassword());
        User u = this.userService.read(username);
        logger.debug("Created user {}", (Object)u.getUsername());
        EventBusHolder.publish((Object)new UserCreatedEvent(username));
        return new com.xebialabs.deployit.engine.api.security.User(u.getUsername(), u.isAdmin());
    }

    public com.xebialabs.deployit.engine.api.security.User read(String username) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        User u = this.userService.read(username);
        return new com.xebialabs.deployit.engine.api.security.User(u.getUsername(), u.isAdmin());
    }

    public List<String> listUserNames(String username, Paging paging, Ordering order) {
        this.checkPermissions(new Permission[]{PlatformPermissions.EDIT_SECURITY, PlatformPermissions.VIEW_SECURITY});
        List usernames = this.userService.listUsernames(username, paging, order);
        PaginationSupport.addTotalCountHeader((long)this.userService.countUsers(username), (HttpResponse)this.response);
        return usernames;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void modifyPassword(String username, com.xebialabs.deployit.engine.api.security.User user) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        UserResource.sanityCheckUser(username, user);
        this.userValidator.checkPassword(user);
        Authentication authentication = Permissions.getAuthentication();
        if (username.equals(authentication.getName())) {
            if (user.getCurrentPassword() == null || user.getCurrentPassword().trim().isEmpty()) throw new IllegalArgumentException("Current password is mandatory ");
            this.userService.modifyPassword(username, user.getPassword(), user.getCurrentPassword());
        } else {
            this.userService.modifyPassword(username, user.getPassword());
        }
        EventBusHolder.publish((Object)new UserPasswordChangedEvent(username));
    }

    public List<PasswordValidationResult> validatePassword(com.xebialabs.deployit.engine.api.security.User user) {
        String password = user.getPassword() == null ? "" : user.getPassword();
        return this.userValidator.validatePassword(password);
    }

    public void delete(String username) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        this.userService.delete(username);
        this.expireUserSession(username);
        EventBusHolder.publish((Object)new UserDeletedEvent(username));
    }

    private void expireUserSession(String username) {
        for (SessionInformation information : this.sessionRegistry.getAllSessions((Object)username, false)) {
            this.sessionRepository.deleteById(information.getSessionId());
        }
        this.persistentTokenRepository.removeUserTokens(username);
    }

    private static void sanityCheckUser(String username, com.xebialabs.deployit.engine.api.security.User user) {
        if (user.getUsername() == null || user.getUsername().trim().isEmpty()) {
            throw new IllegalArgumentException("User name cannot be empty");
        }
        if (!user.getUsername().equals(username)) {
            throw new IllegalArgumentException("Username in URL is " + username + " but username in POST data is " + user.getUsername());
        }
    }

    void setUserService(UserService userService) {
        this.userService = userService;
    }

    void setUserValidator(UserValidator userValidator) {
        this.userValidator = userValidator;
    }
}

