/*
 * Decompiled with CFR 0.152.
 */
package com.tqdev.metrics.influxdb;

import com.tqdev.metrics.core.MetricRegistry;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

abstract class InfluxDbReporter {
    protected final String instanceName;
    protected final MetricRegistry registry;
    private final ScheduledExecutorService exec;

    public InfluxDbReporter(MetricRegistry registry, String instanceName) {
        this.instanceName = instanceName;
        this.registry = registry;
        this.exec = Executors.newSingleThreadScheduledExecutor();
    }

    public void write(OutputStream out) {
        PrintWriter w = new PrintWriter(out);
        String instanceStr = this.instanceName.replaceAll("[, =]", "\\$1");
        String time = String.valueOf(this.registry.getMillis() / 1000L * 1000000000L);
        for (String type : this.registry.getTypes()) {
            String typeStr = type.replaceAll("[, ]", "\\$1");
            for (String key : this.registry.getKeys(type)) {
                String keyStr = key.replaceAll("[, =]", "\\$1");
                String[] parts = typeStr.split("\\.", 3);
                w.print(parts[0]);
                w.print(",host=");
                w.print(instanceStr);
                w.print(",instance=");
                if (parts.length > 1) {
                    w.print(parts[1]);
                }
                w.print(",type=");
                if (parts.length > 2) {
                    w.append(parts[2]);
                }
                w.print(",type_instance=");
                w.print(keyStr);
                w.print(" value=");
                w.print(this.registry.get(type, key));
                w.println("i " + time);
            }
        }
        w.close();
    }

    public abstract boolean report();

    public void run(int intervalInSeconds) {
        this.exec.scheduleAtFixedRate(() -> this.report(), 1L, intervalInSeconds, TimeUnit.SECONDS);
    }

    public void shutdown() {
        this.exec.shutdown();
    }
}

