/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.xebialabs.deployit.security.SecurityServiceLocator;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.FilterInvocation;

public class LoginPermissionVoter
implements AccessDecisionVoter<Object> {
    private Set<String> whitelistUrls = new HashSet<String>();
    private static final Logger logger = LoggerFactory.getLogger(LoginPermissionVoter.class);

    public boolean supports(ConfigAttribute attribute) {
        return true;
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }

    public int vote(Authentication authentication, Object object, Collection<ConfigAttribute> attributes) {
        String requestUrl;
        if (object instanceof FilterInvocation && this.whitelistUrls.contains(requestUrl = ((FilterInvocation)object).getRequestUrl())) {
            logger.debug("Endpoint [{}] is whitelisted", (Object)requestUrl);
            return 1;
        }
        logger.debug("Checking authorization for [{}]", (Object)authentication.getName());
        if (SecurityServiceLocator.getPermissionEnforcer().hasPermission(authentication, PlatformPermissions.LOGIN)) {
            logger.debug("User [{}] is authorized for login", (Object)authentication.getName());
            return 1;
        }
        logger.error("User [{}] is not allowed to login to XL Deploy.", (Object)authentication.getName());
        return -1;
    }

    public void setWhitelistUrls(Set<String> whitelistUrls) {
        this.whitelistUrls = whitelistUrls;
    }
}

