/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.rpc.callback;

import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.rpc.callback.CallbackReplyMessage;
import org.rzo.netty.ahessian.rpc.callback.ClientCallback;
import org.rzo.netty.ahessian.rpc.client.HessianProxyFuture;
import org.rzo.netty.ahessian.rpc.message.HessianRPCCallMessage;
import org.rzo.netty.ahessian.rpc.server.HessianRPCServiceHandler;

public class ServerCallbackProxy
implements InvocationHandler,
Constants {
    private boolean _done = false;
    private HessianRPCServiceHandler _handler;
    private HessianRPCCallMessage _message;
    private ClientCallback _clientCallback;
    boolean _closed = false;
    private Set<String> _returnMethods;
    private static AtomicLong _idCounter = new AtomicLong();
    private static Map<Long, HessianProxyFuture> _openCallbackCalls = new ConcurrentHashMap<Long, HessianProxyFuture>();
    private static Timer _timer = new HashedWheelTimer();

    public ServerCallbackProxy(HessianRPCServiceHandler handler, HessianRPCCallMessage message, ClientCallback clientCallback) {
        this._message = message;
        this._clientCallback = clientCallback;
        this._handler = handler;
        this._returnMethods = new HashSet<String>();
        if (clientCallback.getReturnMethods() != null) {
            for (String method : clientCallback.getReturnMethods()) {
                this._returnMethods.add(method);
            }
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return this.invoke(method.getName(), args);
    }

    public Object invoke(String method, Object[] args) {
        if (this._closed) {
            throw new RuntimeException("cannot invoke callback after call to setDone(true)");
        }
        String methodName = method;
        if ("setDone".equals(methodName) && args.length == 1 && args[0] instanceof Boolean) {
            this._done = (Boolean)args[0];
            return null;
        }
        if ("isDone".equals(method) && (args == null || args.length == 0)) {
            return this._done;
        }
        if ("isValid".equals(method) && (args == null || args.length == 0)) {
            return this._message.isValid();
        }
        if ("toString".equals(method) && (args == null || args.length == 0)) {
            return this.toString();
        }
        if ("hashCode".equals(method) && (args == null || args.length == 0)) {
            return this.hashCode();
        }
        if ("equals".equals(method) && args.length == 1) {
            return this.equals(args[0]);
        }
        CallbackReplyMessage reply = new CallbackReplyMessage(methodName, args, null, this._message);
        reply.setCallId((Long)this._message.getHeaders().get(CALL_ID_HEADER_KEY));
        reply.setGroup((Integer)this._message.getHeaders().get(GROUP_HEADER_KEY));
        reply.setCallbackId(this._clientCallback.getId());
        reply.setCallbackArgs(args);
        reply.setCallbackMethod(methodName);
        reply.setCallbackCallId(_idCounter.incrementAndGet());
        if (this._done) {
            reply.setCallbackDone(true);
        }
        HessianProxyFuture future = null;
        if (this._returnMethods.contains(methodName)) {
            future = new HessianProxyFuture();
            _openCallbackCalls.put(reply.getCallbackCallId(), future);
        }
        this._handler.writeResult(reply);
        if (this._done) {
            this._closed = true;
        }
        Object result = null;
        if (this._returnMethods.contains(methodName)) {
            result = this.waitForCallbackResult(reply.getCallbackCallId(), future);
        }
        return result;
    }

    private Object waitForCallbackResult(final Long id, final HessianProxyFuture future) {
        long timeout = 10000L;
        if (timeout > 0L) {
            TimerTask task = new TimerTask(){

                public void run(Timeout arg0) throws Exception {
                    _openCallbackCalls.remove(id);
                    future.timedOut();
                }
            };
            future.setTimeout(_timer.newTimeout(task, timeout, TimeUnit.MILLISECONDS));
        }
        try {
            return future.getCallbackResult();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setCallbackResult(HessianRPCCallMessage reply) {
        Long id = (Long)reply.getHeaders().get(CALLBACK_CALL_ID_HEADER_KEY);
        if (id == null) {
            return;
        }
        HessianProxyFuture future = _openCallbackCalls.get(id);
        if (future == null) {
            return;
        }
        future.setCallbackResult(reply);
    }
}

