/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer.reactive;

import java.net.URI;
import java.util.Map;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerUriTools;
import org.springframework.http.HttpMethod;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.ClientRequest;

public final class ExchangeFilterFunctionUtils {
    private ExchangeFilterFunctionUtils() {
        throw new IllegalStateException("Can't instantiate a utility class.");
    }

    static String getHint(String serviceId, Map<String, String> hints) {
        String defaultHint = hints.getOrDefault("default", "default");
        String hintPropertyValue = hints.get(serviceId);
        return hintPropertyValue != null ? hintPropertyValue : defaultHint;
    }

    static ClientRequest buildClientRequest(ClientRequest request, ServiceInstance serviceInstance, String instanceIdCookieName, boolean addServiceInstanceCookie) {
        URI originalUrl = request.url();
        return ClientRequest.create((HttpMethod)request.method(), (URI)LoadBalancerUriTools.reconstructURI(serviceInstance, originalUrl)).headers(headers -> headers.addAll((MultiValueMap)request.headers())).cookies(cookies -> {
            cookies.addAll(request.cookies());
            if (instanceIdCookieName != null && instanceIdCookieName.length() != 0 && addServiceInstanceCookie) {
                cookies.add((Object)instanceIdCookieName, (Object)serviceInstance.getInstanceId());
            }
        }).attributes(attributes -> attributes.putAll(request.attributes())).body(request.body()).build();
    }

    static String serviceInstanceUnavailableMessage(String serviceId) {
        return "LoadBalancer does not contain an instance for the service " + serviceId;
    }
}

