/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal;

import java.util.LinkedList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.journal.impl.SimpleWaitIOCallback;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.utils.ExecutorFactory;

public class OperationContextImpl
implements OperationContext {
    private static final ThreadLocal<OperationContext> threadLocalContext = new ThreadLocal();
    private LinkedList<TaskHolder> tasks;
    private LinkedList<StoreOnlyTaskHolder> storeOnlyTasks;
    private long minimalStore = Long.MAX_VALUE;
    private long minimalReplicated = Long.MAX_VALUE;
    private long minimalPage = Long.MAX_VALUE;
    private final AtomicLong storeLineUp = new AtomicLong(0L);
    private final AtomicLong replicationLineUp = new AtomicLong(0L);
    private final AtomicLong pageLineUp = new AtomicLong(0L);
    private long stored = 0L;
    private long replicated = 0L;
    private long paged = 0L;
    private int errorCode = -1;
    private String errorMessage = null;
    private final Executor executor;
    private final AtomicInteger executorsPending = new AtomicInteger(0);

    public static void clearContext() {
        threadLocalContext.set(null);
    }

    public static final OperationContext getContext() {
        return OperationContextImpl.getContext(null);
    }

    public static OperationContext getContext(ExecutorFactory executorFactory) {
        OperationContext token = threadLocalContext.get();
        if (token == null) {
            if (executorFactory == null) {
                return null;
            }
            token = new OperationContextImpl((Executor)executorFactory.getExecutor());
            threadLocalContext.set(token);
        }
        return token;
    }

    public static void setContext(OperationContext context) {
        threadLocalContext.set(context);
    }

    public OperationContextImpl(Executor executor) {
        this.executor = executor;
    }

    @Override
    public void pageSyncLineUp() {
        this.pageLineUp.incrementAndGet();
    }

    @Override
    public synchronized void pageSyncDone() {
        ++this.paged;
        this.checkTasks();
    }

    public void storeLineUp() {
        this.storeLineUp.incrementAndGet();
    }

    @Override
    public void replicationLineUp() {
        this.replicationLineUp.incrementAndGet();
    }

    @Override
    public synchronized void replicationDone() {
        ++this.replicated;
        this.checkTasks();
    }

    @Override
    public void executeOnCompletion(IOCallback runnable) {
        this.executeOnCompletion(runnable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeOnCompletion(IOCallback completion, boolean storeOnly) {
        if (this.errorCode != -1) {
            completion.onError(this.errorCode, this.errorMessage);
            return;
        }
        boolean executeNow = false;
        OperationContextImpl operationContextImpl = this;
        synchronized (operationContextImpl) {
            int UNDEFINED = Integer.MIN_VALUE;
            int storeLined = Integer.MIN_VALUE;
            int pageLined = Integer.MIN_VALUE;
            int replicationLined = Integer.MIN_VALUE;
            if (storeOnly) {
                if (this.storeOnlyTasks == null) {
                    this.storeOnlyTasks = new LinkedList();
                }
            } else if (this.tasks == null) {
                this.tasks = new LinkedList();
                replicationLined = this.replicationLineUp.intValue();
                this.minimalReplicated = replicationLined;
                storeLined = this.storeLineUp.intValue();
                this.minimalStore = storeLined;
                pageLined = this.pageLineUp.intValue();
                this.minimalPage = pageLined;
            }
            if (replicationLined == Integer.MIN_VALUE) {
                replicationLined = this.replicationLineUp.intValue();
                storeLined = this.storeLineUp.intValue();
                pageLined = this.pageLineUp.intValue();
            }
            if ((long)replicationLined == this.replicated && (long)storeLined == this.stored && (long)pageLined == this.paged) {
                if (this.executorsPending.get() == 0) {
                    executeNow = true;
                } else {
                    this.execute(completion);
                }
            } else if (storeOnly) {
                assert (this.storeOnlyTasks.isEmpty() || this.storeOnlyTasks.peekLast().storeLined <= storeLined);
                this.storeOnlyTasks.add(new StoreOnlyTaskHolder(completion, storeLined));
            } else {
                assert (this.validateTasksAdd(storeLined, replicationLined, pageLined));
                this.tasks.add(new TaskHolder(completion, storeLined, replicationLined, pageLined));
            }
        }
        if (executeNow) {
            completion.done();
        }
    }

    private boolean validateTasksAdd(int storeLined, int replicationLined, int pageLined) {
        if (this.tasks.isEmpty()) {
            return true;
        }
        TaskHolder holder = this.tasks.peekLast();
        return holder.storeLined <= storeLined && holder.replicationLined <= replicationLined && holder.pageLined <= pageLined;
    }

    public synchronized void done() {
        ++this.stored;
        this.checkTasks();
    }

    private void checkStoreTasks() {
        LinkedList<StoreOnlyTaskHolder> storeOnlyTasks = this.storeOnlyTasks;
        assert (storeOnlyTasks != null);
        int size = storeOnlyTasks.size();
        if (size == 0) {
            return;
        }
        long stored = this.stored;
        for (int i = 0; i < size; ++i) {
            StoreOnlyTaskHolder holder = storeOnlyTasks.peek();
            if ((long)holder.storeLined < stored) {
                return;
            }
            this.execute(holder.task);
            StoreOnlyTaskHolder removed = storeOnlyTasks.poll();
            assert (removed == holder);
        }
    }

    private void checkCompleteContext() {
        LinkedList<TaskHolder> tasks = this.tasks;
        assert (tasks != null);
        int size = this.tasks.size();
        if (size == 0) {
            return;
        }
        assert (size >= 1);
        for (int i = 0; i < size; ++i) {
            TaskHolder holder = tasks.peek();
            if (this.stored < (long)holder.storeLined || this.replicated < (long)holder.replicationLined || this.paged < (long)holder.pageLined) {
                return;
            }
            this.execute(holder.task);
            TaskHolder removed = tasks.poll();
            assert (removed == holder);
        }
    }

    private void checkTasks() {
        if (this.storeOnlyTasks != null) {
            this.checkStoreTasks();
        }
        if (this.stored >= this.minimalStore && this.replicated >= this.minimalReplicated && this.paged >= this.minimalPage) {
            this.checkCompleteContext();
        }
    }

    private void execute(final IOCallback task) {
        this.executorsPending.incrementAndGet();
        try {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        OperationContextImpl.clearContext();
                        task.done();
                    }
                    finally {
                        OperationContextImpl.this.executorsPending.decrementAndGet();
                    }
                }
            });
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.errorExecutingAIOCallback(e);
            this.executorsPending.decrementAndGet();
            task.onError(ActiveMQExceptionType.INTERNAL_ERROR.getCode(), "It wasn't possible to complete IO operation - " + e.getMessage());
        }
    }

    public void complete() {
    }

    public synchronized void onError(int errorCode, String errorMessage) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        if (this.tasks != null) {
            int size = this.tasks.size();
            for (int i = 0; i < size; ++i) {
                TaskHolder holder = this.tasks.poll();
                holder.task.onError(errorCode, errorMessage);
            }
        }
    }

    @Override
    public void waitCompletion() throws Exception {
        this.waitCompletion(0L);
    }

    @Override
    public boolean waitCompletion(long timeout) throws InterruptedException, ActiveMQException {
        SimpleWaitIOCallback waitCallback = new SimpleWaitIOCallback();
        this.executeOnCompletion((IOCallback)waitCallback);
        this.complete();
        if (timeout == 0L) {
            waitCallback.waitCompletion();
            return true;
        }
        return waitCallback.waitCompletion(timeout);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.tasks != null) {
            for (TaskHolder hold : this.tasks) {
                buffer.append("Task = " + hold + "\n");
            }
        }
        return "OperationContextImpl [" + this.hashCode() + "] [minimalStore=" + this.minimalStore + ", storeLineUp=" + this.storeLineUp + ", stored=" + this.stored + ", minimalReplicated=" + this.minimalReplicated + ", replicationLineUp=" + this.replicationLineUp + ", replicated=" + this.replicated + ", paged=" + this.paged + ", minimalPage=" + this.minimalPage + ", pageLineUp=" + this.pageLineUp + ", errorCode=" + this.errorCode + ", errorMessage=" + this.errorMessage + ", executorsPending=" + this.executorsPending + ", executor=" + this.executor + "]" + buffer.toString();
    }

    static final class StoreOnlyTaskHolder {
        final int storeLined;
        final IOCallback task;

        public String toString() {
            return "StoreOnlyTaskHolder [storeLined=" + this.storeLined + ", task=" + this.task + "]";
        }

        StoreOnlyTaskHolder(IOCallback task, int storeLined) {
            this.storeLined = storeLined;
            this.task = task;
        }
    }

    static final class TaskHolder {
        final int storeLined;
        final int replicationLined;
        final int pageLined;
        final IOCallback task;

        public String toString() {
            return "TaskHolder [storeLined=" + this.storeLined + ", replicationLined=" + this.replicationLined + ", pageLined=" + this.pageLined + ", task=" + this.task + "]";
        }

        TaskHolder(IOCallback task, int storeLined, int replicationLined, int pageLined) {
            this.storeLined = storeLined;
            this.replicationLined = replicationLined;
            this.pageLined = pageLined;
            this.task = task;
        }
    }
}

