/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.checkconstraint;

import com.datical.liquibase.ext.license.LicenseCheckingSnapshotGenerator;
import com.datical.liquibase.ext.storedlogic.checkconstraint.CheckConstraint;
import com.datical.liquibase.ext.storedlogic.checkconstraint.CheckConstraintSnapshotGenerator$1;
import com.datical.liquibase.ext.storedlogic.checkconstraint.CheckConstraintSnapshotGenerator$SqlExt;
import com.datical.liquibase.ext.storedlogic.checkconstraint.postgres.PostgresCheckConstraintSnapshotGenerator;
import com.datical.liquibase.ext.util.CachedQueryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.Db2zDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.diff.compare.DatabaseObjectComparatorFactory;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.ExecutorService;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.util.JdbcUtils;
import liquibase.util.StringUtil;

public class CheckConstraintSnapshotGenerator
extends LicenseCheckingSnapshotGenerator {
    private boolean foundAllCheckConstraints = false;

    public CheckConstraintSnapshotGenerator() {
        super(CheckConstraint.class, new Class[]{Schema.class, Table.class});
    }

    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (database instanceof OracleDatabase || database instanceof MSSQLDatabase || database instanceof MySQLDatabase && ((MySQLDatabase)database).isMinimumMySQLVersion("8.0.16") || database instanceof AbstractDb2Database || database instanceof PostgresDatabase) {
            return super.getPriority(clazz, database);
        }
        return -1;
    }

    @Override
    protected DatabaseObject snapshotObject(DatabaseObject databaseObject, DatabaseSnapshot list) {
        if (this.foundAllCheckConstraints) {
            return databaseObject;
        }
        Database database = ((DatabaseSnapshot)((Object)list)).getDatabase();
        Table table = ((CheckConstraint)databaseObject).getTable();
        String string = this.getSnapshotObjectSql(databaseObject, database, table);
        list = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", ((DatabaseSnapshot)((Object)list)).getDatabase()).queryForList(new RawSqlStatement(string));
        if (list.size() == 0) {
            return null;
        }
        try {
            JdbcUtils.requiredSingleResult(list);
        }
        catch (DatabaseException databaseException) {
            Scope.getCurrentScope().getLog(this.getClass()).severe("Error snapshotting " + databaseObject + " with result set of " + string, databaseException);
            throw databaseException;
        }
        list = (Map)list.get(0);
        databaseObject = this.mapBaseResultSetToCheckConstraint(database, (Map<String, ?>)((Object)list));
        ((CheckConstraint)databaseObject).setTable(table);
        return databaseObject;
    }

    protected String getSnapshotObjectSql(DatabaseObject databaseObject, Database object, Table table) {
        if (object instanceof PostgresDatabase) {
            return new PostgresCheckConstraintSnapshotGenerator().getSnapshotObjectSql(databaseObject, (Database)object, table);
        }
        if (object instanceof OracleDatabase) {
            object = "SELECT OWNER, CONSTRAINT_NAME, TABLE_NAME, SEARCH_CONDITION, STATUS, VALIDATED FROM all_constraints  WHERE constraint_type = 'C'";
            if (databaseObject.getName() != null) {
                object = (String)object + " and constraint_name='" + databaseObject.getName() + "'";
            }
            if (((CheckConstraint)databaseObject).getTable() != null) {
                object = (String)object + " and table_name='" + ((CheckConstraint)databaseObject).getTable().getName() + "'";
                if (((CheckConstraint)databaseObject).getTable().getSchema() != null && ((CheckConstraint)databaseObject).getTable().getSchema().getCatalogName() != null) {
                    object = (String)object + " and owner='" + ((CheckConstraint)databaseObject).getTable().getSchema().getCatalogName() + "'";
                }
            }
        } else if (object instanceof DB2Database) {
            object = "SELECT CHECKS.CONSTNAME AS CONSTRAINT_NAME, CHECKS.TEXT AS SEARCH_CONDITION, TABCONST.ENFORCED AS ENFORCED, CHECKS.TABNAME AS TABLE_NAME FROM SYSCAT.CHECKS CHECKS INNER JOIN SYSCAT.TABCONST TABCONST ON TABCONST.CONSTNAME=CHECKS.CONSTNAME AND TABCONST.TABSCHEMA=CHECKS.TABSCHEMA AND TABCONST.TABNAME=CHECKS.TABNAME WHERE CHECKS.TYPE != 'S' AND CHECKS.TABSCHEMA='" + ((CheckConstraint)databaseObject).getTable().getSchema().getCatalogName() + "' AND CHECKS.TABNAME='" + ((CheckConstraint)databaseObject).getTable().getName() + "'AND CHECKS.CONSTNAME='" + databaseObject.getName() + "'";
        } else if (object instanceof Db2zDatabase) {
            object = "SELECT CHECKNAME AS CONSTRAINT_NAME, CHECKCONDITION AS SEARCH_CONDITION, 'Y' AS ENFORCED, TBNAME AS TABLE_NAME FROM SYSIBM.SYSCHECKS WHERE TBOWNER='" + ((CheckConstraint)databaseObject).getTable().getSchema().getCatalogName() + "' AND TBNAME='" + ((CheckConstraint)databaseObject).getTable().getName() + "'AND CHECKNAME='" + databaseObject.getName() + "'";
        } else if (object instanceof MySQLDatabase) {
            object = "select TABLE_SCHEMA, TABLE_NAME, CONSTRAINT_NAME from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where CONSTRAINT_TYPE = 'CHECK' and TABLE_SCHEMA = '" + ((CheckConstraint)databaseObject).getTable().getSchema().getName() + "'and TABLE_NAME = '" + ((CheckConstraint)databaseObject).getTable().getName() + "'";
        } else if (object instanceof MSSQLDatabase) {
            object = databaseObject.getSchema() == null ? "dbo" : databaseObject.getSchema().getName();
            object = "SELECT  sys.objects.name AS CONSTRAINT_NAME, syscomments.text AS SEARCH_CONDITION, IS_DISABLED as IS_DISABLED FROM sys.objects INNER JOIN sys.schemas ON sys.objects.schema_id = sys.schemas.schema_id and lower(sys.schemas.name)='" + (String)object + "' INNER JOIN syscomments ON syscomments.id = sys.objects.object_id INNER JOIN sys.objects parent on objects.parent_object_id=parent.object_id and parent.name='" + table.getName() + "' and parent.type_desc='USER_TABLE' INNER JOIN sys.check_constraints ON check_constraints.object_id = sys.objects.object_id where objects.type_desc='CHECK_CONSTRAINT' and sys.objects.name='" + databaseObject.getName() + "'";
        } else {
            throw new UnexpectedLiquibaseException("Unsupported database for check constraint snapshot" + object.getShortName());
        }
        return object;
    }

    private CheckConstraint mapBaseResultSetToCheckConstraint(Database object, Map<String, ?> map) {
        CheckConstraint checkConstraint = new CheckConstraint();
        checkConstraint.setName((String)map.get("CONSTRAINT_NAME"));
        checkConstraint.setBody(StringUtil.trimToNull((String)map.get("SEARCH_CONDITION")));
        if (object instanceof PostgresDatabase) {
            checkConstraint.setDisabled(!map.get("STATUS").equals("ENABLED"));
        } else if (object instanceof OracleDatabase) {
            checkConstraint.setDisabled(!map.get("STATUS").equals("ENABLED"));
            checkConstraint.setValidate("VALIDATED".equalsIgnoreCase(map.get("VALIDATED").toString()));
        } else if (object instanceof MySQLDatabase) {
            object = (String)map.get("ENFORCED");
            if (object != null && ((String)object).toUpperCase().equals("NOT ENFORCED")) {
                checkConstraint.setDisabled(true);
            } else {
                checkConstraint.setDisabled(false);
            }
        } else if (object instanceof AbstractDb2Database) {
            checkConstraint.setDisabled(!map.get("ENFORCED").equals("Y"));
        } else if (object instanceof MSSQLDatabase) {
            checkConstraint.setDisabled((Boolean)map.get("IS_DISABLED"));
        } else {
            throw new UnexpectedLiquibaseException("Unknown database type for check constraint snapshot: " + object.getShortName());
        }
        return checkConstraint;
    }

    @Override
    protected void addTo(DatabaseObject databaseObject, DatabaseSnapshot iterator) {
        if (!((DatabaseSnapshot)((Object)iterator)).getSnapshotControl().shouldInclude(CheckConstraint.class)) {
            return;
        }
        Database database = ((DatabaseSnapshot)((Object)iterator)).getDatabase();
        if (databaseObject instanceof Table) {
            List list;
            Table table = (Table)databaseObject;
            if (this.foundAllCheckConstraints) {
                Schema object2 = ((DatabaseSnapshot)((Object)iterator)).get(databaseObject.getSchema());
                if (object2 != null) {
                    for (CheckConstraint checkConstraint : object2.getDatabaseObjects(CheckConstraint.class)) {
                        if (!DatabaseObjectComparatorFactory.getInstance().isSameObject(checkConstraint.getTable(), databaseObject, null, database)) continue;
                        ArrayList<CheckConstraint> arrayList = (ArrayList<CheckConstraint>)((Object)table.getAttribute("checkConstraints", List.class));
                        if (arrayList == null) {
                            arrayList = new ArrayList<CheckConstraint>();
                            table.setAttribute("checkConstraints", arrayList);
                        }
                        arrayList.add(checkConstraint);
                        this.sortCheckConstraints(arrayList);
                    }
                }
            } else {
                String string = this.getAddToSql(database, table);
                for (Map<String, ?> map : Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", ((DatabaseSnapshot)((Object)iterator)).getDatabase()).queryForList(new RawSqlStatement(string))) {
                    CheckConstraint checkConstraint = new CheckConstraint().setName(this.cleanNameFromDatabase((String)map.get("CONSTRAINT_NAME"), database)).setTable(table).setBody((String)map.get("SEARCH_CONDITION"));
                    ArrayList<CheckConstraint> arrayList = (ArrayList<CheckConstraint>)((Object)table.getAttribute("checkConstraints", List.class));
                    if (!this.isSystemConstraint(checkConstraint)) continue;
                    if (arrayList == null) {
                        arrayList = new ArrayList<CheckConstraint>();
                        table.setAttribute("checkConstraints", arrayList);
                    }
                    arrayList.add(checkConstraint);
                }
            }
            if ((list = (List)((Object)table.getAttribute("checkConstraints", List.class))) != null) {
                this.sortCheckConstraints(list);
            }
            return;
        }
        if (databaseObject instanceof Schema) {
            CheckConstraintSnapshotGenerator$SqlExt checkConstraintSnapshotGenerator$SqlExt = this.getAddToSqlForSchema(databaseObject, (DatabaseSnapshot)((Object)iterator), database);
            for (Map map : CachedQueryUtil.queryIfNotCached(checkConstraintSnapshotGenerator$SqlExt.isFetchedAcrossSchemas(), checkConstraintSnapshotGenerator$SqlExt.getSql(), "CheckConstraintSnapshotGenerator.allConstraints", iterator)) {
                String string;
                String string2;
                CheckConstraint checkConstraint = this.mapBaseResultSetToCheckConstraint(database, map);
                if (database instanceof OracleDatabase) {
                    string2 = (String)map.get("OWNER");
                    string = (String)map.get("OWNER");
                } else {
                    string2 = StringUtil.trimToNull(((Schema)databaseObject).getCatalogName());
                    string = StringUtil.trimToNull(databaseObject.getSchema() == null ? null : databaseObject.getSchema().getName());
                }
                String string4 = StringUtil.trimToNull(map.get("TABLE_NAME").toString());
                string4 = this.cleanNameFromDatabase(string4, database);
                checkConstraint.setTable(new Table(string2, string, string4));
                if (checkConstraintSnapshotGenerator$SqlExt.isFetchedAcrossSchemas() && !string2.equals(databaseObject.getName()) || !this.isSystemConstraint(checkConstraint)) continue;
                ((Schema)databaseObject).addDatabaseObject(checkConstraint);
            }
            this.foundAllCheckConstraints = true;
        }
    }

    protected CheckConstraintSnapshotGenerator$SqlExt getAddToSqlForSchema(DatabaseObject databaseObject, DatabaseSnapshot object, Database database) {
        String string;
        boolean bl2 = false;
        if (database instanceof PostgresDatabase) {
            return new PostgresCheckConstraintSnapshotGenerator().getAddToSqlForSchema(databaseObject, (DatabaseSnapshot)object, database);
        }
        if (database instanceof OracleDatabase) {
            string = "SELECT OWNER, CONSTRAINT_NAME, TABLE_NAME, SEARCH_CONDITION, STATUS, VALIDATED FROM all_constraints  WHERE constraint_type = 'C' AND SEARCH_CONDITION IS NOT NULL ";
            if (database.getDatabaseMajorVersion() > 11) {
                string = string + "AND NOT(REGEXP_LIKE(SEARCH_CONDITION_VC, '^\"\\w+\" IS NOT NULL$')) ";
            }
            if ((object = (String)((DatabaseSnapshot)object).getScratchData("DatabaseSnapshot.allCatalogsString")) == null) {
                string = string + " and owner='" + ((Schema)databaseObject).getCatalogName() + "'";
            } else {
                string = string + " and owner IN ('" + ((Schema)databaseObject).getCatalogName() + "', " + (String)object + ")";
                bl2 = true;
            }
        } else if (database instanceof DB2Database) {
            string = "SELECT CHECKS.CONSTNAME AS CONSTRAINT_NAME, CHECKS.TEXT AS SEARCH_CONDITION, TABCONST.ENFORCED AS ENFORCED, CHECKS.TABNAME AS TABLE_NAME FROM SYSCAT.CHECKS CHECKS INNER JOIN SYSCAT.TABCONST TABCONST ON TABCONST.CONSTNAME=CHECKS.CONSTNAME AND TABCONST.TABSCHEMA=CHECKS.TABSCHEMA AND TABCONST.TABNAME=CHECKS.TABNAME AND CHECKS.TYPE != 'S' WHERE CHECKS.TABSCHEMA='" + ((Schema)databaseObject).getCatalogName() + "'AND CHECKS.CONSTNAME != 'RCT' AND CHECKS.CONSTNAME != 'RCT_OFLOW'";
        } else if (database instanceof Db2zDatabase) {
            string = "SELECT CHECKNAME AS CONSTRAINT_NAME, CHECKCONDITION AS SEARCH_CONDITION, 'Y' AS ENFORCED, TBNAME AS TABLE_NAME FROM SYSIBM.SYSCHECKS WHERE TBOWNER='" + ((Schema)databaseObject).getCatalogName() + "'";
        } else if (database instanceof MySQLDatabase) {
            string = "select tc.TABLE_SCHEMA, tc.TABLE_NAME, tc.CONSTRAINT_NAME, cc.CHECK_CLAUSE AS SEARCH_CONDITION from INFORMATION_SCHEMA.TABLE_CONSTRAINTS tc inner join INFORMATION_SCHEMA.CHECK_CONSTRAINTS cc ON tc.CONSTRAINT_NAME = cc.CONSTRAINT_NAME where CONSTRAINT_TYPE = 'CHECK' and TABLE_SCHEMA = '" + ((Schema)databaseObject).getName() + "'";
        } else if (database instanceof MSSQLDatabase) {
            object = databaseObject.getName() == null ? "dbo" : databaseObject.getName().toLowerCase();
            string = "SELECT  sys.objects.name AS CONSTRAINT_NAME, parent.name as TABLE_NAME, syscomments.text AS SEARCH_CONDITION, IS_DISABLED as IS_DISABLED FROM sys.objects INNER JOIN sys.schemas ON sys.objects.schema_id = sys.schemas.schema_id and lower(sys.schemas.name)='" + (String)object + "' INNER JOIN syscomments ON syscomments.id = sys.objects.object_id INNER JOIN sys.objects parent on objects.parent_object_id=parent.object_id and parent.type_desc='USER_TABLE' INNER JOIN sys.check_constraints ON check_constraints.object_id = sys.objects.object_id where objects.type_desc='CHECK_CONSTRAINT'";
        } else {
            throw new UnexpectedLiquibaseException("Unsupported database for check constraint snapshot" + database.getShortName());
        }
        return new CheckConstraintSnapshotGenerator$SqlExt(this, string, bl2);
    }

    protected String getAddToSql(Database object, Table table) {
        if (object instanceof PostgresDatabase) {
            return new PostgresCheckConstraintSnapshotGenerator().getAddToSql((Database)object, table);
        }
        if (object instanceof OracleDatabase) {
            object = "SELECT OWNER, CONSTRAINT_NAME, TABLE_NAME, SEARCH_CONDITION, STATUS, VALIDATED FROM all_constraints  WHERE constraint_type = 'C' and table_name='" + table.getName() + "'";
            if (table.getSchema() != null) {
                object = (String)object + " and owner='" + table.getSchema().getCatalogName() + "'";
            }
        } else if (object instanceof DB2Database) {
            object = "SELECT CONSTNAME AS CONSTRAINT_NAME FROM SYSCAT.CHECKS WHERE TABSCHEMA='" + table.getSchema().getCatalogName() + "' AND TYPE != 'S' AND TABNAME='" + table.getName() + "'";
        } else if (object instanceof Db2zDatabase) {
            object = "SELECT CHECKNAME AS CONSTRAINT_NAME FROM SYSIBM.SYSCHECKS WHERE TBOWNER='" + table.getSchema().getCatalogName() + "' AND TBNAME='" + table.getName() + "'";
        } else if (object instanceof MySQLDatabase) {
            object = "select CONSTRAINT_NAME from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where CONSTRAINT_TYPE = 'CHECK' and TABLE_SCHEMA = '" + table.getSchema().getName() + "'and TABLE_NAME = '" + table.getName() + "'";
        } else if (object instanceof MSSQLDatabase) {
            Schema schema = table.getSchema();
            object = "SELECT  sys.objects.name AS CONSTRAINT_NAME FROM sys.objects INNER JOIN sys.schemas ON sys.objects.schema_id = sys.schemas.schema_id and sys.schemas.name='" + ((MSSQLDatabase)object).getJdbcSchemaName(schema.toCatalogAndSchema()) + "' INNER JOIN sys.objects parent on objects.parent_object_id=parent.object_id and parent.name='" + table.getName() + "' and parent.type_desc='USER_TABLE' where objects.type_desc='CHECK_CONSTRAINT'";
        } else {
            throw new UnexpectedLiquibaseException("Unsupported database for check constraint snapshot: " + object.getShortName());
        }
        return object;
    }

    private void sortCheckConstraints(List<CheckConstraint> list) {
        list.sort(new CheckConstraintSnapshotGenerator$1(this));
    }

    private boolean isSystemConstraint(CheckConstraint object) {
        if ((object = ((CheckConstraint)object).getBody()) == null) {
            return true;
        }
        return !((String)object).matches("\"?\\w+\" IS NOT NULL");
    }
}

