/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.spring;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import com.xebialabs.deployit.core.rest.websockets.RemoteChangeSetEventListener$;
import com.xebialabs.deployit.engine.api.distribution.TaskExecutionWorkerRepository;
import com.xebialabs.deployit.engine.spi.services.RepositoryFactory;
import com.xebialabs.deployit.engine.tasker.Archive;
import com.xebialabs.deployit.engine.tasker.TaskExecutionEngine;
import com.xebialabs.deployit.engine.tasker.TaskExecutionWorker$;
import com.xebialabs.deployit.engine.tasker.TaskFinalizer;
import com.xebialabs.deployit.engine.tasker.TaskFinalizerImpl;
import com.xebialabs.deployit.engine.tasker.TaskQueueService;
import com.xebialabs.deployit.engine.tasker.TaskerException;
import com.xebialabs.deployit.engine.tasker.distribution.versioning.ConfigurationHashProvider;
import com.xebialabs.deployit.engine.tasker.log.StepLogFactory;
import com.xebialabs.deployit.engine.tasker.log.StepLogRetriever;
import com.xebialabs.deployit.engine.tasker.query.QueryActor$;
import com.xebialabs.deployit.engine.tasker.repository.ActiveTaskRepository;
import com.xebialabs.deployit.engine.tasker.repository.CrudTaskRepository;
import com.xebialabs.deployit.engine.tasker.repository.PendingTaskRepository;
import com.xebialabs.deployit.service.discovery.DiscoveryService;
import com.xebialabs.deployit.service.discovery.DiscoveryWorker$;
import com.xebialabs.deployit.spring.BeanWrapper;
import com.xebialabs.deployit.spring.BeanWrapper$;
import com.xebialabs.deployit.spring.EngineBeanBuilder$;
import com.xebialabs.xlplatform.settings.shared.TaskerSettings;
import java.io.Serializable;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.jms.config.JmsListenerContainerFactory;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import scala.Function0;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Configuration
@Lazy
@DependsOn(value={"repositoryServiceHolder", "placeholderRepositoryHolder", "artifactResolver", "commandWhitelistValidator"})
@ScalaSignature(bytes="\u0006\u0005\t]e\u0001B\u000f\u001f\u0001\u001dB\u0001B\f\u0001\u0003\u0006\u0004%\ta\f\u0005\tq\u0001\u0011\t\u0011)A\u0005a!A\u0011\b\u0001BC\u0002\u0013\u0005!\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003<\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u001dQ\u0006A1A\u0005\nmCaA\u0019\u0001!\u0002\u0013a\u0006\"B2\u0001\t\u0003\"\u0007\"C=\u0001\u0001\u0004\u0005\r\u0011\"\u0001{\u0011%q\b\u00011AA\u0002\u0013\u0005q\u0010\u0003\u0006\u0002\f\u0001\u0001\r\u0011!Q!\nmD\u0011\"a\u0007\u0001\u0005\u0004%\t!!\b\t\u0011\u0005U\u0002\u0001)A\u0005\u0003?A\u0011\"a\u000e\u0001\u0005\u0004%\t!!\u000f\t\u0011\u0005\r\u0003\u0001)A\u0005\u0003wA\u0011\"!\u0012\u0001\u0005\u0004%\t!a\u0012\t\u0011\u0005m\u0003\u0001)A\u0005\u0003\u0013Bq!!\u0018\u0001\t\u0003\ty\u0006\u0003\u00046\u0001\u0011\u0005\u0011\u0011\u000f\u0005\b\u0003\u0007\u0003A\u0011AAC\u0011\u001d\tI\t\u0001C\u0001\u0003\u0017Cq!!0\u0001\t\u0003\ty\fC\u0004\u0003>\u0001!\tAa\u0010\t\u000f\t\r\u0003\u0001\"\u0003\u0003F\u001d9!q\u000e\u0010\t\u0002\tEdAB\u000f\u001f\u0011\u0003\u0011\u0019\b\u0003\u0004E5\u0011\u0005!Q\u000f\u0005\b\u0005oRB\u0011\u0001B=\u0005E)enZ5oK\n+\u0017M\u001c\"vS2$WM\u001d\u0006\u0003?\u0001\naa\u001d9sS:<'BA\u0011#\u0003!!W\r\u001d7ps&$(BA\u0012%\u0003%AXMY5bY\u0006\u00147OC\u0001&\u0003\r\u0019w.\\\u0002\u0001'\t\u0001\u0001\u0006\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#F\u0001\u0004B]f\u0014VMZ\u0001\bCJ\u001c\u0007.\u001b<f+\u0005\u0001\u0004CA\u00197\u001b\u0005\u0011$BA\u001a5\u0003\u0019!\u0018m]6fe*\u0011Q\u0007I\u0001\u0007K:<\u0017N\\3\n\u0005]\u0012$aB!sG\"Lg/Z\u0001\tCJ\u001c\u0007.\u001b<fA\u0005\t\"/\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:\u0016\u0003m\u0002\"\u0001P!\u000e\u0003uR!AP \u0002\u0011M,'O^5dKNT!\u0001\u0011\u001b\u0002\u0007M\u0004\u0018.\u0003\u0002C{\t\t\"+\u001a9pg&$xN]=GC\u000e$xN]=\u0002%I,\u0007o\\:ji>\u0014\u00180\u00113baR,'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u0019C\u0005\f\u0005\u0002H\u00015\ta\u0004C\u0003/\u000b\u0001\u0007\u0001\u0007\u000b\u0002I\u0015B\u00111JV\u0007\u0002\u0019*\u0011QJT\u0001\u000bC:tw\u000e^1uS>t'BA(Q\u0003\u001d1\u0017m\u0019;pefT!!\u0015*\u0002\u000b\t,\u0017M\\:\u000b\u0005M#\u0016aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003U\u000b1a\u001c:h\u0013\t9FJA\u0005BkR|w/\u001b:fI\")\u0011(\u0002a\u0001w!\u0012\u0001LS\u0001\u0007Y><w-\u001a:\u0016\u0003q\u0003\"!\u00181\u000e\u0003yS!a\u0018+\u0002\u000bMdg\r\u000e6\n\u0005\u0005t&A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!\u001a\t\u0003MZt!a\u001a;\u000f\u0005!\u001chBA5s\u001d\tQ\u0017O\u0004\u0002la:\u0011An\\\u0007\u0002[*\u0011aNJ\u0001\u0007yI|w\u000e\u001e \n\u0003\u0015J!a\t\u0013\n\u0005\u0005\u0012\u0013BA\u001b!\u0013\t\u0019D'\u0003\u0002ve\u00059\u0001/Y2lC\u001e,\u0017BA<y\u0005\u0019!\u0016m]6JI*\u0011QOM\u0001\u0014S:\u0004&o\\2fgN$\u0016m]6F]\u001eLg.Z\u000b\u0002wB\u0011\u0011\u0006`\u0005\u0003{*\u0012qAQ8pY\u0016\fg.A\fj]B\u0013xnY3tgR\u000b7o[#oO&tWm\u0018\u0013fcR!\u0011\u0011AA\u0004!\rI\u00131A\u0005\u0004\u0003\u000bQ#\u0001B+oSRD\u0001\"!\u0003\u000b\u0003\u0003\u0005\ra_\u0001\u0004q\u0012\n\u0014\u0001F5o!J|7-Z:t)\u0006\u001c8.\u00128hS:,\u0007\u0005K\u0004\f\u0003\u001f\t)\"a\u0006\u0011\u0007-\u000b\t\"C\u0002\u0002\u00141\u0013QAV1mk\u0016\fQA^1mk\u0016\f#!!\u0007\u0002K\u0011ZH-\u001a9m_ftC/Y:l]%tW\u0006\u001d:pG\u0016\u001c8/L<pe.,'O\u000f;sk\u0016l\u0018\u0001F<sCB\u0004X\rZ,pe.,'/T1oC\u001e,'/\u0006\u0002\u0002 A)q)!\t\u0002&%\u0019\u00111\u0005\u0010\u0003\u0017\t+\u0017M\\,sCB\u0004XM\u001d\t\u0005\u0003O\t\t$\u0004\u0002\u0002*)!\u00111FA\u0017\u0003\u0015\t7\r^8s\u0015\t\ty#\u0001\u0003bW.\f\u0017\u0002BA\u001a\u0003S\u0011\u0001\"Q2u_J\u0014VMZ\u0001\u0016oJ\f\u0007\u000f]3e/>\u00148.\u001a:NC:\fw-\u001a:!\u000359(/\u00199qK\u0012,enZ5oKV\u0011\u00111\b\t\u0006\u000f\u0006\u0005\u0012Q\b\t\u0004c\u0005}\u0012bAA!e\t\u0019B+Y:l\u000bb,7-\u001e;j_:,enZ5oK\u0006qqO]1qa\u0016$WI\\4j]\u0016\u0004\u0013aF<sCB\u0004X\r\u001a#jg\u000e|g/\u001a:z'\u0016\u0014h/[2f+\t\tI\u0005E\u0003H\u0003C\tY\u0005\u0005\u0003\u0002N\u0005]SBAA(\u0015\u0011\t\t&a\u0015\u0002\u0013\u0011L7oY8wKJL(bAA+A\u000591/\u001a:wS\u000e,\u0017\u0002BA-\u0003\u001f\u0012\u0001\u0003R5tG>4XM]=TKJ4\u0018nY3\u00021]\u0014\u0018\r\u001d9fI\u0012K7oY8wKJL8+\u001a:wS\u000e,\u0007%A\u0007x_J\\WM]'b]\u0006<WM\u001d\u000b\u0003\u0003?A3AEA2!\u0011\t)'!\u001c\u000e\u0005\u0005\u001d$bA'\u0002j)\u0019\u00111\u000e*\u0002\u000f\r|g\u000e^3yi&!\u0011qNA4\u0005\u0011\u0011U-\u00198\u0015\u0005\u0005m\u0002fB\n\u0002v\u0005U\u00111\u0010\t\u0005\u0003K\n9(\u0003\u0003\u0002z\u0005\u001d$!\u0003#fa\u0016tGm](oY\t\ti(\t\u0002\u0002\u0000\u0005AQ\u000f]4sC\u0012,'\u000fK\u0002\u0014\u0003G\n\u0001\u0003Z5tG>4XM]=TKJ4\u0018nY3\u0015\u0005\u0005%\u0003f\u0001\u000b\u0002d\u0005\t\u0012N\\5u/>\u00148.\u001a:NC:\fw-\u001a:\u0015\u0011\u0005\u0005\u0011QRAL\u0003WCq!a$\u0016\u0001\u0004\t\t*\u0001\u0004tsN$X-\u001c\t\u0005\u0003O\t\u0019*\u0003\u0003\u0002\u0016\u0006%\"aC!di>\u00148+_:uK6Dq!!'\u0016\u0001\u0004\tY*A\u000fuCN\\W\t_3dkRLwN\\,pe.,'OU3q_NLGo\u001c:z!\u0011\ti*a*\u000e\u0005\u0005}%\u0002BAQ\u0003G\u000bA\u0002Z5tiJL'-\u001e;j_:T1!!*5\u0003\r\t\u0007/[\u0005\u0005\u0003S\u000byJA\u000fUCN\\W\t_3dkRLwN\\,pe.,'OU3q_NLGo\u001c:z\u0011\u001d\ti+\u0006a\u0001\u0003_\u000b\u0011dY8oM&<WO]1uS>t\u0007*Y:i!J|g/\u001b3feB!\u0011\u0011WA]\u001b\t\t\u0019L\u0003\u0003\u00026\u0006]\u0016A\u0003<feNLwN\\5oO*\u0019\u0011\u0011\u0015\u001a\n\t\u0005m\u00161\u0017\u0002\u001a\u0007>tg-[4ve\u0006$\u0018n\u001c8ICND\u0007K]8wS\u0012,'/\u0001\u0006j]&$XI\\4j]\u0016$b#!\u0001\u0002B\u0006\r\u00171[Ao\u0003{\fyPa\u0004\u0003\u001a\tm!1\u0007\u0005\b\u0003\u001f3\u00029AAI\u0011\u001d\t)M\u0006a\u0002\u0003\u000f\fA#Y2uSZ,G+Y:l%\u0016\u0004xn]5u_JL\b\u0003BAe\u0003\u001fl!!a3\u000b\u0007\u00055''\u0001\u0006sKB|7/\u001b;pefLA!!5\u0002L\n!\u0012i\u0019;jm\u0016$\u0016m]6SKB|7/\u001b;pefDq!!6\u0017\u0001\b\t9.A\u000bqK:$\u0017N\\4UCN\\'+\u001a9pg&$xN]=\u0011\t\u0005%\u0017\u0011\\\u0005\u0005\u00037\fYMA\u000bQK:$\u0017N\\4UCN\\'+\u001a9pg&$xN]=\t\u000f\u0005}g\u0003q\u0001\u0002b\u0006\u00012m\u001c8uC&tWM\u001d$bGR|'/\u001f\t\u0007\u0003G\fi/!=\u000e\u0005\u0005\u0015(\u0002BAt\u0003S\faaY8oM&<'bAAv%\u0006\u0019!.\\:\n\t\u0005=\u0018Q\u001d\u0002\u001c\u00156\u001cH*[:uK:,'oQ8oi\u0006Lg.\u001a:GC\u000e$xN]=\u0011\t\u0005M\u0018\u0011`\u0007\u0003\u0003kTA!a>\u0002j\u0006AA.[:uK:,'/\u0003\u0003\u0002|\u0006U(a\b#fM\u0006,H\u000e^'fgN\fw-\u001a'jgR,g.\u001a:D_:$\u0018-\u001b8fe\"9\u0011\u0011\u0014\fA\u0004\u0005m\u0005b\u0002B\u0001-\u0001\u000f!1A\u0001\u000fgR,\u0007\u000fT8h\r\u0006\u001cGo\u001c:z!\u0011\u0011)Aa\u0003\u000e\u0005\t\u001d!b\u0001B\u0005e\u0005\u0019An\\4\n\t\t5!q\u0001\u0002\u000f'R,\u0007\u000fT8h\r\u0006\u001cGo\u001c:z\u0011\u001d\u0011\tB\u0006a\u0002\u0005'\t\u0001c\u001d;fa2{wMU3ue&,g/\u001a:\u0011\t\t\u0015!QC\u0005\u0005\u0005/\u00119A\u0001\tTi\u0016\u0004Hj\\4SKR\u0014\u0018.\u001a<fe\"9\u0011Q\u0016\fA\u0004\u0005=\u0006b\u0002B\u000f-\u0001\u000f!qD\u0001\u000fi\u0006\u001c8.\u001a:TKR$\u0018N\\4t!\u0011\u0011\tCa\f\u000e\u0005\t\r\"\u0002\u0002B\u0013\u0005O\taa\u001d5be\u0016$'\u0002\u0002B\u0015\u0005W\t\u0001b]3ui&twm\u001d\u0006\u0004\u0005[\u0011\u0013A\u0003=ma2\fGOZ8s[&!!\u0011\u0007B\u0012\u00059!\u0016m]6feN+G\u000f^5oONDqA!\u000e\u0017\u0001\b\u00119$\u0001\tuCN\\\u0017+^3vKN+'O^5dKB\u0019\u0011G!\u000f\n\u0007\tm\"G\u0001\tUCN\\\u0017+^3vKN+'O^5dK\u0006!\u0012N\\5u\t&\u001c8m\u001c<fef\u001cVM\u001d<jG\u0016$B!!\u0001\u0003B!9\u0011qR\fA\u0002\u0005E\u0015a\u0004:fg\u000eDW\rZ;mKR\u000b7o[:\u0015\r\u0005\u0005!q\tB%\u0011\u001d\t)\u000e\u0007a\u0001\u0003/Da!\u000e\rA\u0002\u0005u\u0002f\u0002\u0001\u0002v\u0005U!Q\n\u0017\t\u0005\u001f\u0012\u0019Fa\u0016\u0003\\\u0005\u0012!\u0011K\u0001\u0018e\u0016\u0004xn]5u_JL8+\u001a:wS\u000e,\u0007j\u001c7eKJ\f#A!\u0016\u00027Ad\u0017mY3i_2$WM\u001d*fa>\u001c\u0018\u000e^8ss\"{G\u000eZ3sC\t\u0011I&\u0001\tbeRLg-Y2u%\u0016\u001cx\u000e\u001c<fe\u0006\u0012!QL\u0001\u001aG>lW.\u00198e/\"LG/\u001a7jgR4\u0016\r\\5eCR|'\u000fK\u0002\u0001\u0005C\u0002B!!\u001a\u0003d%!!QMA4\u0005\u0011a\u0015M_=)\u0007\u0001\u0011I\u0007\u0005\u0003\u0002f\t-\u0014\u0002\u0002B7\u0003O\u0012QbQ8oM&<WO]1uS>t\u0017!E#oO&tWMQ3b]\n+\u0018\u000e\u001c3feB\u0011qIG\n\u00035!\"\"A!\u001d\u0002'\r\u0014X-\u0019;f/>\u00148.\u001a:NC:\fw-\u001a:\u0015\u0015\u0005\u0015\"1\u0010B?\u0005\u007f\u0012\u0019\nC\u0004\u0002\u0010r\u0001\r!!%\t\u000f\u0005eE\u00041\u0001\u0002\u001c\"9!\u0011\u0011\u000fA\u0002\t\r\u0015!E2p]\u001aLw-\u001e:bi&|g\u000eS1tQB!!Q\u0011BG\u001d\u0011\u00119I!#\u0011\u00051T\u0013b\u0001BFU\u00051\u0001K]3eK\u001aLAAa$\u0003\u0012\n11\u000b\u001e:j]\u001eT1Aa#+\u0011\u0019\u0011)\n\ba\u0001w\u0006q1\u000f[8vY\u0012tu\u000e^\"ik:\\\u0007")
public class EngineBeanBuilder {
    private final Archive archive;
    private final RepositoryFactory repositoryAdapter;
    private final Logger logger;
    @Value(value="${deploy.task.in-process-worker:true}")
    private boolean inProcessTaskEngine;
    private final BeanWrapper<ActorRef> wrappedWorkerManager;
    private final BeanWrapper<TaskExecutionEngine> wrappedEngine;
    private final BeanWrapper<DiscoveryService> wrappedDiscoveryService;

    public static ActorRef createWorkerManager(ActorSystem actorSystem, TaskExecutionWorkerRepository taskExecutionWorkerRepository, String string, boolean bl) {
        return EngineBeanBuilder$.MODULE$.createWorkerManager(actorSystem, taskExecutionWorkerRepository, string, bl);
    }

    public Archive archive() {
        return this.archive;
    }

    public RepositoryFactory repositoryAdapter() {
        return this.repositoryAdapter;
    }

    private Logger logger() {
        return this.logger;
    }

    public String toString() {
        return super.toString();
    }

    public boolean inProcessTaskEngine() {
        return this.inProcessTaskEngine;
    }

    public void inProcessTaskEngine_$eq(boolean x$1) {
        this.inProcessTaskEngine = x$1;
    }

    public BeanWrapper<ActorRef> wrappedWorkerManager() {
        return this.wrappedWorkerManager;
    }

    public BeanWrapper<TaskExecutionEngine> wrappedEngine() {
        return this.wrappedEngine;
    }

    public BeanWrapper<DiscoveryService> wrappedDiscoveryService() {
        return this.wrappedDiscoveryService;
    }

    @Bean
    public BeanWrapper<ActorRef> workerManager() {
        return this.wrappedWorkerManager();
    }

    @Bean
    @DependsOn(value={"upgrader"})
    public BeanWrapper<TaskExecutionEngine> engine() {
        return this.wrappedEngine();
    }

    @Bean
    public BeanWrapper<DiscoveryService> discoveryService() {
        return this.wrappedDiscoveryService();
    }

    public void initWorkerManager(ActorSystem system, TaskExecutionWorkerRepository taskExecutionWorkerRepository, ConfigurationHashProvider configurationHashProvider) {
        ActorRef workerManger = EngineBeanBuilder$.MODULE$.createWorkerManager(system, taskExecutionWorkerRepository, configurationHashProvider.configurationHash(), this.inProcessTaskEngine());
        this.wrappedWorkerManager().set((Object)workerManger);
    }

    public void initEngine(ActorSystem system, ActiveTaskRepository activeTaskRepository, PendingTaskRepository pendingTaskRepository, JmsListenerContainerFactory<DefaultMessageListenerContainer> containerFactory, TaskExecutionWorkerRepository taskExecutionWorkerRepository, StepLogFactory stepLogFactory, StepLogRetriever stepLogRetriever, ConfigurationHashProvider configurationHashProvider, TaskerSettings taskerSettings, TaskQueueService taskQueueService) {
        ActorRef actorRef;
        TaskFinalizerImpl taskFinalizer = new TaskFinalizerImpl(system, (CrudTaskRepository)activeTaskRepository, pendingTaskRepository, taskerSettings.askTimeout());
        TaskExecutionEngine engine = new TaskExecutionEngine(activeTaskRepository, pendingTaskRepository, taskExecutionWorkerRepository, taskQueueService, system, (ActorRef)this.workerManager().get(), (TaskFinalizer)taskFinalizer);
        if (this.inProcessTaskEngine()) {
            this.logger().info("An in-process task execution worker will be registered.");
            TaskExecutionWorker$.MODULE$.local(this.repositoryAdapter(), this.archive(), configurationHashProvider, activeTaskRepository, pendingTaskRepository, taskExecutionWorkerRepository, containerFactory, taskerSettings, stepLogFactory, stepLogRetriever, system).recoverTasks();
            DiscoveryWorker$.MODULE$.initialize(system);
            actorRef = BoxedUnit.UNIT;
        } else {
            this.logger().debug("Registering for remote change set events.");
            actorRef = system.actorOf(RemoteChangeSetEventListener$.MODULE$.props(), RemoteChangeSetEventListener$.MODULE$.name());
        }
        system.actorOf(QueryActor$.MODULE$.props(), QueryActor$.MODULE$.name());
        this.rescheduleTasks(pendingTaskRepository, engine);
        this.wrappedEngine().set((Object)engine);
    }

    public void initDiscoveryService(ActorSystem system) {
        this.wrappedDiscoveryService().set((Object)new DiscoveryService(system, (ActorRef)this.workerManager().get(), this.inProcessTaskEngine()));
    }

    private void rescheduleTasks(PendingTaskRepository pendingTaskRepository, TaskExecutionEngine engine) {
        pendingTaskRepository.scheduledTasks().forEach(task -> {
            Throwable ex;
            DateTime scheduledDate = task.getScheduledDate();
            String date = scheduledDate.toDateTimeISO().toString("yyyy-MM-dd'T'HH:mm:ss");
            if (scheduledDate.isBeforeNow()) {
                this.logger().info(new StringBuilder(67).append("Scheduled task [").append(task.getId()).append("] with date [").append(date).append("] has already passed so executing now.").toString());
                engine.execute(task.getId());
                return;
            }
            boolean bl = false;
            Failure failure = null;
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> engine.schedule(task.getId(), scheduledDate));
            if (try_ instanceof Failure) {
                bl = true;
                failure = (Failure)try_;
                Throwable ex2 = failure.exception();
                if (ex2 instanceof TaskerException) {
                    TaskerException taskerException = (TaskerException)ex2;
                    this.logger().warn(new StringBuilder(73).append("Scheduled task [").append(task.getId()).append("] with start date [").append(date).append("] cannot be rescheduled automatically.").toString());
                    this.logger().warn(taskerException.getMessage());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
            if (bl && (ex = failure.exception()) instanceof Exception) {
                Exception exception = (Exception)ex;
                this.logger().warn(new StringBuilder(100).append("Scheduled task [").append(task.getId()).append("] with start date [").append(date).append("] cannot be rescheduled automatically. Unexpected error occurred.").toString());
                throw exception;
            }
            if (!(try_ instanceof Success)) throw new MatchError((Object)try_);
            this.logger().info(new StringBuilder(52).append("Scheduled task [").append(task.getId()).append("] with start date [").append(date).append("] was rescheduled").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
    }

    public EngineBeanBuilder(@Autowired Archive archive, @Autowired RepositoryFactory repositoryAdapter) {
        this.archive = archive;
        this.repositoryAdapter = repositoryAdapter;
        this.logger = LoggerFactory.getLogger(EngineBeanBuilder.class);
        this.wrappedWorkerManager = BeanWrapper$.MODULE$.apply();
        this.wrappedEngine = BeanWrapper$.MODULE$.apply();
        this.wrappedDiscoveryService = BeanWrapper$.MODULE$.apply();
    }
}

