/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.open.gui.utils;

import com.jeta.open.gui.framework.JETADialog;
import com.jeta.open.gui.framework.JETAPanel;
import com.jeta.open.registry.JETARegistry;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.lang.reflect.Constructor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class JETAToolbox {
    private static final String AVG_STR = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String APPLICATION_FRAME = "application.frame.window";
    public static final String WINDOWS_LF = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void addItems(JComboBox jComboBox, Object[] objectArray) {
        if (!$assertionsDisabled && jComboBox == null) {
            throw new AssertionError();
        }
        if (objectArray == null || jComboBox == null) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            jComboBox.addItem(objectArray[i]);
        }
    }

    private static Component[] toComponentArray(JComponent[] jComponentArray) {
        Component[] componentArray = new Component[jComponentArray.length];
        for (int i = 0; i < jComponentArray.length; ++i) {
            componentArray[i] = jComponentArray[i];
        }
        return componentArray;
    }

    public static int calculateAverageTextWidth(Component component, int n) {
        if (component == null) {
            return 0;
        }
        Font font = component.getFont();
        FontMetrics fontMetrics = component.getFontMetrics(font);
        return fontMetrics.stringWidth(AVG_STR) * n / AVG_STR.length();
    }

    public static void calculateReasonableComponentSize(Dimension dimension) {
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        if (dimension.width > dimension2.width) {
            dimension.width = dimension2.width * 8 / 10;
        }
        if (dimension.height > dimension2.height) {
            dimension.height = dimension2.height * 8 / 10;
        }
    }

    public static void centerFrame(Window window, float f, float f2) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (int)((float)dimension.width * f);
        int n2 = (int)((float)dimension.height * f2);
        int n3 = (dimension.width - n) / 2;
        int n4 = (dimension.height - n2) / 2;
        window.setBounds(n3, n4, n, n2);
    }

    public static void centerWindow(Window window) {
        float f = window.getWidth();
        float f2 = window.getHeight();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        float f3 = f / (float)dimension.getWidth();
        float f4 = f2 / (float)dimension.getHeight();
        JETAToolbox.centerFrame(window, f3, f4);
    }

    public static void centerWindowChangeWidth(Window window, float f) {
        float f2 = window.getHeight();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        float f3 = f2 / (float)dimension.getHeight();
        JETAToolbox.centerFrame(window, f, f3);
    }

    public static void copyToClipboard(String string) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Clipboard clipboard = toolkit.getSystemClipboard();
        StringSelection stringSelection = new StringSelection(string);
        clipboard.setContents(stringSelection, stringSelection);
    }

    public static Dialog createDialog(Class clazz, Component component, boolean bl) {
        Object object;
        Class[] classArray = new Class[2];
        Object[] objectArray = new Object[2];
        if (component == null && (object = JETARegistry.lookup(APPLICATION_FRAME)) instanceof Component) {
            component = (Component)object;
        }
        if (component instanceof Dialog) {
            classArray[0] = Dialog.class;
            objectArray[0] = component;
        } else if (component instanceof Frame) {
            classArray[0] = Frame.class;
            objectArray[0] = component;
        } else if (component == null) {
            classArray[0] = Frame.class;
            objectArray[0] = null;
        } else {
            object = SwingUtilities.getWindowAncestor(component);
            if (object instanceof Dialog) {
                classArray[0] = Dialog.class;
                objectArray[0] = object;
            } else if (object instanceof Frame) {
                classArray[0] = Frame.class;
                objectArray[0] = object;
            } else {
                classArray[0] = Frame.class;
                objectArray[0] = null;
            }
        }
        classArray[1] = Boolean.TYPE;
        objectArray[1] = bl;
        try {
            object = clazz.getConstructor(classArray);
            return (Dialog)((Constructor)object).newInstance(objectArray);
        }
        catch (Exception exception) {
            System.out.println("Unable to construct dialg   parent class: " + classArray[0] + "  owner = " + component);
            exception.printStackTrace();
            return null;
        }
    }

    public static int getFrameBorderThickness() {
        if (JETAToolbox.isOSX()) {
            return 0;
        }
        return 4;
    }

    public static int getTitleBarHeight() {
        return 20;
    }

    public static JETADialog invokeDialog(JETAPanel jETAPanel, Component component, String string) {
        JETADialog jETADialog = (JETADialog)JETAToolbox.createDialog(JETADialog.class, component, true);
        jETADialog.setPrimaryPanel(jETAPanel);
        jETADialog.setTitle(string);
        jETADialog.setSize(jETADialog.getPreferredSize());
        jETADialog.showCenter();
        return jETADialog;
    }

    public static JETADialog invokeDialog(JETAPanel jETAPanel, Component component, String string, JComponent jComponent) {
        JETADialog jETADialog = (JETADialog)JETAToolbox.createDialog(JETADialog.class, component, true);
        jETADialog.setPrimaryPanel(jETAPanel);
        jETADialog.setTitle(string);
        jETADialog.setSize(jETADialog.getPreferredSize());
        jETADialog.setInitialFocusComponent(jComponent);
        jETADialog.showCenter();
        return jETADialog;
    }

    public static boolean isAquaLookAndFeel() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        return lookAndFeel.getName().startsWith("Mac OS X");
    }

    public static boolean isOSX() {
        try {
            return System.getProperty("mrj.version") != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isWindows() {
        try {
            String string = System.getProperty("os.name");
            if (string != null && (string = string.toLowerCase()).indexOf("windows") >= 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isWindowsLookAndFeel() {
        return WINDOWS_LF.equals(UIManager.getLookAndFeel().getClass().getName());
    }

    public static void setReasonableWindowSize(Component component, Dimension dimension) {
        JETAToolbox.calculateReasonableComponentSize(dimension);
        component.setSize(dimension);
    }

    static {
        $assertionsDisabled = !JETAToolbox.class.desiredAssertionStatus();
    }
}

