/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.ActorSelection$;
import akka.actor.Address;
import akka.actor.CoordinatedShutdown;
import akka.actor.CoordinatedShutdown$;
import akka.actor.SupervisorStrategy;
import akka.annotation.InternalApi;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.cluster.ClusterLogMarker$;
import akka.cluster.ClusterUserAction;
import akka.cluster.ConfigValidation;
import akka.cluster.InternalClusterAction;
import akka.cluster.Invalid;
import akka.cluster.JoinConfigCompatChecker;
import akka.cluster.JoinConfigCompatChecker$;
import akka.cluster.Valid$;
import com.typesafe.config.Config;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005ubAB\u000b\u0017\u0003\u00031\"\u0004\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003*\u0011\u0015i\u0003\u0001\"\u0001/\u0011\u001d9\u0002A1A\u0005\u0002EBa!\u000e\u0001!\u0002\u0013\u0011\u0004b\u0002\u001c\u0001\u0005\u0004%\ta\u000e\u0005\u0007w\u0001\u0001\u000b\u0011\u0002\u001d\t\u000fq\u0002!\u0019!C\u0005{!1a\t\u0001Q\u0001\nyBqa\u0012\u0001C\u0002\u0013%Q\b\u0003\u0004I\u0001\u0001\u0006IA\u0010\u0005\b\u0013\u0002\u0011\r\u0011\"\u0003>\u0011\u0019Q\u0005\u0001)A\u0005}!)1\n\u0001C\u0005\u0019\")A\f\u0001C\u0003;\")1\u000e\u0001C\u0003Y\")Q\u000f\u0001C\u0003m\"9\u0011q\u0001\u0001\u0005\u0006\u0005%\u0001bBA\t\u0001\u0011%\u00111\u0003\u0005\b\u00033\u0001A\u0011BA\u000e\u0011\u001d\t9\u0003\u0001C\u0005\u0003S\u0011qbU3fI:{G-\u001a)s_\u000e,7o\u001d\u0006\u0003/a\tqa\u00197vgR,'OC\u0001\u001a\u0003\u0011\t7n[1\u0014\u0007\u0001Y\u0012\u0005\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SD\u0001\u0004B]f\u0014VM\u001a\t\u0003E\u0015j\u0011a\t\u0006\u0003Ia\tQ!Y2u_JL!AJ\u0012\u0003\u000b\u0005\u001bGo\u001c:\u0002/)|\u0017N\\\"p]\u001aLwmQ8na\u0006$8\t[3dW\u0016\u00148\u0001\u0001\t\u0003U-j\u0011AF\u0005\u0003YY\u0011qCS8j]\u000e{gNZ5h\u0007>l\u0007/\u0019;DQ\u0016\u001c7.\u001a:\u0002\rqJg.\u001b;?)\ty\u0003\u0007\u0005\u0002+\u0001!)qE\u0001a\u0001SU\t!\u0007\u0005\u0002+g%\u0011AG\u0006\u0002\b\u00072,8\u000f^3s\u0003!\u0019G.^:uKJ\u0004\u0013aC:fY\u001a\fE\r\u001a:fgN,\u0012\u0001\u000f\t\u0003EeJ!AO\u0012\u0003\u000f\u0005#GM]3tg\u0006a1/\u001a7g\u0003\u0012$'/Z:tA\u0005\u0011#j\\5o)>LenY8na\u0006$\u0018N\u00197f\u0007>tg-[4V]\u0016tgm\u001c:dK\u0012,\u0012A\u0010\t\u0003\u007f\u0011k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000bA\u0001\\1oO*\t1)\u0001\u0003kCZ\f\u0017BA#A\u0005\u0019\u0019FO]5oO\u0006\u0019#j\\5o)>LenY8na\u0006$\u0018N\u00197f\u0007>tg-[4V]\u0016tgm\u001c:dK\u0012\u0004\u0013a\u0007,bY&$\u0017\r^3e\u0013:\u001cw.\u001c9bi&\u0014G.Z\"p]\u001aLw-\u0001\u000fWC2LG-\u0019;fI&s7m\\7qCRL'\r\\3D_:4\u0017n\u001a\u0011\u0002'9{G-Z*ikR$wn\u001e8XCJt\u0017N\\4\u0002)9{G-Z*ikR$wn\u001e8XCJt\u0017N\\4!\u00031\u0019Ho\u001c9Pe\n+7m\\7f)\ti\u0005\u000b\u0005\u0002\u001d\u001d&\u0011q*\b\u0002\u0005+:LG\u000fC\u0003R\u001b\u0001\u0007!+\u0001\u0005cK\"\fg/[8s!\ra2+V\u0005\u0003)v\u0011aa\u00149uS>t\u0007C\u0001,Z\u001d\t\u0011s+\u0003\u0002YG\u0005)\u0011i\u0019;pe&\u0011!l\u0017\u0002\b%\u0016\u001cW-\u001b<f\u0015\tA6%A\nsK\u000e,\u0017N^3K_&t7+Z3e\u001d>$W\r\u0006\u0002N=\")qL\u0004a\u0001A\u0006I1/Z3e\u001d>$Wm\u001d\t\u0004C\"DdB\u00012g!\t\u0019W$D\u0001e\u0015\t)\u0007&\u0001\u0004=e>|GOP\u0005\u0003Ov\ta\u0001\u0015:fI\u00164\u0017BA5k\u0005\r\u0019V\r\u001e\u0006\u0003Ov\tAE]3dK&4X-\u00138ji*{\u0017N\\!dW&s7m\\7qCRL'\r\\3D_:4\u0017n\u001a\u000b\u0005\u001b6|G\u000fC\u0003o\u001f\u0001\u0007\u0001(\u0001\u0004k_&tGk\u001c\u0005\u0006a>\u0001\r!]\u0001\u0007_JLw-\u001b8\u0011\u0005\t\u0012\u0018BA:$\u0005!\t5\r^8s%\u00164\u0007\"B)\u0010\u0001\u0004\u0011\u0016A\t:fG\u0016Lg/Z%oSRTu.\u001b8BG.\u001cu.\u001c9bi&\u0014G.Z\"p]\u001aLw\r\u0006\u0004NobL\u0018Q\u0001\u0005\u0006]B\u0001\r\u0001\u000f\u0005\u0006aB\u0001\r!\u001d\u0005\u0006uB\u0001\ra_\u0001\fG>tg-[4DQ\u0016\u001c7\u000e\u0005\u0002}\u007f:\u0011!&`\u0005\u0003}Z\tQ#\u00138uKJt\u0017\r\\\"mkN$XM]!di&|g.\u0003\u0003\u0002\u0002\u0005\r!\u0001E\"p[B\fG/\u001b2mK\u000e{gNZ5h\u0015\tqh\u0003C\u0003R!\u0001\u0007!+A\u0011sK\u000e,\u0017N^3J]&$(j\\5o\u0003\u000e\\WK\\2iK\u000e\\W\rZ\"p]\u001aLw\rF\u0004N\u0003\u0017\ti!a\u0004\t\u000b9\f\u0002\u0019\u0001\u001d\t\u000bA\f\u0002\u0019A9\t\u000bE\u000b\u0002\u0019\u0001*\u0002-1|w-\u00138ji*{\u0017N\\!dWJ+7-Z5wK\u0012$2!TA\u000b\u0011\u0019\t9B\u0005a\u0001c\u0006!aM]8n\u0003)bwnZ,be:LgnZ%om\u0006d\u0017\u000eZ\"p]\u001aLw-\u00134CsB\f7o]\"p]\u001aLwm\u00115fG.$2!TA\u000f\u0011\u001d\tyb\u0005a\u0001\u0003C\tq!\u001b8wC2LG\rE\u0002+\u0003GI1!!\n\u0017\u0005\u001dIeN^1mS\u0012\fQ\u0003\\8h\u000bJ\u0014xN]%om\u0006d\u0017\u000eZ\"p]\u001aLw\rF\u0002N\u0003WAq!!\f\u0015\u0001\u0004\t\t#\u0001\u0006wC2LG-\u0019;j_:D3\u0001AA\u0019!\u0011\t\u0019$!\u000f\u000e\u0005\u0005U\"bAA\u001c1\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0012Q\u0007\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018\u000e")
@InternalApi
public abstract class SeedNodeProcess
implements Actor {
    private final JoinConfigCompatChecker joinConfigCompatChecker;
    private final Cluster cluster;
    private final Address selfAddress;
    private final String JoinToIncompatibleConfigUnenforced;
    private final String ValidatedIncompatibleConfig;
    private final String NodeShutdownWarning;
    private ActorContext context;
    private ActorRef self;

    public final ActorRef sender() {
        return Actor.sender$((Actor)this);
    }

    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$((Actor)this, receive2, (Object)msg);
    }

    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$((Actor)this);
    }

    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
    }

    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$((Actor)this);
    }

    public void preStart() throws Exception {
        Actor.preStart$((Actor)this);
    }

    public void postStop() throws Exception {
        Actor.postStop$((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$((Actor)this, (Throwable)reason, message);
    }

    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$((Actor)this, (Throwable)reason);
    }

    public void unhandled(Object message) {
        Actor.unhandled$((Actor)this, (Object)message);
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public Address selfAddress() {
        return this.selfAddress;
    }

    private String JoinToIncompatibleConfigUnenforced() {
        return this.JoinToIncompatibleConfigUnenforced;
    }

    private String ValidatedIncompatibleConfig() {
        return this.ValidatedIncompatibleConfig;
    }

    private String NodeShutdownWarning() {
        return this.NodeShutdownWarning;
    }

    private void stopOrBecome(Option<PartialFunction<Object, BoxedUnit>> behavior) {
        Option<PartialFunction<Object, BoxedUnit>> option = behavior;
        if (option instanceof Some) {
            Some some = (Some)option;
            PartialFunction done2 = (PartialFunction)some.value();
            this.context().become(done2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.context().stop(this.self());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public final void receiveJoinSeedNode(Set<Address> seedNodes) {
        Seq<String> requiredNonSensitiveKeys = JoinConfigCompatChecker$.MODULE$.removeSensitiveKeys(this.joinConfigCompatChecker.requiredKeys(), this.cluster().settings());
        Config configToValidate = JoinConfigCompatChecker$.MODULE$.filterWithKeys(requiredNonSensitiveKeys, this.context().system().settings().config());
        seedNodes.foreach((Function1 & Serializable)a -> {
            SeedNodeProcess.$anonfun$receiveJoinSeedNode$1(this, configToValidate, a);
            return BoxedUnit.UNIT;
        });
    }

    public final void receiveInitJoinAckIncompatibleConfig(Address joinTo, ActorRef origin, Option<PartialFunction<Object, BoxedUnit>> behavior) {
        if (this.cluster().settings().ByPassConfigCompatCheck()) {
            this.logInitJoinAckReceived(origin);
            this.cluster().ClusterLogger().logWarning("Joining cluster with incompatible configurations. {}", this.JoinToIncompatibleConfigUnenforced());
            this.context().parent().$bang((Object)new ClusterUserAction.JoinTo(joinTo), this.self());
            this.stopOrBecome(behavior);
        } else {
            this.cluster().ClusterLogger().logError(ClusterLogMarker$.MODULE$.joinFailed(), new StringBuilder(72).append("Couldn't join seed nodes because of incompatible cluster configuration. ").append(this.NodeShutdownWarning()).toString());
            this.context().stop(this.self());
            ((CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply(this.context().system())).run((CoordinatedShutdown.Reason)CoordinatedShutdown.IncompatibleConfigurationDetectedReason$.MODULE$);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void receiveInitJoinAckCompatibleConfig(Address joinTo, ActorRef origin, InternalClusterAction.CompatibleConfig configCheck, Option<PartialFunction<Object, BoxedUnit>> behavior) {
        this.logInitJoinAckReceived(origin);
        boolean bl = false;
        Invalid invalid = null;
        ConfigValidation configValidation = this.joinConfigCompatChecker.check(configCheck.clusterConfig(), this.context().system().settings().config());
        if (Valid$.MODULE$.equals(configValidation)) {
            this.context().parent().$bang((Object)new ClusterUserAction.JoinTo(joinTo), this.self());
            this.stopOrBecome(behavior);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (configValidation instanceof Invalid) {
            bl = true;
            invalid = (Invalid)configValidation;
            if (this.cluster().settings().ByPassConfigCompatCheck()) {
                this.logWarningInvalidConfigIfBypassConfigCheck(invalid);
                this.context().parent().$bang((Object)new ClusterUserAction.JoinTo(joinTo), this.self());
                this.stopOrBecome(behavior);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (!bl) throw new MatchError((Object)configValidation);
        this.logErrorInvalidConfig(invalid);
        this.context().stop(this.self());
        ((CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply(this.context().system())).run((CoordinatedShutdown.Reason)CoordinatedShutdown.IncompatibleConfigurationDetectedReason$.MODULE$);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public final void receiveInitJoinAckUncheckedConfig(Address joinTo, ActorRef origin, Option<PartialFunction<Object, BoxedUnit>> behavior) {
        this.logInitJoinAckReceived(origin);
        this.cluster().ClusterLogger().logWarning("Joining a cluster without configuration compatibility check feature.");
        this.context().parent().$bang((Object)new ClusterUserAction.JoinTo(joinTo), this.self());
        this.stopOrBecome(behavior);
    }

    private void logInitJoinAckReceived(ActorRef from) {
        this.cluster().ClusterLogger().logInfo("Received InitJoinAck message from [{}] to [{}]", from, (Object)this.selfAddress());
    }

    private void logWarningInvalidConfigIfBypassConfigCheck(Invalid invalid) {
        this.cluster().ClusterLogger().logWarning("{}: {}. {}.", (Object)this.ValidatedIncompatibleConfig(), (Object)invalid.errorMessages().mkString(", "), (Object)this.JoinToIncompatibleConfigUnenforced());
    }

    private void logErrorInvalidConfig(Invalid validation) {
        this.cluster().ClusterLogger().logError("{}: {}. {}", (Object)this.ValidatedIncompatibleConfig(), (Object)validation.errorMessages().mkString(", "), (Object)this.NodeShutdownWarning());
    }

    public static final /* synthetic */ void $anonfun$receiveJoinSeedNode$1(SeedNodeProcess $this, Config configToValidate$1, Address a) {
        ActorSelection$.MODULE$.toScala($this.context().actorSelection($this.context().parent().path().toStringWithAddress(a))).$bang((Object)new InternalClusterAction.InitJoin(configToValidate$1), $this.self());
    }

    public SeedNodeProcess(JoinConfigCompatChecker joinConfigCompatChecker) {
        this.joinConfigCompatChecker = joinConfigCompatChecker;
        Actor.$init$((Actor)this);
        this.cluster = (Cluster)Cluster$.MODULE$.apply(this.context().system());
        this.selfAddress = this.cluster().selfAddress();
        this.JoinToIncompatibleConfigUnenforced = "Join will be performed because compatibility check is configured to not be enforced.";
        this.ValidatedIncompatibleConfig = "Cluster validated this node config, but sent back incompatible settings";
        this.NodeShutdownWarning = "It's recommended to perform a full cluster shutdown in order to deploy this new version. If a cluster shutdown isn't an option, you may want to disable this protection by setting 'akka.cluster.configuration-compatibility-check.enforce-on-join = off'. Note that disabling it will allow the formation of a cluster with nodes having incompatible configuration settings. This node will be shutdown!";
        Statics.releaseFence();
    }
}

