/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.statetransfer;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Predicate;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.configuration.cache.XSiteStateTransferConfiguration;
import org.infinispan.remoting.transport.Address;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.statetransfer.XSiteState;
import org.infinispan.xsite.statetransfer.XSiteStateProvider;
import org.infinispan.xsite.statetransfer.XSiteStateProviderState;
import org.infinispan.xsite.statetransfer.XSiteStatePushTask;

public abstract class BaseXSiteStateProviderState<T extends OutboundTask>
implements XSiteStateProviderState {
    private final XSiteBackup backup;
    private final XSiteStateTransferConfiguration configuration;
    private final AtomicReference<T> task;

    public BaseXSiteStateProviderState(XSiteBackup backup, XSiteStateTransferConfiguration configuration) {
        this.backup = backup;
        this.configuration = configuration;
        this.task = new AtomicReference();
    }

    @Override
    public XSiteStatePushTask createPushTask(Address originator, XSiteStateProvider provider) {
        T newTask = this.createTask(originator, provider);
        return this.task.compareAndSet(null, newTask) ? newTask : null;
    }

    @Override
    public void cancelTransfer() {
        OutboundTask currentTask = this.task.getAndSet(null);
        if (currentTask != null) {
            currentTask.cancel();
        }
    }

    @Override
    public boolean isSending() {
        return this.task.get() != null;
    }

    @Override
    public boolean isOriginatorMissing(Collection<Address> members) {
        OutboundTask currentTask = (OutboundTask)this.task.get();
        return currentTask != null && !members.contains(currentTask.getCoordinator());
    }

    void taskFinished() {
        this.task.set(null);
    }

    XSiteBackup getBackup() {
        return this.backup;
    }

    int getChunkSize() {
        return this.configuration.chunkSize();
    }

    long getWaitTimeMillis() {
        return this.configuration.waitTime();
    }

    int getMaxRetries() {
        return this.configuration.maxRetries();
    }

    abstract T createTask(Address var1, XSiteStateProvider var2);

    static abstract class OutboundTask
    implements XSiteStatePushTask,
    Predicate<List<XSiteState>>,
    Function<List<XSiteState>, CompletableSource>,
    CompletableObserver {
        private final Address coordinator;
        final XSiteStateProvider provider;
        final BaseXSiteStateProviderState<?> state;
        private volatile boolean canceled = false;

        OutboundTask(Address coordinator, XSiteStateProvider provider, BaseXSiteStateProviderState<?> state) {
            this.coordinator = coordinator;
            this.provider = provider;
            this.state = state;
        }

        Address getCoordinator() {
            return this.coordinator;
        }

        @Override
        public void execute(Flowable<XSiteState> flowable, CompletionStage<Void> delayer) {
            delayer.thenRunAsync(() -> flowable.buffer(this.state.getChunkSize()).takeUntil((Predicate)this).concatMapCompletable((Function)this, 1).subscribe((CompletableObserver)this), this.provider.getExecutor());
        }

        public void cancel() {
            this.canceled = true;
        }

        public boolean test(List<XSiteState> ignored) {
            return this.canceled;
        }

        public void onSubscribe(@NonNull Disposable d) {
        }

        public void onComplete() {
            if (this.canceled) {
                return;
            }
            this.provider.notifyStateTransferEnd(this.state.getBackup().getSiteName(), this.coordinator, true);
            this.state.taskFinished();
        }

        public void onError(@NonNull Throwable e) {
            if (this.canceled) {
                return;
            }
            this.provider.notifyStateTransferEnd(this.state.getBackup().getSiteName(), this.coordinator, false);
            this.state.taskFinished();
        }
    }
}

