/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.model.jdbc;

import java.util.List;
import org.hibernate.engine.jdbc.mutation.ParameterUsage;
import org.hibernate.engine.jdbc.mutation.internal.JdbcValueDescriptorImpl;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.jdbc.Expectation;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.model.MutationTarget;
import org.hibernate.sql.model.TableMapping;
import org.hibernate.sql.model.jdbc.JdbcMutationOperation;
import org.hibernate.sql.model.jdbc.JdbcValueDescriptor;

public abstract class AbstractJdbcMutation
implements JdbcMutationOperation {
    private final TableMapping tableDetails;
    private final MutationTarget<?> mutationTarget;
    private final String sql;
    private final boolean callable;
    private final Expectation expectation;
    private final List<JdbcValueDescriptor> jdbcValueDescriptors;
    private final List<? extends JdbcParameterBinder> parameterBinders;

    public AbstractJdbcMutation(TableMapping tableDetails, MutationTarget<?> mutationTarget, String sql, boolean callable, Expectation expectation, List<? extends JdbcParameterBinder> parameterBinders) {
        this.tableDetails = tableDetails;
        this.mutationTarget = mutationTarget;
        this.sql = sql;
        this.callable = callable;
        this.expectation = expectation;
        this.parameterBinders = parameterBinders;
        this.jdbcValueDescriptors = CollectionHelper.arrayList(parameterBinders.size());
        for (int i = 0; i < parameterBinders.size(); ++i) {
            JdbcValueDescriptorImpl parameterDescriptor = new JdbcValueDescriptorImpl(parameterBinders.get(i), expectation.getNumberOfParametersUsed() + i + 1);
            this.jdbcValueDescriptors.add(parameterDescriptor);
        }
    }

    @Override
    public TableMapping getTableDetails() {
        return this.tableDetails;
    }

    @Override
    public MutationTarget<?> getMutationTarget() {
        return this.mutationTarget;
    }

    @Override
    public String getSqlString() {
        return this.sql;
    }

    @Override
    public List<JdbcParameterBinder> getParameterBinders() {
        return this.parameterBinders;
    }

    @Override
    public JdbcValueDescriptor findValueDescriptor(String columnName, ParameterUsage usage) {
        for (int i = 0; i < this.jdbcValueDescriptors.size(); ++i) {
            JdbcValueDescriptor descriptor = this.jdbcValueDescriptors.get(i);
            if (!descriptor.getColumnName().equals(columnName) || descriptor.getUsage() != usage) continue;
            return descriptor;
        }
        return null;
    }

    @Override
    public boolean isCallable() {
        return this.callable;
    }

    @Override
    public Expectation getExpectation() {
        return this.expectation;
    }
}

