/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.hint;

import java.util.List;
import javax.lang.model.SourceVersion;
import org.springframework.aot.hint.AbstractTypeReference;
import org.springframework.aot.hint.TypeReference;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

final class SimpleTypeReference
extends AbstractTypeReference {
    private static final List<String> PRIMITIVE_NAMES = List.of("boolean", "byte", "short", "int", "long", "char", "float", "double", "void");
    @Nullable
    private String canonicalName;

    SimpleTypeReference(String packageName, String simpleName, @Nullable TypeReference enclosingType) {
        super(packageName, simpleName, enclosingType);
    }

    static SimpleTypeReference of(String className) {
        Assert.notNull((Object)className, "'className' must not be null");
        if (!SimpleTypeReference.isValidClassName(className)) {
            throw new IllegalStateException("Invalid class name '" + className + "'");
        }
        if (!className.contains("$")) {
            return SimpleTypeReference.createTypeReference(className);
        }
        String[] elements = className.split("(?<!\\$)\\$(?!\\$)");
        SimpleTypeReference typeReference = SimpleTypeReference.createTypeReference(elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            typeReference = new SimpleTypeReference(typeReference.getPackageName(), elements[i], typeReference);
        }
        return typeReference;
    }

    private static boolean isValidClassName(String className) {
        for (String s : className.split("\\.", -1)) {
            String candidate = s.replace("[", "").replace("]", "");
            if (SourceVersion.isIdentifier(candidate)) continue;
            return false;
        }
        return true;
    }

    private static SimpleTypeReference createTypeReference(String className) {
        int i = className.lastIndexOf(46);
        if (i != -1) {
            return new SimpleTypeReference(className.substring(0, i), className.substring(i + 1), null);
        }
        String packageName = SimpleTypeReference.isPrimitive(className) ? "java.lang" : "";
        return new SimpleTypeReference(packageName, className, null);
    }

    @Override
    public String getCanonicalName() {
        if (this.canonicalName == null) {
            StringBuilder names = new StringBuilder();
            SimpleTypeReference.buildName(this, names);
            this.canonicalName = this.addPackageIfNecessary(names.toString());
        }
        return this.canonicalName;
    }

    @Override
    protected boolean isPrimitive() {
        return SimpleTypeReference.isPrimitive(this.getSimpleName());
    }

    private static boolean isPrimitive(String name) {
        return PRIMITIVE_NAMES.stream().anyMatch(name::startsWith);
    }

    private static void buildName(@Nullable TypeReference type, StringBuilder sb) {
        if (type == null) {
            return;
        }
        Object typeName = type.getEnclosingType() != null ? "." + type.getSimpleName() : type.getSimpleName();
        sb.insert(0, (String)typeName);
        SimpleTypeReference.buildName(type.getEnclosingType(), sb);
    }
}

