/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.replacement;

import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Dictionary;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.api.udm.IDictionary;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.service.replacement.ConsolidatedDictionary;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class Dictionaries {
    private final List<IDictionary> dictionaries;
    private final IDictionary.DictionaryContext context;

    private Dictionaries(List<IDictionary> dictionaries, Application application, Version applicationVersion, Environment environment, Container container) {
        this.dictionaries = dictionaries;
        this.context = Dictionaries.makeContext(applicationVersion == null ? application : applicationVersion.getApplication(), applicationVersion, environment, container);
    }

    public static Dictionaries of(Environment environment) {
        return new Dictionaries(environment.getDictionaries(), null, null, environment, null);
    }

    @Deprecated
    public Dictionaries filterBy(Application application) {
        return new Dictionaries(this.dictionaries, application, null, this.context.getEnvironment(), this.context.getContainer());
    }

    public Dictionaries filterBy(Version applicationVersion) {
        return new Dictionaries(this.dictionaries, this.context.getApplication(), applicationVersion, this.context.getEnvironment(), this.context.getContainer());
    }

    public Dictionaries filterBy(Container container) {
        return new Dictionaries(this.dictionaries, this.context.getApplication(), this.context.getApplicationVersion(), this.context.getEnvironment(), container);
    }

    public Dictionaries withAdditionalEntries(Map<String, String> dictionaryEntries) {
        IDictionary dictionary = Dictionaries.inMemoryStorage(dictionaryEntries);
        ArrayList<IDictionary> newDicts = new ArrayList<IDictionary>();
        newDicts.add(dictionary);
        newDicts.addAll(this.dictionaries);
        return new Dictionaries(newDicts, this.context.getApplication(), this.context.getApplicationVersion(), this.context.getEnvironment(), this.context.getContainer());
    }

    private static IDictionary inMemoryStorage(Map<String, String> map) {
        Dictionary dictionary = new Dictionary();
        dictionary.setEntries(map);
        return dictionary;
    }

    public ConsolidatedDictionary consolidate() {
        List<IDictionary> filteredDictionaries = this.dictionaries.stream().map(d -> d.applyTo(this.context)).filter(Objects::nonNull).collect(Collectors.toList());
        return ConsolidatedDictionary.create(filteredDictionaries);
    }

    private static IDictionary.DictionaryContext makeContext(Application application, Version applicationVersion, Environment environment, Container container) {
        return new IDictionary.DictionaryContext(application, applicationVersion, environment, container);
    }
}

