/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.config.federation.FederationAddressPolicyConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationDownstreamConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationPolicy;
import org.apache.activemq.artemis.core.config.federation.FederationPolicySet;
import org.apache.activemq.artemis.core.config.federation.FederationQueuePolicyConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationTransformerConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationUpstreamConfiguration;

public class FederationConfiguration
implements Serializable {
    private String name;
    private Credentials credentials = new Credentials();
    private List<FederationUpstreamConfiguration> upstreamConfigurations = new ArrayList<FederationUpstreamConfiguration>();
    private List<FederationDownstreamConfiguration> downstreamConfigurations = new ArrayList<FederationDownstreamConfiguration>();
    private Map<String, FederationPolicy> federationPolicyMap = new HashMap<String, FederationPolicy>();
    private Map<String, FederationTransformerConfiguration> transformerConfigurationMap = new HashMap<String, FederationTransformerConfiguration>();

    public List<FederationUpstreamConfiguration> getUpstreamConfigurations() {
        return this.upstreamConfigurations;
    }

    public FederationConfiguration addUpstreamConfiguration(FederationUpstreamConfiguration federationUpstreamConfiguration) {
        this.upstreamConfigurations.add(federationUpstreamConfiguration);
        return this;
    }

    public List<FederationDownstreamConfiguration> getDownstreamConfigurations() {
        return this.downstreamConfigurations;
    }

    public FederationConfiguration addDownstreamConfiguration(FederationDownstreamConfiguration federationDownstreamConfiguration) {
        this.downstreamConfigurations.add(federationDownstreamConfiguration);
        return this;
    }

    public FederationConfiguration addFederationPolicy(FederationPolicy federationPolicy) {
        this.federationPolicyMap.put(federationPolicy.getName(), federationPolicy);
        return this;
    }

    public Map<String, FederationPolicy> getQueuePolicies() {
        return this.federationPolicyMap;
    }

    public FederationConfiguration addQueuePolicy(FederationQueuePolicyConfiguration federationPolicy) {
        this.federationPolicyMap.put(federationPolicy.getName(), federationPolicy);
        return this;
    }

    public Map<String, FederationPolicy> getAddressPolicies() {
        return this.federationPolicyMap;
    }

    public FederationConfiguration addAddressPolicy(FederationAddressPolicyConfiguration federationPolicy) {
        this.federationPolicyMap.put(federationPolicy.getName(), federationPolicy);
        return this;
    }

    public Map<String, FederationPolicy> getPolicySets() {
        return this.federationPolicyMap;
    }

    public FederationConfiguration addPolicySet(FederationPolicySet federationPolicy) {
        this.federationPolicyMap.put(federationPolicy.getName(), federationPolicy);
        return this;
    }

    public void clearDownstreamConfigurations() {
        this.downstreamConfigurations.clear();
    }

    public void clearUpstreamConfigurations() {
        this.upstreamConfigurations.clear();
    }

    public Map<String, FederationPolicy> getFederationPolicyMap() {
        return this.federationPolicyMap;
    }

    public FederationConfiguration addTransformerConfiguration(FederationTransformerConfiguration transformerConfiguration) {
        this.transformerConfigurationMap.put(transformerConfiguration.getName(), transformerConfiguration);
        return this;
    }

    public Map<String, FederationTransformerConfiguration> getTransformerConfigurationMap() {
        return this.transformerConfigurationMap;
    }

    public Map<String, FederationTransformerConfiguration> getTransformerConfigurations() {
        return this.transformerConfigurationMap;
    }

    public String getName() {
        return this.name;
    }

    public FederationConfiguration setName(String name) {
        this.name = name;
        return this;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public FederationConfiguration setCredentials(Credentials credentials) {
        this.credentials = credentials;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FederationConfiguration)) {
            return false;
        }
        FederationConfiguration that = (FederationConfiguration)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.credentials, that.credentials) && Objects.equals(this.upstreamConfigurations, that.upstreamConfigurations) && Objects.equals(this.federationPolicyMap, that.federationPolicyMap) && Objects.equals(this.transformerConfigurationMap, that.transformerConfigurationMap);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.credentials, this.upstreamConfigurations, this.federationPolicyMap, this.transformerConfigurationMap);
    }

    public static class Credentials
    implements Serializable {
        private String user;
        private String password;

        public String getUser() {
            return this.user;
        }

        public Credentials setUser(String user) {
            this.user = user;
            return this;
        }

        public String getPassword() {
            return this.password;
        }

        public Credentials setPassword(String password) {
            this.password = password;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Credentials)) {
                return false;
            }
            Credentials that = (Credentials)o;
            return Objects.equals(this.user, that.user) && Objects.equals(this.password, that.password);
        }

        public int hashCode() {
            return Objects.hash(this.user, this.password);
        }

        public void encode(ActiveMQBuffer buffer) {
            buffer.writeNullableString(this.user);
            buffer.writeNullableString(this.password);
        }

        public void decode(ActiveMQBuffer buffer) {
            this.user = buffer.readNullableString();
            this.password = buffer.readNullableString();
        }
    }
}

