/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.internal;

import java.io.Serializable;
import java.util.Objects;
import org.hibernate.cache.MutableCacheKeyBuilder;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.NaturalIdMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.descriptor.java.JavaType;

public class NaturalIdCacheKey
implements Serializable {
    private final Object naturalIdValues;
    private final String entityName;
    private final String tenantId;
    private final int hashCode;

    public NaturalIdCacheKey(Object naturalIdValues, String entityName, String tenantId, int hashCode) {
        this.naturalIdValues = naturalIdValues;
        this.entityName = entityName;
        this.tenantId = tenantId;
        this.hashCode = hashCode;
    }

    public static NaturalIdCacheKey from(Object naturalIdValues, EntityPersister persister, String entityName, SharedSessionContractImplementor session) {
        NaturalIdMapping naturalIdMapping = persister.getNaturalIdMapping();
        NaturalIdCacheKeyBuilder builder = new NaturalIdCacheKeyBuilder(entityName, session.getTenantIdentifier(), naturalIdMapping.getJdbcTypeCount());
        JavaType<Object> tenantIdentifierJavaType = session.getFactory().getTenantIdentifierJavaType();
        Object tenantId = session.getTenantIdentifierValue();
        builder.addHashCode(tenantId == null ? 0 : tenantIdentifierJavaType.extractHashCode(tenantId));
        naturalIdMapping.addToCacheKey(builder, naturalIdValues, session);
        return builder.build();
    }

    public static NaturalIdCacheKey from(Object naturalIdValues, EntityPersister persister, SharedSessionContractImplementor session) {
        return NaturalIdCacheKey.from(naturalIdValues, persister, persister.getRootEntityName(), session);
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public Object getNaturalIdValues() {
        return this.naturalIdValues;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (this.hashCode != o.hashCode() || !(o instanceof NaturalIdCacheKey)) {
            return false;
        }
        NaturalIdCacheKey other = (NaturalIdCacheKey)o;
        return Objects.equals(this.entityName, other.entityName) && Objects.equals(this.tenantId, other.tenantId) && Objects.deepEquals(this.naturalIdValues, other.naturalIdValues);
    }

    public String toString() {
        StringBuilder toStringBuilder = new StringBuilder().append(this.entityName).append("##NaturalId[");
        if (this.naturalIdValues instanceof Object[]) {
            Object[] values = (Object[])this.naturalIdValues;
            for (int i = 0; i < values.length; ++i) {
                toStringBuilder.append(values[i]);
                if (i + 1 >= values.length) continue;
                toStringBuilder.append(", ");
            }
        } else {
            toStringBuilder.append(this.naturalIdValues);
        }
        return toStringBuilder.toString();
    }

    private static class NaturalIdCacheKeyBuilder
    implements MutableCacheKeyBuilder {
        private final String entityName;
        private final String tenantIdentifier;
        private final Object[] naturalIdValues;
        private int hashCode;
        private int naturalIdValueIndex;

        public NaturalIdCacheKeyBuilder(String entityName, String tenantIdentifier, int naturalIdValueCount) {
            this.entityName = entityName;
            this.tenantIdentifier = tenantIdentifier;
            this.naturalIdValues = new Object[naturalIdValueCount];
        }

        @Override
        public void addValue(Object value) {
            this.naturalIdValues[this.naturalIdValueIndex++] = value;
        }

        @Override
        public void addHashCode(int hashCode) {
            this.hashCode = 37 * this.hashCode + hashCode;
        }

        @Override
        public NaturalIdCacheKey build() {
            return new NaturalIdCacheKey(this.naturalIdValues, this.entityName, this.tenantIdentifier, this.hashCode);
        }
    }
}

