/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.remote.xml;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.xebialabs.deployit.booter.remote.RemoteMethodDescriptor;
import com.xebialabs.deployit.booter.remote.xml.RemoteTypeProvider;
import com.xebialabs.deployit.booter.remote.xml.TypeProvider;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.xltype.serialization.xstream.XStreamProvider;
import java.util.HashMap;
import java.util.Map;

@XStreamProvider(tagName="control-task", readable=MethodDescriptor.class)
public class MethodDescriptorConverter
implements Converter {
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        throw new IllegalStateException("Cannot serialize MethodDescriptor from remote-booter");
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        RemoteTypeProvider typeProvider = new RemoteTypeProvider(context);
        return this.doUnmarshal(reader, typeProvider);
    }

    protected RemoteMethodDescriptor doUnmarshal(HierarchicalStreamReader reader, TypeProvider typeProvider) {
        RemoteMethodDescriptor methodDescriptor = new RemoteMethodDescriptor();
        this.readXmlAttributes(reader, methodDescriptor, typeProvider);
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if (reader.getNodeName().equals("attributes")) {
                methodDescriptor.setAttributes(this.readAttributes(reader));
            }
            reader.moveUp();
        }
        return methodDescriptor;
    }

    private void readXmlAttributes(HierarchicalStreamReader reader, RemoteMethodDescriptor methodDescriptor, TypeProvider typeProvider) {
        methodDescriptor.setName(reader.getAttribute("name"));
        methodDescriptor.setFqn(reader.getAttribute("fqn"));
        methodDescriptor.setDescription(reader.getAttribute("description"));
        methodDescriptor.setLabel(reader.getAttribute("label"));
        String attribute = reader.getAttribute("parameters-type");
        if (attribute != null && !attribute.trim().isEmpty()) {
            methodDescriptor.setParameterObjectType(typeProvider.getType(attribute));
        }
    }

    private Map<String, String> readAttributes(HierarchicalStreamReader reader) {
        HashMap<String, String> map = new HashMap<String, String>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            map.put(reader.getNodeName(), reader.getValue());
            reader.moveUp();
        }
        return map;
    }

    public boolean canConvert(Class type) {
        return MethodDescriptor.class.equals((Object)type);
    }
}

