/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.form;

import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.gui.form.FormAccessor;
import com.jeta.forms.gui.form.FormComponent;
import com.jeta.forms.gui.form.GridComponent;
import com.jeta.forms.gui.form.GridView;
import com.jeta.forms.gui.form.StandardComponent;
import java.awt.Component;
import java.awt.Container;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.swing.JPanel;

public class FormIterator
implements Iterator {
    private FormAccessor m_accessor;
    private long m_time_stamp;
    private boolean m_nested;
    private int m_index = -1;
    private Iterator m_nested_iter = null;
    private Component m_last_comp;
    private long m_mod_stamp;

    public FormIterator(FormAccessor formAccessor, boolean bl) {
        this.m_accessor = formAccessor;
        this.m_nested = bl;
        this.m_index = -1;
        this.m_mod_stamp = ((GridView)formAccessor).getModificationStamp();
    }

    private void checkConcurrentModification() {
        GridView gridView = (GridView)this.m_accessor;
        if (this.m_mod_stamp < gridView.getModificationStamp()) {
            throw new ConcurrentModificationException();
        }
        long l = gridView.getNestedModificationStamp();
        if (l <= 0L) {
            l = this.m_mod_stamp;
        }
        if (this.isNested() && this.m_mod_stamp < l) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean hasNext() {
        Container container;
        int n;
        if (this.m_nested_iter != null) {
            if (this.m_nested_iter.hasNext()) {
                return true;
            }
            this.m_nested_iter = null;
        }
        if ((n = this.m_index + 1) >= (container = this.m_accessor.getContainer()).getComponentCount()) {
            return false;
        }
        while (n < container.getComponentCount()) {
            Component component = container.getComponent(n);
            if (component instanceof GridComponent) {
                Component component2;
                GridComponent gridComponent = (GridComponent)component;
                if (gridComponent instanceof FormComponent) {
                    this.m_index = n - 1;
                    return true;
                }
                if (gridComponent instanceof StandardComponent && (component2 = gridComponent.getBeanDelegate()) != null) {
                    this.m_index = n - 1;
                    return true;
                }
            } else if (component instanceof Component) {
                this.m_index = n - 1;
                return true;
            }
            ++n;
        }
        this.m_index = n;
        return false;
    }

    private boolean isNested() {
        return this.m_nested;
    }

    public Object next() {
        this.checkConcurrentModification();
        if (this.m_nested_iter != null) {
            return this.m_nested_iter.next();
        }
        this.m_last_comp = null;
        ++this.m_index;
        Container container = this.m_accessor.getContainer();
        if (this.m_index >= container.getComponentCount()) {
            throw new NoSuchElementException();
        }
        while (this.m_index < container.getComponentCount()) {
            Component component = container.getComponent(this.m_index);
            if (component instanceof GridComponent) {
                Object object;
                JPanel jPanel;
                GridComponent gridComponent = (GridComponent)component;
                if (gridComponent instanceof FormComponent) {
                    jPanel = (FormComponent)gridComponent;
                    if (this.isNested() && (object = new FormIterator(((FormComponent)jPanel).getChildView().getFormAccessor(), this.isNested())).hasNext()) {
                        this.m_nested_iter = object;
                    }
                    this.m_last_comp = jPanel;
                    return ((FormComponent)jPanel).getChildView();
                }
                if (gridComponent instanceof StandardComponent) {
                    jPanel = gridComponent.getBean();
                    object = null;
                    if (jPanel != null) {
                        object = ((JETABean)jPanel).getBeanChildComponent();
                    }
                    if (object != null) {
                        this.m_last_comp = object;
                        return object;
                    }
                }
            } else if (component instanceof Component) {
                this.m_last_comp = component;
                return component;
            }
            ++this.m_index;
        }
        throw new NoSuchElementException();
    }

    public void remove() {
        this.checkConcurrentModification();
        if (this.m_nested_iter != null) {
            this.m_nested_iter.remove();
            return;
        }
        if (this.m_last_comp == null) {
            throw new IllegalStateException();
        }
        if (this.m_accessor.removeBean(this.m_last_comp) != null) {
            --this.m_index;
            this.m_last_comp = null;
            this.m_mod_stamp = ((GridView)this.m_accessor).getModificationStamp();
        }
    }
}

