/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.os.ms.win.w32;

import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import java.util.logging.Logger;
import org.rzo.yajsw.os.SystemInformation;

public class WindowsXPSystemInformation
implements SystemInformation {
    public Logger _logger;
    private long _freeRAM = 0L;
    private long _totalRAM = 0L;
    private long _lastCall = 0L;

    private void calc() {
        if (System.currentTimeMillis() - this._lastCall < 500L) {
            return;
        }
        WinBase.MEMORYSTATUSEX lpBuffer = new WinBase.MEMORYSTATUSEX();
        lpBuffer.dwLength = new WinDef.DWORD((long)lpBuffer.size());
        if (Kernel32.INSTANCE.GlobalMemoryStatusEx(lpBuffer)) {
            lpBuffer.read();
            this._freeRAM = lpBuffer.ullAvailPhys.longValue();
            this._totalRAM = lpBuffer.ullTotalPhys.longValue();
            this._lastCall = System.currentTimeMillis();
        } else if (this._logger != null) {
            this._logger.severe("ERROR: could not read free/total RAM");
        } else {
            System.out.println("ERROR: could not read free/total RAM");
        }
    }

    @Override
    public long freeRAM() {
        this.calc();
        return this._freeRAM;
    }

    @Override
    public long totalRAM() {
        this.calc();
        return this._totalRAM;
    }

    @Override
    public void setLogger(Logger logger) {
        this._logger = logger;
    }

    public static void main(String[] args) {
        while (true) {
            System.out.println(new WindowsXPSystemInformation().totalRAM());
            System.out.println(new WindowsXPSystemInformation().freeRAM());
        }
    }
}

