/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.oslogin.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FingerprintName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"users/{user}/sshPublicKeys/{fingerprint}");
    private volatile Map<String, String> fieldValuesMap;
    private final String user;
    private final String fingerprint;

    public String getUser() {
        return this.user;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private FingerprintName(Builder builder) {
        this.user = (String)Preconditions.checkNotNull((Object)builder.getUser());
        this.fingerprint = (String)Preconditions.checkNotNull((Object)builder.getFingerprint());
    }

    public static FingerprintName of(String user, String fingerprint) {
        return FingerprintName.newBuilder().setUser(user).setFingerprint(fingerprint).build();
    }

    public static String format(String user, String fingerprint) {
        return FingerprintName.newBuilder().setUser(user).setFingerprint(fingerprint).build().toString();
    }

    public static FingerprintName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "FingerprintName.parse: formattedString not in valid format");
        return FingerprintName.of((String)matchMap.get("user"), (String)matchMap.get("fingerprint"));
    }

    public static List<FingerprintName> parseList(List<String> formattedStrings) {
        ArrayList<FingerprintName> list = new ArrayList<FingerprintName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FingerprintName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FingerprintName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FingerprintName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FingerprintName fingerprintName = this;
            synchronized (fingerprintName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"user", (Object)this.user);
                    fieldMapBuilder.put((Object)"fingerprint", (Object)this.fingerprint);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"user", this.user, "fingerprint", this.fingerprint});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FingerprintName) {
            FingerprintName that = (FingerprintName)o;
            return this.user.equals(that.user) && this.fingerprint.equals(that.fingerprint);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.user.hashCode();
        h *= 1000003;
        return h ^= this.fingerprint.hashCode();
    }

    public static class Builder {
        private String user;
        private String fingerprint;

        public String getUser() {
            return this.user;
        }

        public String getFingerprint() {
            return this.fingerprint;
        }

        public Builder setUser(String user) {
            this.user = user;
            return this;
        }

        public Builder setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        private Builder() {
        }

        private Builder(FingerprintName fingerprintName) {
            this.user = fingerprintName.user;
            this.fingerprint = fingerprintName.fingerprint;
        }

        public FingerprintName build() {
            return new FingerprintName(this);
        }
    }
}

