/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel;

import java.util.Locale;
import org.hibernate.AssertionFailure;

public enum RepresentationMode {
    POJO,
    MAP;


    public String getExternalName() {
        switch (this) {
            case POJO: {
                return "pojo";
            }
            case MAP: {
                return "dynamic-map";
            }
        }
        throw new AssertionFailure("Unknown RepresentationMode");
    }

    public static RepresentationMode fromExternalName(String externalName) {
        if (externalName == null) {
            return POJO;
        }
        switch (externalName.toLowerCase(Locale.ROOT)) {
            case "pojo": {
                return POJO;
            }
            case "dynamic-map": 
            case "map": {
                return MAP;
            }
        }
        throw new IllegalArgumentException("Unknown RepresentationMode");
    }
}

