/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.open.gui.framework;

import com.jeta.open.gui.framework.JETAContainer;
import com.jeta.open.gui.framework.JETAController;
import com.jeta.open.gui.framework.UIDirector;
import com.jeta.open.registry.JETARegistry;
import com.jeta.open.support.ComponentFinder;
import com.jeta.open.support.ComponentFinderFactory;
import com.jeta.open.support.DefaultComponentFinder;
import com.jeta.open.support.SwingComponentSupport;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;

public class JETAPanel
extends JPanel
implements JETAContainer,
SwingComponentSupport {
    private ComponentFinder m_finder;
    private JETAController m_controller;
    private UIDirector m_uidirector;

    public JETAPanel() {
    }

    public JETAPanel(LayoutManager layoutManager) {
        super(layoutManager);
    }

    public JETAPanel(ComponentFinder componentFinder) {
        this.m_finder = componentFinder;
    }

    protected ComponentFinder createComponentFinder() {
        if (this.m_finder == null) {
            ComponentFinderFactory componentFinderFactory = (ComponentFinderFactory)JETARegistry.lookup("component.finder.factory");
            if (componentFinderFactory != null) {
                this.m_finder = componentFinderFactory.createFinder(this);
            }
            if (this.m_finder == null) {
                this.m_finder = new DefaultComponentFinder(this);
            }
        }
        return this.m_finder;
    }

    public void enableComponent(String string, boolean bl) {
        Collection collection = this.getComponentsByName(string);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Component component = (Component)iterator.next();
            if (component.isEnabled() == bl) continue;
            component.setEnabled(bl);
        }
    }

    public boolean getBoolean(String string) {
        Component component = this.getComponentByName(string);
        if (component instanceof AbstractButton) {
            return ((AbstractButton)component).isSelected();
        }
        return false;
    }

    public AbstractButton getButton(String string) {
        Component component = this.getComponentByName(string);
        if (component instanceof AbstractButton) {
            return (AbstractButton)component;
        }
        return null;
    }

    public JCheckBox getCheckBox(String string) {
        Component component = this.getComponentByName(string);
        if (component instanceof JCheckBox) {
            return (JCheckBox)component;
        }
        return null;
    }

    public JComboBox getComboBox(String string) {
        Component component = this.getComponentByName(string);
        if (component instanceof JComboBox) {
            return (JComboBox)component;
        }
        return null;
    }

    public Component getComponentByName(String string) {
        Component component = this.getComponentFinder().getComponentByName(string);
        if (component == null) {
            System.err.println("JETAPanel.getComponentByName failed to find component: " + string);
        }
        return component;
    }

    protected ComponentFinder getComponentFinder() {
        if (this.m_finder == null) {
            this.m_finder = this.createComponentFinder();
        }
        return this.m_finder;
    }

    public Collection getComponentsByName(String string) {
        return this.getComponentFinder().getComponentsByName(string);
    }

    public JETAController getController() {
        return this.m_controller;
    }

    public int getInteger(String string, int n) {
        try {
            Component component = this.getComponentByName(string);
            if (component instanceof JTextField) {
                return Integer.parseInt(((JTextField)component).getText());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public JLabel getLabel(String string) {
        Component component = this.getComponentByName(string);
        if (component instanceof JLabel) {
            return (JLabel)component;
        }
        return null;
    }

    public JList getList(String string) {
        Component component = this.getComponentByName(string);
        if (component instanceof JList) {
            return (JList)component;
        }
        return null;
    }

    public JPanel getPanel(String string) {
        Component component = this.getComponentByName(string);
        if (component instanceof JPanel) {
            return (JPanel)component;
        }
        return null;
    }

    public JProgressBar getProgressBar(String string) {
        Component component = this.getComponentByName(string);
        if (component instanceof JProgressBar) {
            return (JProgressBar)component;
        }
        return null;
    }

    public JRadioButton getRadioButton(String string) {
        Component component = this.getComponentByName(string);
        if (component instanceof JRadioButton) {
            return (JRadioButton)component;
        }
        return null;
    }

    public Object getSelectedItem(String string) {
        Component component = this.getComponentByName(string);
        if (component instanceof JList) {
            return ((JList)component).getSelectedValue();
        }
        if (component instanceof JComboBox) {
            return ((JComboBox)component).getSelectedItem();
        }
        return null;
    }

    public JSpinner getSpinner(String string) {
        Component component = this.getComponentByName(string);
        if (component instanceof JSpinner) {
            return (JSpinner)component;
        }
        return null;
    }

    public JTable getTable(String string) {
        Component component = this.getComponentByName(string);
        if (component instanceof JTable) {
            return (JTable)component;
        }
        return null;
    }

    public JTabbedPane getTabbedPane(String string) {
        Component component = this.getComponentByName(string);
        if (component instanceof JTabbedPane) {
            return (JTabbedPane)component;
        }
        return null;
    }

    public JTextComponent getTextComponent(String string) {
        Component component = this.getComponentByName(string);
        if (component instanceof JTextComponent) {
            return (JTextComponent)component;
        }
        return null;
    }

    public JTextField getTextField(String string) {
        Component component = this.getComponentByName(string);
        if (component instanceof JTextField) {
            return (JTextField)component;
        }
        return null;
    }

    public String getText(String string) {
        Component component = this.getComponentByName(string);
        if (component instanceof JTextComponent) {
            return ((JTextComponent)component).getText();
        }
        if (component instanceof AbstractButton) {
            return ((AbstractButton)component).getText();
        }
        if (component instanceof JLabel) {
            return ((JLabel)component).getText();
        }
        try {
            if (component != null) {
                Class<?> clazz = component.getClass();
                Class[] classArray = new Class[]{};
                Object[] objectArray = new Object[]{};
                Method method = clazz.getDeclaredMethod("getText", classArray);
                Object object = method.invoke((Object)component, objectArray);
                return object == null ? null : object.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public JTree getTree(String string) {
        Component component = this.getComponentByName(string);
        if (component instanceof JTree) {
            return (JTree)component;
        }
        return null;
    }

    public UIDirector getUIDirector() {
        return this.m_uidirector;
    }

    public boolean isSelected(String string) {
        return this.getBoolean(string);
    }

    public void removeDescendent(String string) {
        Component component = this.getComponentByName(string);
        if (component != null) {
            JETAPanel.removeFromParent(component);
        }
    }

    public static void removeFromParent(Component component) {
        Container container;
        if (component != null && (container = component.getParent()) != null) {
            container.remove(component);
            if (container instanceof JComponent) {
                ((JComponent)container).revalidate();
            }
        }
    }

    public void reset() {
        if (this.m_finder != null) {
            this.m_finder.reset();
        }
    }

    protected void setComponentFinder(ComponentFinder componentFinder) {
        this.m_finder = componentFinder;
    }

    public void setUIDirector(UIDirector uIDirector) {
        this.m_uidirector = uIDirector;
    }

    public void setController(JETAController jETAController) {
        this.m_controller = jETAController;
    }

    public void setVisible(String string, boolean bl) {
        Component component = this.getComponentByName(string);
        if (component != null) {
            component.setVisible(bl);
        }
    }

    public void setSelected(String string, boolean bl) {
        Component component = this.getComponentByName(string);
        if (component instanceof AbstractButton) {
            ((AbstractButton)component).setSelected(bl);
        }
    }

    public void setSelectedItem(String string, Object object) {
        Component component = this.getComponentByName(string);
        if (component instanceof JComboBox) {
            ((JComboBox)component).setSelectedItem(object);
        } else if (component instanceof JList) {
            ((JList)component).setSelectedValue(object, true);
        }
    }

    public void setText(String string, String string2) {
        Component component = this.getComponentByName(string);
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).setText(string2);
        } else if (component instanceof JLabel) {
            ((JLabel)component).setText(string2);
        } else if (component instanceof AbstractButton) {
            ((AbstractButton)component).setText(string2);
        } else {
            try {
                if (component != null) {
                    Class<?> clazz = component.getClass();
                    Class[] classArray = new Class[]{String.class};
                    Object[] objectArray = new Object[]{string2};
                    Method method = clazz.getDeclaredMethod("setText", classArray);
                    method.invoke((Object)component, objectArray);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void updateComponents() {
        this.updateComponents(null);
    }

    public void updateComponents(EventObject eventObject) {
        if (this.m_controller != null) {
            this.m_controller.updateComponents(eventObject);
        }
    }
}

