/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.plugin.manager.compatibility;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jboss.windup.decompiler.api.DecompilationException;
import org.jboss.windup.decompiler.api.DecompilationFailure;
import org.jboss.windup.decompiler.api.DecompilationListener;
import org.jboss.windup.decompiler.api.DecompilationResult;
import org.jboss.windup.decompiler.fernflower.FernFlowerResultSaver;
import org.jboss.windup.decompiler.fernflower.FernflowerDecompiler;
import org.jboss.windup.decompiler.fernflower.FernflowerJDKLogger;
import org.jboss.windup.decompiler.util.Filter;
import org.jboss.windup.util.exception.WindupStopException;
import org.jetbrains.java.decompiler.main.Fernflower;
import org.jetbrains.java.decompiler.main.extern.IBytecodeProvider;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class XlFernflowerDecompiler
extends FernflowerDecompiler {
    private static final Logger LOG = Logger.getLogger(XlFernflowerDecompiler.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DecompilationResult decompileArchiveImpl(Path archive, Path outputDir, Filter<ZipEntry> filter, final DecompilationListener delegate) throws DecompilationException {
        JarFile jar;
        final DecompilationResult result = new DecompilationResult();
        DecompilationListener listener = new DecompilationListener(){
            private boolean cancelled;

            public void fileDecompiled(List<String> inputPaths, String outputPath) {
                try {
                    result.addDecompiled(inputPaths, outputPath);
                    delegate.fileDecompiled(inputPaths, outputPath);
                }
                catch (WindupStopException stop) {
                    this.cancelled = true;
                    throw new WindupStopException((Exception)((Object)stop));
                }
            }

            public void decompilationFailed(List<String> inputPath, String message) {
                result.addFailure(new DecompilationFailure(message, inputPath, null));
                delegate.decompilationFailed(inputPath, message);
            }

            public void decompilationProcessComplete() {
                delegate.decompilationProcessComplete();
            }

            public boolean isCancelled() {
                return this.cancelled;
            }
        };
        LOG.info("Decompiling archive '" + String.valueOf(archive.toAbsolutePath()) + "' to '" + String.valueOf(outputDir.toAbsolutePath()) + "'");
        try {
            jar = new JarFile(archive.toFile());
        }
        catch (IOException ex) {
            throw new DecompilationException("Can't load .jar: " + String.valueOf(archive), (Throwable)ex);
        }
        try {
            AtomicInteger jarEntryCount = new AtomicInteger(0);
            Enumeration<JarEntry> countEnum = jar.entries();
            while (countEnum.hasMoreElements()) {
                countEnum.nextElement();
                jarEntryCount.incrementAndGet();
            }
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                final JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.endsWith(".class")) {
                    jarEntryCount.decrementAndGet();
                    continue;
                }
                if (filter != null) {
                    Filter.Result filterRes = filter.decide((Object)entry);
                    if (filterRes == Filter.Result.REJECT) {
                        jarEntryCount.decrementAndGet();
                        continue;
                    }
                    if (filterRes == Filter.Result.STOP) break;
                }
                IBytecodeProvider bytecodeProvider = new IBytecodeProvider(){

                    public byte[] getBytecode(String externalPath, String internalPath) throws IOException {
                        return InterpreterUtil.getBytes((ZipFile)jar, (ZipEntry)entry);
                    }
                };
                FernFlowerResultSaver resultSaver = this.getResultSaver(Collections.singletonList(entry.getName()), outputDir.toFile(), listener);
                Fernflower fernflower = new Fernflower(bytecodeProvider, (IResultSaver)resultSaver, this.getOptions(), (IFernflowerLogger)new FernflowerJDKLogger());
                fernflower.getStructContext().addSpace(new File(entry.getName()), true);
                fernflower.decompileContext();
                if (resultSaver.isFileSaved()) continue;
                listener.decompilationFailed(Collections.singletonList(entry.getName()), "File was not decompiled!");
            }
            listener.decompilationProcessComplete();
            DecompilationResult decompilationResult = result;
            return decompilationResult;
        }
        finally {
            try {
                jar.close();
            }
            catch (IOException e) {
                LOG.warning("Failed to close jar file: " + jar.getName());
            }
        }
    }

    private FernFlowerResultSaver getResultSaver(List<String> requests, File directory, DecompilationListener listener) {
        return new FernFlowerResultSaver(requests, directory, listener);
    }

    private Map<String, Object> getOptions() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("mpm", 30);
        options.put("dgs", "1");
        options.put("bsm", "1");
        return options;
    }
}

