/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.util;

import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.InlineLayoutBox;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;

public class DescendantBoxSpliterator
implements Spliterator<Box> {
    private final Deque<Box> unprocessed = new ArrayDeque<Box>();
    private State curState = State.BOX_CHILDREN;
    private int childIndex = 0;

    public DescendantBoxSpliterator(Box parent) {
        this.unprocessed.add(parent);
    }

    private boolean hasChildren(Box bx) {
        return bx.getChildCount() > 0 || bx instanceof BlockBox && !((BlockBox)bx).getInlineContent().isEmpty() || bx instanceof InlineLayoutBox && ((InlineLayoutBox)bx).getInlineChildCount() > 0;
    }

    private void add(Box bx) {
        this.unprocessed.add(bx);
    }

    private void next() {
        this.setState(State.BOX_CHILDREN);
        this.unprocessed.remove();
    }

    private boolean hasNext() {
        return !this.unprocessed.isEmpty();
    }

    private Box current() {
        return this.unprocessed.peek();
    }

    private void setState(State newState) {
        this.curState = newState;
        this.childIndex = 0;
    }

    private Box getNext() {
        Box box = this.current();
        if (box == null) {
            return null;
        }
        switch (this.curState) {
            case BOX_CHILDREN: {
                if (this.childIndex < box.getChildCount()) {
                    Box next = box.getChild(this.childIndex);
                    ++this.childIndex;
                    if (this.hasChildren(next)) {
                        this.add(next);
                    }
                    return next;
                }
                this.setState(State.BLOCK_INLINE_CONTENT);
            }
            case BLOCK_INLINE_CONTENT: {
                BlockBox block;
                Box next;
                if (box instanceof BlockBox && (next = this.getNextInlineChild((block = (BlockBox)box).getInlineContent())) != null) {
                    return next;
                }
                this.setState(State.ILB_INLINE_CHILDREN);
            }
            case ILB_INLINE_CHILDREN: {
                InlineLayoutBox ilb;
                Box next;
                if (box instanceof InlineLayoutBox && (next = this.getNextInlineChild((ilb = (InlineLayoutBox)box).getInlineChildren())) != null) {
                    return next;
                }
                this.setState(State.DONE);
            }
        }
        this.next();
        return null;
    }

    private Box getNextInlineChild(List<? extends Object> inlineChilds) {
        if (inlineChilds == null) {
            return null;
        }
        while (this.childIndex < inlineChilds.size()) {
            Object inlineChild = inlineChilds.get(this.childIndex);
            ++this.childIndex;
            if (!(inlineChild instanceof Box)) continue;
            if (this.hasChildren((Box)inlineChild)) {
                this.add((Box)inlineChild);
            }
            return (Box)inlineChild;
        }
        return null;
    }

    @Override
    public boolean tryAdvance(Consumer<? super Box> action) {
        Box next = this.getNext();
        if (next != null) {
            action.accept(next);
            return true;
        }
        while (this.hasNext()) {
            Box next2 = this.getNext();
            if (next2 == null) continue;
            action.accept(next2);
            return true;
        }
        return false;
    }

    @Override
    public Spliterator<Box> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return 1280;
    }

    private static enum State {
        BOX_CHILDREN,
        BLOCK_INLINE_CONTENT,
        ILB_INLINE_CHILDREN,
        DONE;

    }
}

