/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import java.lang.reflect.Type;
import java.util.function.Predicate;
import javax.lang.model.element.Modifier;
import org.springframework.aot.generate.GeneratedMethod;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.beans.factory.aot.BeanRegistrationCodeFragments;
import org.springframework.beans.factory.aot.BeanRegistrationCodeFragmentsDecorator;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.InstanceSupplier;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.context.properties.BindMethodAttribute;
import org.springframework.boot.context.properties.ConstructorBound;
import org.springframework.boot.context.properties.bind.BindMethod;
import org.springframework.core.AttributeAccessor;
import org.springframework.javapoet.ClassName;
import org.springframework.javapoet.CodeBlock;

class ConfigurationPropertiesBeanRegistrationAotProcessor
implements BeanRegistrationAotProcessor {
    ConfigurationPropertiesBeanRegistrationAotProcessor() {
    }

    public BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        if (!this.isImmutableConfigurationPropertiesBeanDefinition((BeanDefinition)registeredBean.getMergedBeanDefinition())) {
            return null;
        }
        return BeanRegistrationAotContribution.withCustomCodeFragments(codeFragments -> new ConfigurationPropertiesBeanRegistrationCodeFragments((BeanRegistrationCodeFragments)codeFragments, registeredBean));
    }

    private boolean isImmutableConfigurationPropertiesBeanDefinition(BeanDefinition beanDefinition) {
        return BindMethod.VALUE_OBJECT.equals((Object)BindMethodAttribute.get((AttributeAccessor)beanDefinition));
    }

    private static class ConfigurationPropertiesBeanRegistrationCodeFragments
    extends BeanRegistrationCodeFragmentsDecorator {
        private static final String REGISTERED_BEAN_PARAMETER_NAME = "registeredBean";
        private final RegisteredBean registeredBean;

        ConfigurationPropertiesBeanRegistrationCodeFragments(BeanRegistrationCodeFragments codeFragments, RegisteredBean registeredBean) {
            super(codeFragments);
            this.registeredBean = registeredBean;
        }

        public CodeBlock generateSetBeanDefinitionPropertiesCode(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode, RootBeanDefinition beanDefinition, Predicate<String> attributeFilter) {
            return super.generateSetBeanDefinitionPropertiesCode(generationContext, beanRegistrationCode, beanDefinition, attributeFilter.or(BindMethodAttribute.NAME::equals));
        }

        public ClassName getTarget(RegisteredBean registeredBean) {
            return ClassName.get((Class)this.registeredBean.getBeanClass());
        }

        public CodeBlock generateInstanceSupplierCode(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode, boolean allowDirectSupplierShortcut) {
            GeneratedMethod generatedMethod = beanRegistrationCode.getMethods().add("getInstance", method -> {
                Class beanClass = this.registeredBean.getBeanClass();
                method.addJavadoc("Get the bean instance for '$L'.", new Object[]{this.registeredBean.getBeanName()}).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).returns((Type)beanClass).addParameter(RegisteredBean.class, REGISTERED_BEAN_PARAMETER_NAME, new Modifier[0]).addStatement("$T beanFactory = registeredBean.getBeanFactory()", new Object[]{BeanFactory.class}).addStatement("$T beanName = registeredBean.getBeanName()", new Object[]{String.class}).addStatement("$T<?> beanClass = registeredBean.getBeanClass()", new Object[]{Class.class}).addStatement("return ($T) $T.from(beanFactory, beanName, beanClass)", new Object[]{beanClass, ConstructorBound.class});
            });
            return CodeBlock.of((String)"$T.of($T::$L)", (Object[])new Object[]{InstanceSupplier.class, beanRegistrationCode.getClassName(), generatedMethod.getName()});
        }
    }
}

