/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.List;
import org.python.indexer.Scope;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NDictType;
import org.python.indexer.types.NType;

public class NDict
extends NNode {
    static final long serialVersionUID = 318144953740238374L;
    public List<NNode> keys;
    public List<NNode> values;

    public NDict(List<NNode> keys, List<NNode> values) {
        this(keys, values, 0, 1);
    }

    public NDict(List<NNode> keys, List<NNode> values, int start, int end) {
        super(start, end);
        this.keys = keys;
        this.values = values;
        this.addChildren(keys);
        this.addChildren(values);
    }

    @Override
    public NType resolve(Scope s) throws Exception {
        NType keyType = this.resolveListAsUnion(this.keys, s);
        NType valType = this.resolveListAsUnion(this.values, s);
        return this.setType(new NDictType(keyType, valType));
    }

    public String toString() {
        return "<Dict>";
    }

    @Override
    public void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            this.visitNodeList(this.keys, v);
            this.visitNodeList(this.values, v);
        }
    }
}

