/*
 * Decompiled with CFR 0.152.
 */
package nl.javadude.scannit.scanner;

import javassist.bytecode.ClassFile;
import nl.javadude.scannit.metadata.DescriptorHelper;
import nl.javadude.scannit.predicates.Predicates;
import nl.javadude.scannit.registry.Registry;
import nl.javadude.scannit.scanner.AbstractScanner;

public class SubTypeScanner
extends AbstractScanner {
    public SubTypeScanner() {
        this.addFilter(Predicates.not(Predicates.equalTo(Object.class.getName())));
    }

    @Override
    protected void doScan(ClassFile file, Registry registry) {
        String superclass = file.getSuperclass();
        if (this.accepts(superclass)) {
            this.addToRegistry(registry, superclass, DescriptorHelper.toTypeDescriptor(file));
        }
        for (String intf : file.getInterfaces()) {
            if (!this.accepts(intf)) continue;
            this.addToRegistry(registry, intf, DescriptorHelper.toTypeDescriptor(file));
        }
    }
}

