/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.enumerated.reference.internal;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedOrdinalRenderer;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceBlock;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceExtension;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceLink;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceRendering;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceRepository;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceText;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferences;
import com.vladsch.flexmark.ext.enumerated.reference.internal.EnumRefTextCollectingVisitor;
import com.vladsch.flexmark.ext.enumerated.reference.internal.EnumeratedReferenceOptions;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.HeaderIdGenerator;
import com.vladsch.flexmark.html.renderer.HtmlIdGenerator;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.html.renderer.PhasedNodeRenderer;
import com.vladsch.flexmark.html.renderer.RenderingPhase;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class EnumeratedReferenceNodeRenderer
implements PhasedNodeRenderer {
    private final EnumeratedReferenceOptions options;
    private EnumeratedReferences enumeratedOrdinals;
    private Runnable ordinalRunnable;
    private final HtmlIdGenerator headerIdGenerator;

    public EnumeratedReferenceNodeRenderer(DataHolder options) {
        this.options = new EnumeratedReferenceOptions(options);
        this.ordinalRunnable = null;
        this.headerIdGenerator = new HeaderIdGenerator.Factory().create();
    }

    public Set<RenderingPhase> getRenderingPhases() {
        LinkedHashSet<RenderingPhase> phaseSet = new LinkedHashSet<RenderingPhase>();
        phaseSet.add(RenderingPhase.HEAD_TOP);
        phaseSet.add(RenderingPhase.BODY_TOP);
        return phaseSet;
    }

    public void renderDocument(@NotNull NodeRendererContext context, @NotNull HtmlWriter html, @NotNull Document document, @NotNull RenderingPhase phase) {
        if (phase == RenderingPhase.HEAD_TOP) {
            this.headerIdGenerator.generateIds(document);
        } else if (phase == RenderingPhase.BODY_TOP) {
            this.enumeratedOrdinals = (EnumeratedReferences)EnumeratedReferenceExtension.ENUMERATED_REFERENCE_ORDINALS.get((DataHolder)document);
        }
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler(EnumeratedReferenceText.class, this::render));
        set.add(new NodeRenderingHandler(EnumeratedReferenceLink.class, this::render));
        set.add(new NodeRenderingHandler(EnumeratedReferenceBlock.class, this::render));
        return set;
    }

    private void render(final EnumeratedReferenceLink node, NodeRendererContext context, HtmlWriter html) {
        final String text = node.getText().toString();
        if (text.isEmpty()) {
            if (this.ordinalRunnable != null) {
                this.ordinalRunnable.run();
            }
        } else {
            this.enumeratedOrdinals.renderReferenceOrdinals(text, new OrdinalRenderer(this, context, html){

                @Override
                public void startRendering(EnumeratedReferenceRendering[] renderings) {
                    String title = new EnumRefTextCollectingVisitor().collectAndGetText(node.getChars().getBaseSequence(), renderings, null);
                    ((HtmlWriter)((HtmlWriter)this.html.withAttr().attr((CharSequence)"href", (CharSequence)("#" + text))).attr((CharSequence)"title", (CharSequence)title)).tag((CharSequence)"a");
                }

                @Override
                public void endRendering() {
                    this.html.tag((CharSequence)"/a");
                }
            });
        }
    }

    private void render(EnumeratedReferenceText node, NodeRendererContext context, HtmlWriter html) {
        Object text = node.getText().toString();
        if (((String)text).isEmpty()) {
            if (this.ordinalRunnable != null) {
                this.ordinalRunnable.run();
            }
        } else {
            Node parent;
            String type = EnumeratedReferenceRepository.getType(((String)text).toString());
            if ((type.isEmpty() || ((String)text).equals(type + ":")) && (parent = node.getAncestorOfType(new Class[]{Heading.class})) instanceof Heading) {
                text = (String)(type.isEmpty() ? text : type) + ":" + this.headerIdGenerator.getId(parent);
            }
            this.enumeratedOrdinals.renderReferenceOrdinals((String)text, new OrdinalRenderer(this, context, html));
        }
    }

    private void render(EnumeratedReferenceBlock node, NodeRendererContext context, HtmlWriter html) {
    }

    public static class Factory
    implements NodeRendererFactory {
        @NotNull
        public NodeRenderer apply(@NotNull DataHolder options) {
            return new EnumeratedReferenceNodeRenderer(options);
        }
    }

    private static class OrdinalRenderer
    implements EnumeratedOrdinalRenderer {
        final EnumeratedReferenceNodeRenderer renderer;
        final NodeRendererContext context;
        final HtmlWriter html;

        public OrdinalRenderer(EnumeratedReferenceNodeRenderer renderer, NodeRendererContext context, HtmlWriter html) {
            this.renderer = renderer;
            this.context = context;
            this.html = html;
        }

        @Override
        public void startRendering(EnumeratedReferenceRendering[] renderings) {
        }

        @Override
        public void setEnumOrdinalRunnable(Runnable runnable) {
            this.renderer.ordinalRunnable = runnable;
        }

        @Override
        public Runnable getEnumOrdinalRunnable() {
            return this.renderer.ordinalRunnable;
        }

        @Override
        public void render(int referenceOrdinal, EnumeratedReferenceBlock referenceFormat, String defaultText, boolean needSeparator) {
            Runnable compoundRunnable = this.renderer.ordinalRunnable;
            if (referenceFormat != null) {
                this.renderer.ordinalRunnable = () -> {
                    if (compoundRunnable != null) {
                        compoundRunnable.run();
                    }
                    this.html.text((CharSequence)String.valueOf(referenceOrdinal));
                    if (needSeparator) {
                        this.html.text((CharSequence)".");
                    }
                };
                this.context.renderChildren((Node)referenceFormat);
            } else {
                this.html.text((CharSequence)(defaultText + " "));
                if (compoundRunnable != null) {
                    compoundRunnable.run();
                }
                this.html.text((CharSequence)String.valueOf(referenceOrdinal));
                if (needSeparator) {
                    this.html.text((CharSequence)".");
                }
            }
        }

        @Override
        public void endRendering() {
        }
    }
}

