/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.collections;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.hibernate.Internal;

@Internal
public final class CaseInsensitiveDictionary<V> {
    private final Map<String, V> map = new ConcurrentHashMap<String, V>();

    public V get(String key) {
        return this.map.get(CaseInsensitiveDictionary.trueKey(key));
    }

    public Set<String> unmodifiableKeySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public Set<Map.Entry<String, V>> unmodifiableEntrySet() {
        return Collections.unmodifiableSet(this.map.entrySet());
    }

    public V put(String key, V value) {
        return this.map.put(CaseInsensitiveDictionary.trueKey(key), value);
    }

    public V remove(String key) {
        return this.map.remove(CaseInsensitiveDictionary.trueKey(key));
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(CaseInsensitiveDictionary.trueKey(key));
    }

    private static String trueKey(String key) {
        return key.toLowerCase(Locale.ROOT);
    }

    public void clear() {
        this.map.clear();
    }

    public void forEach(BiConsumer<? super String, ? super V> action) {
        this.map.forEach(action);
    }
}

