/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.packager.io;

import com.typesafe.config.Config;
import com.xebialabs.deployit.util.TryWith$;
import com.xebialabs.xldeploy.packager.io.ArchiveStreamStreamer;
import com.xebialabs.xldeploy.packager.io.ArchiveStreamer;
import com.xebialabs.xldeploy.packager.io.ArtifactIOUtils$;
import com.xebialabs.xldeploy.packager.io.DirectoryStreamer;
import com.xebialabs.xldeploy.packager.io.EmptyStreamer;
import com.xebialabs.xldeploy.packager.io.FileStreamStreamer;
import com.xebialabs.xldeploy.packager.io.FileStreamer;
import com.xebialabs.xldeploy.packager.io.JarArchiveStreamStreamer;
import com.xebialabs.xldeploy.packager.io.JarFileArchiveStreamer;
import com.xebialabs.xldeploy.packager.io.Streamer;
import com.xebialabs.xldeploy.packager.io.StreamerFactory$;
import com.xebialabs.xldeploy.packager.io.SupportedArchiveExtensions$;
import com.xebialabs.xldeploy.packager.io.UnsupportedArchiveExtensionException;
import com.xebialabs.xldeploy.packager.io.ZipArchiveStreamStreamer;
import com.xebialabs.xldeploy.packager.io.ZipFileArchiveStreamStreamer;
import com.xebialabs.xldeploy.packager.io.ZipFileArchiveStreamer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\rv!B\r\u001b\u0011\u0003)c!B\u0014\u001b\u0011\u0003A\u0003\"B\u0018\u0002\t\u0003\u0001\u0004\u0002C\u0019\u0002\u0005\u0004%\t!\u0001\u001a\t\rm\n\u0001\u0015!\u00034\u0011\u0015a\u0014\u0001\"\u0001>\u0011\u001d\tY)\u0001C\u0001\u0003\u001bC\u0011\"!)\u0002#\u0003%\t!! \u0007\t\u001dR\u0002a\u0010\u0005\t\u0001\"\u0011\t\u0011)A\u0005\u0003\"Aq\n\u0003B\u0001B\u0003%A\n\u0003\u0005Q\u0011\t\u0005\t\u0015!\u0003M\u0011!\t\u0006B!A!\u0002\u0013\u0011\u0006\"B\u0018\t\t\u0003)\u0006B\u0002.\tA\u0013%1\f\u0003\u0004i\u0011\u0011\u0005!$\u001b\u0005\tm\"\t\n\u0011\"\u0001\u001bo\"9\u0011Q\u0001\u0005\u0005\u0002\u0005\u001d\u0001\u0002CA!\u0011\u0001&I!a\u0011\t\u000f\u0005\r\u0004\u0002\"\u0001\u0002f!9\u0011\u0011\u000e\u0005\u0005\u0002\u0005-\u0004\u0002CA=\u0011E\u0005I\u0011A<\t\u0013\u0005m\u0004\"%A\u0005\u0002\u0005u\u0004bBA5\u0011\u0011\u0005\u0011\u0011\u0011\u0005\b\u0003\u000bCA\u0011AAD\u0003=\u0019FO]3b[\u0016\u0014h)Y2u_JL(BA\u000e\u001d\u0003\tIwN\u0003\u0002\u001e=\u0005A\u0001/Y2lC\u001e,'O\u0003\u0002 A\u0005A\u0001\u0010\u001c3fa2|\u0017P\u0003\u0002\"E\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002G\u0005\u00191m\\7\u0004\u0001A\u0011a%A\u0007\u00025\ty1\u000b\u001e:fC6,'OR1di>\u0014\u0018p\u0005\u0002\u0002SA\u0011!&L\u0007\u0002W)\tA&A\u0003tG\u0006d\u0017-\u0003\u0002/W\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u0013\u0002\r1|wmZ3s+\u0005\u0019\u0004C\u0001\u001b:\u001b\u0005)$B\u0001\u001c8\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005A\u0014\u0001C4sSjTH.\u001a3\n\u0005i*$A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002\u001f\u0011,g-Y;mi6\u000b\u0007\u000f]5oON$\u0012A\u0010\t\u0003M!\u0019\"\u0001C\u0015\u0002\u001f\u0005\u00148\r[5wK6\u000b\u0007\u000f]5oON\u0004BAQ%M\u0019:\u00111i\u0012\t\u0003\t.j\u0011!\u0012\u0006\u0003\r\u0012\na\u0001\u0010:p_Rt\u0014B\u0001%,\u0003\u0019\u0001&/\u001a3fM&\u0011!j\u0013\u0002\u0004\u001b\u0006\u0004(B\u0001%,!\t\u0011U*\u0003\u0002O\u0017\n11\u000b\u001e:j]\u001e\f1B_5q\u000b:\u001cw\u000eZ5oO\u0006Y!.\u0019:F]\u000e|G-\u001b8h\u0003EIg.T3n_JLH\u000b\u001b:fg\"|G\u000e\u001a\t\u0003UMK!\u0001V\u0016\u0003\t1{gn\u001a\u000b\u0006}Y;\u0006,\u0017\u0005\u0006\u00016\u0001\r!\u0011\u0005\u0006\u001f6\u0001\r\u0001\u0014\u0005\u0006!6\u0001\r\u0001\u0014\u0005\b#6\u0001\n\u00111\u0001S\u0003]9W\r^!sG\"Lg/Z#oiJL8\u000b\u001e:fC6,'\u000f\u0006\u0002]?B\u0011a%X\u0005\u0003=j\u0011\u0001b\u0015;sK\u0006lWM\u001d\u0005\u0006A:\u0001\r!Y\u0001\u0005M&dW\r\u0005\u0002cM6\t1M\u0003\u0002\u001cI*\tQ-\u0001\u0003kCZ\f\u0017BA4d\u0005\u00111\u0015\u000e\\3\u0002;\u001d,G/\u0011:dQ&4X-\u00128uef\u001cFO]3b[N#(/Z1nKJ$B\u0001\u00186pc\")1n\u0004a\u0001Y\u0006\u0011\u0011n\u001d\t\u0003E6L!A\\2\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\u001c\u0005\u0006a>\u0001\r\u0001T\u0001\u0005]\u0006lW\rC\u0004s\u001fA\u0005\t\u0019A:\u0002!U\u001cXm\u0015;sK\u0006l\u0017N\\4N_\u0012,\u0007C\u0001\u0016u\u0013\t)8FA\u0004C_>dW-\u00198\u0002O\u001d,G/\u0011:dQ&4X-\u00128uef\u001cFO]3b[N#(/Z1nKJ$C-\u001a4bk2$HeM\u000b\u0002q*\u00121/_\u0016\u0002uB\u001910!\u0001\u000e\u0003qT!! @\u0002\u0013Ut7\r[3dW\u0016$'BA@,\u0003)\tgN\\8uCRLwN\\\u0005\u0004\u0003\u0007a(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00061r-\u001a;Be\u000eD\u0017N^3PkR\u0004X\u000f^*ue\u0016\fW\u000e\u0006\u0003\u0002\n\u0005u\u0002\u0007BA\u0006\u0003W\u0001b!!\u0004\u0002$\u0005\u001dRBAA\b\u0015\u0011\t\t\"a\u0005\u0002\u0013\u0005\u00148\r[5wKJ\u001c(\u0002BA\u000b\u0003/\t\u0001bY8naJ,7o\u001d\u0006\u0005\u00033\tY\"A\u0004d_6lwN\\:\u000b\t\u0005u\u0011qD\u0001\u0007CB\f7\r[3\u000b\u0005\u0005\u0005\u0012aA8sO&!\u0011QEA\b\u0005M\t%o\u00195jm\u0016|U\u000f\u001e9viN#(/Z1n!\u0011\tI#a\u000b\r\u0001\u0011Y\u0011QF\t\u0002\u0002\u0003\u0005)\u0011AA\u0018\u0005!!\u0013/\\1sW\u0012\n\u0014\u0003BA\u0019\u0003o\u00012AKA\u001a\u0013\r\t)d\u000b\u0002\b\u001d>$\b.\u001b8h!\u0011\ti!!\u000f\n\t\u0005m\u0012q\u0002\u0002\r\u0003J\u001c\u0007.\u001b<f\u000b:$(/\u001f\u0005\u0007\u0003\u007f\t\u0002\u0019A1\u0002\rQ\f'oZ3u\u0003e9W\r\u001e+be\u0006\u00138\r[5wK>+H\u000f];u'R\u0014X-Y7\u0015\r\u0005\u0015\u0013\u0011KA*!\u0011\t9%!\u0014\u000e\u0005\u0005%#\u0002BA&\u0003\u001f\t1\u0001^1s\u0013\u0011\ty%!\u0013\u0003-Q\u000b'/\u0011:dQ&4XmT;uaV$8\u000b\u001e:fC6Da!a\u0010\u0013\u0001\u0004\t\u0007bBA+%\u0001\u0007\u0011qK\u0001\u000bG>l\u0007O]3tg>\u0014\bc\u0002\u0016\u0002Z\u0005u\u0013QL\u0005\u0004\u00037Z#!\u0003$v]\u000e$\u0018n\u001c82!\r\u0011\u0017qL\u0005\u0004\u0003C\u001a'\u0001D(viB,Ho\u0015;sK\u0006l\u0017a\u00055bg\u0006\u00138\r[5wK\u0016CH/\u001a8tS>tGcA:\u0002h!)\u0001o\u0005a\u0001\u0019\u0006A1\u000f\u001e:fC6,'\u000fF\u0005]\u0003[\ny'!\u001d\u0002v!)1\u000e\u0006a\u0001Y\")\u0001\u000f\u0006a\u0001\u0019\"A\u00111\u000f\u000b\u0011\u0002\u0003\u00071/A\u0005jg\u0006\u00138\r[5wK\"A\u0011q\u000f\u000b\u0011\u0002\u0003\u0007!+\u0001\u0005gS2,7+\u001b>f\u0003I\u0019HO]3b[\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0002%M$(/Z1nKJ$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u007fR#AU=\u0015\u0007q\u000b\u0019\tC\u0003a/\u0001\u0007\u0011-\u0001\bhKR\f%o\u00195jm\u0016$\u0016\u0010]3\u0015\u00071\u000bI\tC\u0003q1\u0001\u0007A*A\u0005g_J\u001cuN\u001c4jOR\u0019a(a$\t\u000f\u0005Ee\u00011\u0001\u0002\u0014\u000611m\u001c8gS\u001e\u0004B!!&\u0002\u001e6\u0011\u0011q\u0013\u0006\u0005\u0003#\u000bIJC\u0002\u0002\u001c\n\n\u0001\u0002^=qKN\fg-Z\u0005\u0005\u0003?\u000b9J\u0001\u0004D_:4\u0017nZ\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b")
public class StreamerFactory {
    private final Map<String, String> archiveMappings;
    private final String zipEncoding;
    private final String jarEncoding;
    private final long inMemoryThreshold;

    public static long $lessinit$greater$default$4() {
        return StreamerFactory$.MODULE$.$lessinit$greater$default$4();
    }

    public static StreamerFactory forConfig(Config config) {
        return StreamerFactory$.MODULE$.forConfig(config);
    }

    public static StreamerFactory defaultMappings() {
        return StreamerFactory$.MODULE$.defaultMappings();
    }

    private Streamer getArchiveEntryStreamer(File file) {
        String mappedExt = this.getArchiveType(file.getName());
        boolean extOK = BoxesRunTime.unboxToBoolean((Object)TryWith$.MODULE$.apply((Function0 & Serializable)() -> ArtifactIOUtils$.MODULE$.getResettableInputStream(new FileInputStream(file)), (Function1 & Serializable)resettableIs -> BoxesRunTime.boxToBoolean((boolean)SupportedArchiveExtensions$.MODULE$.archiveTypeMatchesExtension(resettableIs, mappedExt, file.getName()))).get());
        String string = mappedExt;
        if (!extOK) {
            return new EmptyStreamer();
        }
        String string2 = SupportedArchiveExtensions$.MODULE$.ZIP();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return new ZipFileArchiveStreamer(file, this.zipEncoding);
        }
        String string4 = SupportedArchiveExtensions$.MODULE$.JAR();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            return new JarFileArchiveStreamer(file, this.jarEncoding);
        }
        String string6 = SupportedArchiveExtensions$.MODULE$.TAR();
        String string7 = string;
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            return new ArchiveStreamer(file, (Function1<InputStream, InputStream>)(Function1 & Serializable)is -> is);
        }
        String string8 = SupportedArchiveExtensions$.MODULE$.TARGZ();
        String string9 = string;
        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
            return new ArchiveStreamer(file, (Function1<InputStream, InputStream>)(Function1 & Serializable)is -> new GzipCompressorInputStream(is));
        }
        String string10 = SupportedArchiveExtensions$.MODULE$.TARBZ2();
        String string11 = string;
        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
            return new ArchiveStreamer(file, (Function1<InputStream, InputStream>)(Function1 & Serializable)is -> new BZip2CompressorInputStream(is));
        }
        throw new MatchError((Object)string);
    }

    public Streamer getArchiveEntryStreamStreamer(InputStream is2, String name, boolean useStreamingMode) {
        String mappedExt = this.getArchiveType(name);
        InputStream resettableIs = ArtifactIOUtils$.MODULE$.getResettableInputStream(is2);
        boolean extOK = SupportedArchiveExtensions$.MODULE$.archiveTypeMatchesExtension(resettableIs, mappedExt, name);
        boolean bl = false;
        String string = null;
        boolean bl2 = false;
        String string2 = null;
        String string3 = mappedExt;
        if (!extOK) {
            return new EmptyStreamer();
        }
        String string4 = SupportedArchiveExtensions$.MODULE$.ZIP();
        String string5 = string3;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            bl = true;
            string = string3;
            if (useStreamingMode) {
                StreamerFactory$.MODULE$.logger().debug((Function0 & Serializable)() -> "stream:2G:Creating ZipArchiveStreamStreamer (streaming) for ZIP: " + name);
                return new ZipArchiveStreamStreamer(resettableIs, this.zipEncoding);
            }
        }
        if (bl) {
            StreamerFactory$.MODULE$.logger().debug((Function0 & Serializable)() -> "stream:2G:Creating ZipFileArchiveStreamStreamer (standard) for ZIP: " + name);
            return new ZipFileArchiveStreamStreamer(resettableIs, this.zipEncoding);
        }
        String string6 = SupportedArchiveExtensions$.MODULE$.JAR();
        String string7 = string3;
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            bl2 = true;
            string2 = string3;
            if (useStreamingMode) {
                StreamerFactory$.MODULE$.logger().debug((Function0 & Serializable)() -> "stream:2G:Creating ZipArchiveStreamStreamer (streaming) for JAR: " + name);
                return new ZipArchiveStreamStreamer(resettableIs, this.jarEncoding);
            }
        }
        if (bl2) {
            StreamerFactory$.MODULE$.logger().debug((Function0 & Serializable)() -> "stream:2G:Creating JarArchiveStreamStreamer (standard) for JAR: " + name);
            return new JarArchiveStreamStreamer(resettableIs, this.jarEncoding);
        }
        String string8 = SupportedArchiveExtensions$.MODULE$.TAR();
        String string9 = string3;
        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
            return new ArchiveStreamStreamer(resettableIs, (Function1<InputStream, InputStream>)(Function1 & Serializable)is -> is);
        }
        String string10 = SupportedArchiveExtensions$.MODULE$.TARGZ();
        String string11 = string3;
        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
            return new ArchiveStreamStreamer(resettableIs, (Function1<InputStream, InputStream>)(Function1 & Serializable)is -> new GzipCompressorInputStream(is));
        }
        String string12 = SupportedArchiveExtensions$.MODULE$.TARBZ2();
        String string13 = string3;
        if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
            return new ArchiveStreamStreamer(resettableIs, (Function1<InputStream, InputStream>)(Function1 & Serializable)is -> new BZip2CompressorInputStream(is));
        }
        throw new MatchError((Object)string3);
    }

    public boolean getArchiveEntryStreamStreamer$default$3() {
        return false;
    }

    public ArchiveOutputStream<? extends ArchiveEntry> getArchiveOutputStream(File target) {
        String string = this.getArchiveType(target.getName());
        String string2 = SupportedArchiveExtensions$.MODULE$.ZIP();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return new ZipArchiveOutputStream(target);
        }
        String string4 = SupportedArchiveExtensions$.MODULE$.JAR();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            return new ZipArchiveOutputStream(target);
        }
        String string6 = SupportedArchiveExtensions$.MODULE$.TAR();
        String string7 = string;
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            return this.getTarArchiveOutputStream(target, (Function1<OutputStream, OutputStream>)(Function1 & Serializable)os -> os);
        }
        String string8 = SupportedArchiveExtensions$.MODULE$.TARGZ();
        String string9 = string;
        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
            return this.getTarArchiveOutputStream(target, (Function1<OutputStream, OutputStream>)(Function1 & Serializable)os -> new GzipCompressorOutputStream(os));
        }
        String string10 = SupportedArchiveExtensions$.MODULE$.TARBZ2();
        String string11 = string;
        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
            return this.getTarArchiveOutputStream(target, (Function1<OutputStream, OutputStream>)(Function1 & Serializable)os -> new BZip2CompressorOutputStream(os));
        }
        String originExt = (String)((Tuple2)this.archiveMappings.find((Function1 & Serializable)am -> BoxesRunTime.boxToBoolean((boolean)StreamerFactory.$anonfun$getArchiveOutputStream$4(target, am))).get())._1();
        throw new UnsupportedArchiveExtensionException(target.getName() + " with extension " + originExt + " -> " + string + " is not a supported archive output type");
    }

    private TarArchiveOutputStream getTarArchiveOutputStream(File target, Function1<OutputStream, OutputStream> compressor) {
        OutputStream wrapped = (OutputStream)compressor.apply((Object)new FileOutputStream(target));
        TarArchiveOutputStream os = new TarArchiveOutputStream(wrapped);
        os.setLongFileMode(3);
        os.setBigNumberMode(2);
        return os;
    }

    public boolean hasArchiveExtension(String name) {
        return this.archiveMappings.exists((Function1 & Serializable)am -> BoxesRunTime.boxToBoolean((boolean)StreamerFactory.$anonfun$hasArchiveExtension$1(name, am)));
    }

    public Streamer streamer(InputStream is, String name, boolean isArchive, long fileSize) {
        boolean shouldUseStreaming = fileSize > 0L && this.inMemoryThreshold > 0L && fileSize >= this.inMemoryThreshold;
        StreamerFactory$.MODULE$.logger().debug((Function0 & Serializable)() -> "stream:2G:File size: " + fileSize + ", Threshold: " + $this.inMemoryThreshold + ", shouldUseStreaming: " + shouldUseStreaming);
        if (this.hasArchiveExtension(name)) {
            return this.getArchiveEntryStreamStreamer(is, name, shouldUseStreaming);
        }
        if (isArchive) {
            if (shouldUseStreaming) {
                StreamerFactory$.MODULE$.logger().debug((Function0 & Serializable)() -> "stream:2G:Large file mode enabled for archive without extension - using ZipArchiveStreamStreamer");
                return new ZipArchiveStreamStreamer(ArtifactIOUtils$.MODULE$.getResettableInputStream(is), this.zipEncoding);
            }
            return new ZipFileArchiveStreamStreamer(ArtifactIOUtils$.MODULE$.getResettableInputStream(is), this.zipEncoding);
        }
        return new FileStreamStreamer(is, name);
    }

    public Streamer streamer(File file) {
        if (file.isDirectory()) {
            return new DirectoryStreamer(file);
        }
        if (this.hasArchiveExtension(file.getName())) {
            return this.getArchiveEntryStreamer(file);
        }
        return new FileStreamer(file);
    }

    public boolean streamer$default$3() {
        return false;
    }

    public long streamer$default$4() {
        return -1L;
    }

    public String getArchiveType(String name) {
        Some some;
        Tuple2 tuple2;
        Option option = this.archiveMappings.find((Function1 & Serializable)am -> BoxesRunTime.boxToBoolean((boolean)StreamerFactory.$anonfun$getArchiveType$1(name, am)));
        if (None$.MODULE$.equals(option)) {
            throw new UnsupportedArchiveExtensionException(name + " is not a supported archive");
        }
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            String originExt = (String)tuple2._1();
            String mappedExt = (String)tuple2._2();
            StreamerFactory$.MODULE$.logger().debug((Function0 & Serializable)() -> "Detected mapped archive extension " + originExt + " -> " + mappedExt + " for " + name);
            return mappedExt;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ boolean $anonfun$getArchiveOutputStream$4(File target$1, Tuple2 am) {
        return target$1.getName().endsWith('.' + (String)am._1()) || target$1.getName().endsWith('.' + ((String)am._1()).replace('-', '.'));
    }

    public static final /* synthetic */ boolean $anonfun$hasArchiveExtension$1(String name$2, Tuple2 am) {
        return name$2.endsWith('.' + (String)am._1()) || name$2.endsWith('.' + ((String)am._1()).replace('-', '.'));
    }

    public static final /* synthetic */ boolean $anonfun$getArchiveType$1(String name$3, Tuple2 am) {
        return name$3.endsWith('.' + (String)am._1()) || name$3.endsWith('.' + ((String)am._1()).replace('-', '.'));
    }

    public StreamerFactory(Map<String, String> archiveMappings, String zipEncoding, String jarEncoding, long inMemoryThreshold) {
        this.archiveMappings = archiveMappings;
        this.zipEncoding = zipEncoding;
        this.jarEncoding = jarEncoding;
        this.inMemoryThreshold = inMemoryThreshold;
    }
}

