/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.io;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.checksum.ChecksumAlgorithmProvider;
import com.xebialabs.deployit.engine.spi.artifact.resolution.ResolvedArtifactFile;
import com.xebialabs.deployit.io.ArtifactFile;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.xldeploy.packager.placeholders.SourceArtifactScanner;
import com.xebialabs.xldeploy.packager.placeholders.StreamFile;
import com.xebialabs.xlplatform.artifact.resolution.ArtifactResolverRegistry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

public class ArtifactFileUtils {
    private static Logger logger = LoggerFactory.getLogger(ArtifactFileUtils.class);

    public static boolean canBeResolved(Artifact artifact) {
        if (artifact != null) {
            if (artifact.getFile() instanceof ArtifactFile) {
                return ((ArtifactFile)artifact.getFile()).isResolvable();
            }
            return artifact.getFile() != null;
        }
        return false;
    }

    public static boolean hasRealOrResolvedFile(Artifact artifact) {
        OverthereFile file = artifact.getFile();
        if (file instanceof ArtifactFile) {
            return ((ArtifactFile)file).isResolved();
        }
        return file != null;
    }

    public static void checkFileConditions(SourceArtifact artifact) {
        boolean hasFileUri = StringUtils.isNotBlank((String)artifact.getFileUri());
        boolean hasUploadedFile = ArtifactFileUtils.hasRealOrResolvedFile((Artifact)artifact);
        Checks.checkTrue((hasFileUri || hasUploadedFile ? 1 : 0) != 0, (String)"Artifacts need to have either a %s set or an uploaded file", (Object[])new Object[]{"fileUri"});
        Checks.checkTrue((!hasFileUri || !hasUploadedFile ? 1 : 0) != 0, (String)"Artifacts must not have both a %s set and an uploaded file", (Object[])new Object[]{"fileUri"});
    }

    public static void handleArtifact(SourceArtifactScanner scanner, SourceArtifact artifact, ChecksumAlgorithmProvider checksumAlgorithmProvider) {
        ArtifactFileUtils.handleArtifact(scanner, artifact, checksumAlgorithmProvider, -1L);
    }

    public static void handleArtifact(SourceArtifactScanner scanner, SourceArtifact artifact, ChecksumAlgorithmProvider checksumAlgorithmProvider, Long fileSize) {
        ArtifactFileUtils.checkFileConditions(artifact);
        if (ArtifactFileUtils.hasRealOrResolvedFile((Artifact)artifact)) {
            scanner.enrichArtifact(artifact, Option.empty(), () -> ((ChecksumAlgorithmProvider)checksumAlgorithmProvider).getMessageDigest(), fileSize.longValue());
        } else {
            try (ResolvedArtifactFile resolve = ArtifactResolverRegistry.resolve(artifact);
                 InputStream is = resolve.openStream();){
                long sizeFromResolver = resolve.getFileSize();
                if (sizeFromResolver > 0L) {
                    logger.debug("stream:2G:Using file size from URI/Maven resolver: {} bytes for artifact {}", (Object)sizeFromResolver, (Object)artifact.getId());
                    scanner.enrichArtifact(artifact, Option.apply((Object)new StreamFile(resolve.getFileName(), is)), () -> ((ChecksumAlgorithmProvider)checksumAlgorithmProvider).getMessageDigest(), sizeFromResolver);
                } else {
                    logger.debug("stream:2G:Using file size from uploaded artifact: {} bytes for artifact {}", (Object)fileSize, (Object)artifact.getId());
                    scanner.enrichArtifact(artifact, Option.apply((Object)new StreamFile(resolve.getFileName(), is)), () -> ((ChecksumAlgorithmProvider)checksumAlgorithmProvider).getMessageDigest(), fileSize.longValue());
                }
                artifact.setFile(LocalFile.valueOf((File)new File(resolve.getFileName())));
            }
            catch (IOException e) {
                logger.warn("stream:2G:handleArtifact Exception: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }
}

