/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.reactive;

import org.springframework.lang.Nullable;
import org.springframework.transaction.ReactiveTransaction;
import org.springframework.util.Assert;

public class GenericReactiveTransaction
implements ReactiveTransaction {
    @Nullable
    private final String transactionName;
    @Nullable
    private final Object transaction;
    private final boolean newTransaction;
    private final boolean newSynchronization;
    private final boolean nested;
    private final boolean readOnly;
    private final boolean debug;
    @Nullable
    private final Object suspendedResources;
    private boolean rollbackOnly = false;
    private boolean completed = false;

    public GenericReactiveTransaction(@Nullable String transactionName, @Nullable Object transaction, boolean newTransaction, boolean newSynchronization, boolean nested, boolean readOnly, boolean debug, @Nullable Object suspendedResources) {
        this.transactionName = transactionName;
        this.transaction = transaction;
        this.newTransaction = newTransaction;
        this.newSynchronization = newSynchronization;
        this.nested = nested;
        this.readOnly = readOnly;
        this.debug = debug;
        this.suspendedResources = suspendedResources;
    }

    @Deprecated(since="6.1", forRemoval=true)
    public GenericReactiveTransaction(@Nullable Object transaction, boolean newTransaction, boolean newSynchronization, boolean readOnly, boolean debug, @Nullable Object suspendedResources) {
        this(null, transaction, newTransaction, newSynchronization, false, readOnly, debug, suspendedResources);
    }

    @Override
    public String getTransactionName() {
        return this.transactionName != null ? this.transactionName : "";
    }

    public Object getTransaction() {
        Assert.state((this.transaction != null ? 1 : 0) != 0, (String)"No transaction active");
        return this.transaction;
    }

    @Override
    public boolean hasTransaction() {
        return this.transaction != null;
    }

    @Override
    public boolean isNewTransaction() {
        return this.hasTransaction() && this.newTransaction;
    }

    public boolean isNewSynchronization() {
        return this.newSynchronization;
    }

    @Override
    public boolean isNested() {
        return this.nested;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isDebug() {
        return this.debug;
    }

    @Nullable
    public Object getSuspendedResources() {
        return this.suspendedResources;
    }

    @Override
    public void setRollbackOnly() {
        if (this.completed) {
            throw new IllegalStateException("Transaction completed");
        }
        this.rollbackOnly = true;
    }

    @Override
    public boolean isRollbackOnly() {
        return this.rollbackOnly;
    }

    public void setCompleted() {
        this.completed = true;
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }
}

