/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class FilteredIterator<E>
implements Iterator<E> {
    private Iterator<? extends E> iterator;
    private final Filter<E> filter;
    private E nextElement;
    private boolean hasNext;

    public FilteredIterator(Iterator<? extends E> underlyingIterator, Filter<E> whatToAccept) {
        this.iterator = underlyingIterator;
        this.filter = whatToAccept;
        this.iterateToNextMatch();
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public E next() {
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        return this.iterateToNextMatch();
    }

    private E iterateToNextMatch() {
        E oldMatch = this.nextElement;
        while (this.iterator.hasNext()) {
            E candidate = this.iterator.next();
            if (!this.filter.accept(candidate)) continue;
            this.hasNext = true;
            this.nextElement = candidate;
            return oldMatch;
        }
        this.hasNext = false;
        return oldMatch;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException(FilteredIterator.class.getSimpleName() + " can't remove underlying iterator's items as it may be few steps ahead.");
    }

    public static interface Filter<T> {
        public boolean accept(T var1);
    }

    public static final class AcceptAllFilter<T>
    implements Filter<T> {
        @Override
        public boolean accept(T item) {
            return true;
        }
    }
}

