/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.encryption;

import java.util.Map;
import org.springframework.cloud.config.server.encryption.EnvironmentPrefixHelper;
import org.springframework.cloud.config.server.encryption.TextEncryptorLocator;
import org.springframework.security.crypto.encrypt.TextEncryptor;

public class LocatorTextEncryptor
implements TextEncryptor {
    private EnvironmentPrefixHelper helper = new EnvironmentPrefixHelper();
    private TextEncryptorLocator locator;

    public LocatorTextEncryptor(TextEncryptorLocator locator) {
        this.locator = locator;
    }

    public String encrypt(String text) {
        Map<String, String> keys = this.helper.getEncryptorKeys("configserver", "default", text);
        return this.getLocator().locate(keys).encrypt(this.helper.stripPrefix(text));
    }

    private TextEncryptorLocator getLocator() {
        return this.locator;
    }

    public String decrypt(String encryptedText) {
        Map<String, String> keys = this.helper.getEncryptorKeys("configserver", "default", encryptedText);
        return this.getLocator().locate(keys).decrypt(this.helper.stripPrefix(encryptedText));
    }
}

