/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.open.support;

import com.jeta.open.support.ComponentFinder;
import com.jeta.open.support.EmptyCollection;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JMenu;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;

public class DefaultComponentFinder
implements ComponentFinder,
ContainerListener {
    private HashMap m_components;
    private WeakReference m_container_ref;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DefaultComponentFinder(Container container) {
        this.m_container_ref = new WeakReference<Container>(container);
    }

    protected void buildNames(Container container) {
        if (container != null) {
            if (container instanceof JMenu) {
                this.buildNames(((JMenu)container).getPopupMenu());
            } else {
                this.registerComponent(container);
                container.removeContainerListener(this);
                container.addContainerListener(this);
                int n = container.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    Component component = container.getComponent(i);
                    if (component instanceof Container) {
                        this.buildNames((Container)component);
                        continue;
                    }
                    this.registerComponent(component);
                }
            }
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void componentAdded(ContainerEvent containerEvent) {
        Component component = containerEvent.getChild();
        if (component instanceof TableCellRenderer || component instanceof ListCellRenderer) {
            return;
        }
        if (component instanceof Container) {
            this.buildNames((Container)component);
        } else if (component instanceof Component) {
            this.registerComponent(component);
        }
    }

    public void componentRemoved(ContainerEvent containerEvent) {
        Component component = containerEvent.getChild();
        if (component instanceof TableCellRenderer || component instanceof ListCellRenderer) {
            return;
        }
        if (component instanceof Component) {
            this.unregisterComponent(component);
        }
    }

    public void enableComponent(String string, boolean bl) {
        Component component = this.getComponentByName(string);
        if (component != null) {
            component.setEnabled(bl);
        }
    }

    public Component getComponentByName(String string) {
        WeakReference weakReference;
        if (this.m_components == null) {
            this.m_components = new HashMap();
            this.buildNames((Container)this.m_container_ref.get());
        }
        if ((weakReference = (WeakReference)this.m_components.get(string)) != null) {
            return (Component)weakReference.get();
        }
        return null;
    }

    public Collection getComponentsByName(String string) {
        Component component = this.getComponentByName(string);
        if (component == null) {
            return EmptyCollection.getInstance();
        }
        LinkedList<Component> linkedList = new LinkedList<Component>();
        linkedList.add(component);
        return linkedList;
    }

    public Container getContainer() {
        return (Container)this.m_container_ref.get();
    }

    private void registerComponent(Component component) {
        if (component == null) {
            return;
        }
        String string = component.getName();
        if (string != null && string.length() > 0) {
            this.m_components.put(string, new WeakReference<Component>(component));
        }
    }

    public void unregisterComponent(Component component) {
        if (component instanceof Container) {
            ((Container)component).removeContainerListener(this);
        }
        Iterator iterator = this.m_components.values().iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            if (weakReference != null && weakReference.get() != component) continue;
            iterator.remove();
        }
    }

    public void setVisible(String string, boolean bl) {
        Component component = this.getComponentByName(string);
        if (component != null) {
            component.setVisible(bl);
        }
    }

    public void reset() {
        this.m_components = null;
    }

    static {
        $assertionsDisabled = !DefaultComponentFinder.class.desiredAssertionStatus();
    }
}

