/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.maven;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.infinispan.commons.maven.AbstractArtifact;
import org.infinispan.commons.util.Version;

public class URLArtifact
extends AbstractArtifact {
    final URL url;

    public URLArtifact(String path) {
        try {
            this.url = new URL(path);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Path resolveArtifact() throws IOException {
        Path tmpDir = Paths.get(System.getProperty("java.io.tmpdir"), Version.getBrandName().toLowerCase().replace(' ', '_'), "cache");
        Files.createDirectories(tmpDir, new FileAttribute[0]);
        Path dest = tmpDir.resolve(URLArtifact.getFilenameFromURL(this.url));
        return URLArtifact.downloadFile(this.url, dest, this.verbose, this.force);
    }
}

