/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata;

import org.hibernate.envers.RelationTargetNotFoundAction;
import org.hibernate.envers.boot.EnversMappingException;
import org.hibernate.envers.boot.model.AttributeContainer;
import org.hibernate.envers.boot.spi.EnversMetadataBuildingContext;
import org.hibernate.envers.configuration.internal.metadata.AbstractMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.reader.PropertyAuditingData;
import org.hibernate.envers.internal.entities.EntityConfiguration;
import org.hibernate.envers.internal.entities.IdMappingData;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.entities.mapper.CompositeMapperBuilder;
import org.hibernate.envers.internal.entities.mapper.id.IdMapper;
import org.hibernate.envers.internal.entities.mapper.relation.OneToOneNotOwningMapper;
import org.hibernate.envers.internal.entities.mapper.relation.OneToOnePrimaryKeyJoinColumnMapper;
import org.hibernate.envers.internal.entities.mapper.relation.ToOneIdMapper;
import org.hibernate.envers.internal.tools.MappingTools;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;

public final class ToOneRelationMetadataGenerator
extends AbstractMetadataGenerator {
    public ToOneRelationMetadataGenerator(EnversMetadataBuildingContext metadataBuildingContext) {
        super(metadataBuildingContext);
    }

    public void addToOne(AttributeContainer mapping, PropertyAuditingData propertyAuditingData, Value value, CompositeMapperBuilder mapper, String entityName, boolean insertable) {
        boolean nonInsertableFake;
        String referencedEntityName = ((ToOne)value).getReferencedEntityName();
        IdMappingData idMapping = this.getReferencedIdMappingData(entityName, referencedEntityName, propertyAuditingData, true);
        String lastPropertyPrefix = MappingTools.createToOneRelationPrefix(propertyAuditingData.getName());
        IdMapper relMapper = idMapping.getIdMapper().prefixMappedProperties(lastPropertyPrefix);
        this.getAuditedEntityConfiguration(entityName).addToOneRelation(propertyAuditingData.getName(), referencedEntityName, relMapper, insertable, this.shouldIgnoreNotFoundRelation(propertyAuditingData, value));
        if (!insertable && propertyAuditingData.isForceInsertable()) {
            nonInsertableFake = true;
            insertable = true;
        } else {
            nonInsertableFake = false;
        }
        idMapping.getRelation().getAttributesPrefixed(lastPropertyPrefix, value.getSelectables().iterator(), false, insertable).forEach(mapping::addAttribute);
        boolean lazy = ((ToOne)value).isLazy();
        PropertyData propertyData = propertyAuditingData.resolvePropertyData();
        mapper.addComposite(propertyData, new ToOneIdMapper(relMapper, propertyData, referencedEntityName, nonInsertableFake, lazy));
    }

    public void addOneToOneNotOwning(PropertyAuditingData propertyAuditingData, Value value, CompositeMapperBuilder mapper, String entityName) {
        OneToOne propertyValue = (OneToOne)value;
        String owningReferencePropertyName = propertyValue.getReferencedPropertyName();
        EntityConfiguration configuration = this.getAuditedEntityConfiguration(entityName);
        if (configuration == null) {
            throw new EnversMappingException("An audited relation to a non-audited entity " + entityName + "!");
        }
        IdMappingData ownedIdMapping = configuration.getIdMappingData();
        if (ownedIdMapping == null) {
            throw new EnversMappingException("An audited relation to a non-audited entity " + entityName + "!");
        }
        String lastPropertyPrefix = MappingTools.createToOneRelationPrefix(owningReferencePropertyName);
        String referencedEntityName = propertyValue.getReferencedEntityName();
        IdMapper ownedIdMapper = ownedIdMapping.getIdMapper().prefixMappedProperties(lastPropertyPrefix);
        this.getAuditedEntityConfiguration(entityName).addToOneNotOwningRelation(propertyAuditingData.getName(), owningReferencePropertyName, referencedEntityName, ownedIdMapper, MappingTools.ignoreNotFound(value));
        PropertyData propertyData = propertyAuditingData.resolvePropertyData();
        mapper.addComposite(propertyData, new OneToOneNotOwningMapper(entityName, referencedEntityName, owningReferencePropertyName, propertyData, this.getMetadataBuildingContext().getServiceRegistry()));
    }

    void addOneToOnePrimaryKeyJoinColumn(PropertyAuditingData propertyAuditingData, Value value, CompositeMapperBuilder mapper, String entityName, boolean insertable) {
        String referencedEntityName = ((ToOne)value).getReferencedEntityName();
        IdMappingData idMapping = this.getReferencedIdMappingData(entityName, referencedEntityName, propertyAuditingData, true);
        String lastPropertyPrefix = MappingTools.createToOneRelationPrefix(propertyAuditingData.getName());
        IdMapper relMapper = idMapping.getIdMapper().prefixMappedProperties(lastPropertyPrefix);
        this.getAuditedEntityConfiguration(entityName).addToOneRelation(propertyAuditingData.getName(), referencedEntityName, relMapper, insertable, MappingTools.ignoreNotFound(value));
        PropertyData propertyData = propertyAuditingData.resolvePropertyData();
        mapper.addComposite(propertyData, new OneToOnePrimaryKeyJoinColumnMapper(entityName, referencedEntityName, propertyData, this.getMetadataBuildingContext().getServiceRegistry()));
    }

    private boolean shouldIgnoreNotFoundRelation(PropertyAuditingData propertyAuditingData, Value value) {
        RelationTargetNotFoundAction action = propertyAuditingData.getRelationTargetNotFoundAction();
        if (this.getMetadataBuildingContext().getConfiguration().isGlobalLegacyRelationTargetNotFound()) {
            return MappingTools.ignoreNotFound(value) || RelationTargetNotFoundAction.IGNORE.equals((Object)action);
        }
        return !RelationTargetNotFoundAction.ERROR.equals((Object)action);
    }
}

